/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Menu$callable$delete;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.Menu_Base;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.consistencyPredicates.ConsistencyPredicate;

public class Menu
extends Menu_Base
implements Wrappable,
Sluggable,
Cloneable,
Comparable<Menu> {
    public static final String SIGNAL_CREATED = "fenixedu.cms.menu.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.menu.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.menu.edited";
    private static final Logger logger;
    public static final Advice advice$delete;

    public Menu(Site site, LocalizedString name) {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
        this.setSite(site);
        this.setTopMenu(false);
        this.setName(name);
        this.setPrivileged(false);
        this.setOrder(site.getMenusSet().size());
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Site getSite() {
        return super.getSite();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Menu$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Menu this_) {
        logger.debug("Menu " + this_.getName() + " - " + this_.getExternalId() + " of site " + this_.getSite().getSlug() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)new DomainObjectEvent((DomainObject)this_));
        Sets.newHashSet((Iterable)this_.getItemsSet()).stream().distinct().forEach(MenuItem::delete);
        this_.setCreatedBy(null);
        this_.setSite(null);
        this_.deleteDomainObject();
    }

    @Override
    public void setSlug(String slug) {
        super.setSlug(SlugUtils.makeSlug(this, slug));
    }

    @Override
    public boolean isValidSlug(String slug) {
        Menu m = this.getSite().menuForSlug(slug);
        return m == null || m == this;
    }

    public void setName(LocalizedString name) {
        LocalizedString prevName = this.getName();
        super.setName(name);
        if (prevName == null) {
            String slug = StringNormalizer.slugify((String)name.getContent());
            this.setSlug(slug);
        }
    }

    public void putAt(MenuItem item, int position) {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.getToplevelItemsSet().size()) {
            item.removeFromParent();
            position = this.getToplevelItemsSet().size();
        }
        if (item.getPosition() != null) {
            item.removeFromParent();
        }
        List<MenuItem> list = this.getToplevelItemsSorted().collect(Collectors.toList());
        list.add(position, item);
        MenuItem.fixOrder(list);
        this.getToplevelItemsSet().add(item);
        this.getItemsSet().add(item);
    }

    public void remove(MenuItem mi) {
        this.getToplevelItemsSet().remove(mi);
        MenuItem.fixOrder(this.getToplevelItemsSorted().collect(Collectors.toList()));
        this.getItemsSet().remove(mi);
        MenuItem.fixOrder(this.getItemsSorted().collect(Collectors.toList()));
    }

    public void add(MenuItem mi) {
        this.putAt(mi, this.getToplevelItemsSet().size());
    }

    public Stream<MenuItem> getToplevelItemsSorted() {
        return this.getToplevelItemsSet().stream().sorted();
    }

    public Stream<MenuItem> getItemsSorted() {
        return this.getItemsSet().stream().sorted();
    }

    @Override
    public Menu clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            HashSet menuItems = new HashSet(this.getItemsSet());
            LocalizedString name = this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null;
            Menu clone = new Menu(this.getSite(), name);
            cloneCache.setClone(this, clone);
            clone.setName(name);
            clone.setOrder(this.getOrder());
            for (MenuItem menuItem : menuItems) {
                menuItem.clone(cloneCache).setMenu(clone);
            }
            return clone;
        });
    }

    @Override
    public int compareTo(Menu o) {
        return this.getOrder().compareTo(o.getOrder());
    }

    @Override
    public Wrap makeWrap() {
        return new MenuWrap();
    }

    public Wrap makeWrap(Page page) {
        return new MenuWrap(page);
    }

    public MenuItem menuItemForOid(String menuItemOid) {
        MenuItem menuItem = (MenuItem)FenixFramework.getDomainObject((String)menuItemOid);
        if (menuItem != null && FenixFramework.isDomainObjectValid((DomainObject)menuItem) && menuItem.getMenu() == this) {
            return menuItem;
        }
        return null;
    }

    @ConsistencyPredicate
    public boolean checkMenuOrder() {
        return this.getOrder() != null && this.getOrder() >= 0;
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(Menu.class);
    }

    private class MenuWrap
    extends Wrap {
        private final Page page;
        private final Stream<Wrap> children;

        public MenuWrap() {
            this.page = null;
            this.children = Menu.this.getToplevelItemsSorted().filter(MenuItem::isVisible).map(MenuItem::makeWrap);
        }

        public MenuWrap(Page page) {
            this.page = page;
            this.children = Menu.this.getToplevelItemsSorted().filter(MenuItem::isVisible).map(item -> item.makeWrap(page));
        }

        public Stream<Wrap> getChildren() {
            return this.children;
        }

        public int getOrder() {
            return Menu.this.getOrder();
        }

        public LocalizedString getName() {
            return Menu.this.getName();
        }

        public Wrap getSite() {
            return Menu.this.getSite().makeWrap();
        }

        public Boolean getTopMenu() {
            return Menu.this.getTopMenu();
        }
    }
}

