/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.cms.domain.CMSFolder$callable$delete;
import org.fenixedu.cms.domain.CMSFolder_Base;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CMSFolder
extends CMSFolder_Base {
    public static final String SIGNAL_CREATED = "fenixedu.cms.folder.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.folder.deleted";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CMSFolder(MenuContainer parent, String path, LocalizedString description) {
        this.setBennu(Bennu.getInstance());
        this.setFunctionality(new MenuFunctionality(parent, false, path, "cms", "anyone", description, description, path));
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Site resolveSite(String url) {
        if ((url = url.substring(this.getFunctionality().getFullPath().length())).startsWith("/")) {
            url = url.substring(1);
        }
        String[] parts = url.split("/");
        return this.getSiteSet().stream().filter(site -> parts[0].equals(site.getSlug())).findAny().orElse(null);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CMSFolder$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CMSFolder this_) {
        Signal.emit((String)SIGNAL_DELETED, (Object)this_.getOid());
        MenuFunctionality functionality = this_.getFunctionality();
        this_.setFunctionality(null);
        functionality.delete();
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public MenuFunctionality getFunctionality() {
        return super.getFunctionality();
    }

    public String getBaseUrl(Site site) {
        return this.getFunctionality().getFullPath().substring(1) + "/" + site.getSlug();
    }

    public static interface FolderResolver {
        public Site resolveSite(CMSFolder var1, String var2);

        public String getBaseUrl(CMSFolder var1, Site var2);
    }
}

