/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.cms.api.json.PostAdapter;
import org.fenixedu.cms.api.json.PostFileAdapter;
import org.fenixedu.cms.api.json.PostRevisionAdapter;
import org.fenixedu.cms.api.resource.PostResource$callable$createFileFromRequest;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/cms/posts")
public class PostResource
extends BennuRestResource {
    public static final Advice advice$createFileFromRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement listLatestVersion(@PathParam(value="oid") Post post) {
        return this.view(post, PostAdapter.class);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deletePost(@PathParam(value="oid") Post post) {
        PermissionEvaluation.ensureCanDoThis(post.getSite(), PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.DELETE_POSTS);
        if (post.isVisible()) {
            PermissionEvaluation.ensureCanDoThis(post.getSite(), PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.DELETE_POSTS_PUBLISHED);
        }
        if (!Authenticate.getUser().equals((Object)post.getCreatedBy())) {
            PermissionEvaluation.ensureCanDoThis(post.getSite(), PermissionsArray.Permission.EDIT_POSTS, PermissionsArray.Permission.DELETE_OTHERS_POSTS);
        }
        post.archive();
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updatePost(@PathParam(value="oid") Post post, JsonElement json) {
        return this.updatePostFromJson(post, json);
    }

    private JsonElement updatePostFromJson(Post post, JsonElement json) {
        return this.view(this.update(json, post, PostAdapter.class));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/versions")
    public JsonElement listPostVersions(@PathParam(value="oid") Post post) {
        return this.view(post.getRevisionsSet(), PostRevisionAdapter.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/files")
    public JsonElement listPostFiles(@PathParam(value="oid") Post post) {
        return this.view(post.getFilesSet(), PostFileAdapter.class);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/files")
    public JsonElement addPostFile(@PathParam(value="oid") Post post, @Context HttpServletRequest request) throws IOException, ServletException {
        this.createFileFromRequest(post, request.getPart("file"));
        return this.view(post, PostAdapter.class);
    }

    public void createFileFromRequest(Post post, Part part) throws IOException {
        Object object = advice$createFileFromRequest.perform((Callable)new PostResource$callable$createFileFromRequest(this, post, part));
    }

    static /* synthetic */ void advised$createFileFromRequest(PostResource this_, Post post, Part part) throws IOException {
        post.ensureCanEditPost();
        GroupBasedFile groupBasedFile = new GroupBasedFile(part.getName(), part.getName(), part.getInputStream(), Group.logged());
        PostFile postFile = new PostFile(post, groupBasedFile, false, 0);
        post.addFiles(postFile);
    }
}

