/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.routing;

import com.google.common.base.Strings;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.StringLoader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.servlet.SemanticURLHandler;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CMSThemeFile;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.rendering.CMSExtensions;
import org.fenixedu.cms.routing.CMSRenderer;
import org.fenixedu.cms.rss.RSSService;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSURLHandler
implements SemanticURLHandler {
    private static final Logger logger = LoggerFactory.getLogger(CMSURLHandler.class);
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"E, d MMM yyyy HH:mm:ss z");
    private CMSRenderer renderer = new CMSRenderer();

    public static String rewritePageUrl(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (requestURL.endsWith("/")) {
            requestURL = requestURL.substring(0, requestURL.length() - 1);
        }
        return queryString == null ? requestURL : requestURL + "?" + queryString;
    }

    public void handleRequest(MenuFunctionality menu, HttpServletRequest req, HttpServletResponse res, FilterChain fc) throws IOException, ServletException {
        String pageSlug = req.getRequestURI().substring(req.getContextPath().length());
        Site site = this.getSite(menu, pageSlug);
        if (site == null) {
            res.sendError(404);
            return;
        }
        res.setCharacterEncoding(Charset.defaultCharset().name());
        this.handleRequest(site, req, res, pageSlug);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(Site site, HttpServletRequest req, HttpServletResponse res, String pageSlug) throws IOException, ServletException {
        if (site.getCanViewGroup().isMember(Authenticate.getUser()) || PermissionEvaluation.canAccess(Authenticate.getUser(), site)) {
            if (site.getPublished()) {
                try {
                    String baseUrl = "/" + site.getBaseUrl();
                    if (pageSlug.startsWith(baseUrl)) {
                        pageSlug = pageSlug.substring(baseUrl.length());
                    }
                    if (pageSlug.endsWith("/") && !req.getRequestURI().equals(req.getContextPath() + "/")) {
                        this.handleLeadingSlash(req, res, site);
                        return;
                    }
                    if (pageSlug.startsWith("/static/")) {
                        this.handleStaticResource(req, res, site, pageSlug);
                        return;
                    }
                    if (pageSlug.startsWith("/rss")) {
                        this.handleRSS(req, res, site, pageSlug);
                        return;
                    }
                    this.renderer.renderCMSPage(req, res, site, pageSlug);
                    return;
                }
                catch (Exception e) {
                    logger.error("Exception while rendering CMS page " + req.getRequestURI(), (Throwable)e);
                    if (res.isCommitted()) {
                        return;
                    }
                    res.reset();
                    res.resetBuffer();
                    this.renderer.errorPage(req, res, site, 500);
                }
                return;
            }
            if (Authenticate.isLogged()) {
                this.renderer.errorPage(req, res, site, 403);
                return;
            } else {
                this.renderer.errorPage(req, res, site, 401);
            }
            return;
        }
        if (Authenticate.isLogged()) {
            this.renderer.errorPage(req, res, site, 403);
            return;
        } else {
            this.renderer.errorPage(req, res, site, 401);
        }
    }

    public void invalidateEntry(String key) {
        this.renderer.invalidateEntry(key);
    }

    private void handleRSS(HttpServletRequest req, HttpServletResponse res, Site site, String slug) throws IOException, XMLStreamException, ServletException {
        slug = slug.replaceFirst("/", "");
        Locale locale = Strings.isNullOrEmpty((String)req.getParameter("locale")) ? I18N.getLocale() : new Locale.Builder().setLanguageTag(req.getParameter("locale")).build();
        String[] parts = slug.split("/");
        if (parts.length == 1) {
            res.setContentType("application/rss+xml;charset=UTF-8");
            res.getOutputStream().write(RSSService.generateRSSForSite(site, locale).getBytes(StandardCharsets.UTF_8));
        } else {
            Category category = site.categoryForSlug(parts[1]);
            if (category == null) {
                this.renderer.errorPage(req, res, site, 404);
            } else {
                res.setContentType("application/rss+xml;charset=UTF-8");
                res.getOutputStream().write(RSSService.generateRSSForCategory(category, locale).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private Site getSite(MenuFunctionality menu, String url) {
        if (menu.getSites() != null) {
            return menu.getSites();
        }
        return Optional.ofNullable(menu.getCmsFolder()).map(x -> x.resolveSite(url)).orElse(null);
    }

    private void handleStaticResource(HttpServletRequest req, HttpServletResponse res, Site sites, String pageSlug) throws IOException, ServletException {
        byte[] bytes;
        pageSlug = pageSlug.replaceFirst("/", "");
        CMSTheme theme = sites.getTheme();
        if (theme != null && (bytes = theme.contentForPath(pageSlug)) != null) {
            CMSThemeFile templateFile = theme.fileForPath(pageSlug);
            String etag = "W/\"" + bytes.length + "-" + (Serializable)(templateFile == null ? "na" : Long.valueOf(templateFile.getLastModified().getMillis())) + "\"";
            res.setHeader("ETag", etag);
            if (etag.equals(req.getHeader("If-None-Match"))) {
                res.setStatus(304);
                return;
            }
            res.setHeader("Expires", this.formatter.print((ReadableInstant)DateTime.now().plusHours(12)));
            res.setHeader("Cache-Control", "max-age=43200");
            res.setContentLength(bytes.length);
            if (templateFile != null) {
                res.setContentType(templateFile.getContentType());
            } else {
                res.setContentType(new MimetypesFileTypeMap().getContentType(pageSlug));
            }
            res.getOutputStream().write(bytes);
            return;
        }
        res.sendError(404);
    }

    private void handleLeadingSlash(HttpServletRequest req, HttpServletResponse res, Site sites) throws PebbleException, IOException, ServletException {
        if (req.getMethod().equals("GET")) {
            res.setStatus(301);
            res.setHeader("Location", CMSURLHandler.rewritePageUrl(req));
            return;
        }
        if (req.getMethod().equals("POST")) {
            if (CoreConfiguration.getConfiguration().developmentMode().booleanValue()) {
                PebbleEngine engine = new PebbleEngine.Builder().loader((Loader)new StringLoader()).extension(new Extension[]{new CMSExtensions()}).build();
                PebbleTemplate compiledTemplate = engine.getTemplate("<html><head></head><body><h1>POST action with backslash</h1><b>You posting data with a URL with a backslash. Alter the form to post with the same URL without the backslash</body></html>");
                res.setStatus(500);
                res.setContentType("text/html");
                compiledTemplate.evaluate((Writer)res.getWriter());
            } else {
                this.renderer.errorPage(req, res, sites, 500);
            }
        }
    }
}

