/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.rendering;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.portal.servlet.LazyForTokenParser;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CMSExtensions
extends AbstractExtension {
    public Map<String, Filter> getFilters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formatDate", new DateTimeFormaterFilter());
        map.put("title", new TitleFilter());
        map.put("head", new IterableHeadFilter());
        map.put("tail", new IterableTailFilter());
        map.put("length", new LengthFilter());
        map.put("reverse", new ReverseFilter());
        return ImmutableMap.copyOf(map);
    }

    public Map<String, Test> getTests() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        tests.put("in", new InTest());
        return tests;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("i18n", new I18NFunction());
        functions.put("range", new RangeFunction());
        functions.put("entries", new MapEntriesFunction());
        functions.put("getValue", new MapValueFunction());
        return functions;
    }

    public List<TokenParser> getTokenParsers() {
        return Collections.singletonList(new LazyForTokenParser());
    }

    public class DateTimeFormaterFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"format");
        }

        public Object apply(Object input, Map<String, Object> args) {
            if (input instanceof DateTime) {
                String pattern = (String)args.get("format");
                if (pattern == null) {
                    pattern = "MMMM d, Y, H:m";
                }
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
                return fmt.print((ReadableInstant)((DateTime)input));
            }
            return "";
        }
    }

    public class TitleFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return null;
        }

        public Object apply(Object input, Map<String, Object> args) {
            if (input != null && input instanceof String) {
                return this.capitalizeFully((String)input);
            }
            return "";
        }

        private String capitalizeFully(String str) {
            char[] chars = str.toLowerCase().toCharArray();
            StringBuffer buffer = new StringBuffer(chars.length);
            boolean capitalizeNext = true;
            for (char ch : chars) {
                if (Character.isWhitespace(ch)) {
                    buffer.append(ch);
                    capitalizeNext = true;
                    continue;
                }
                if (capitalizeNext) {
                    buffer.append(Character.toTitleCase(ch));
                    capitalizeNext = false;
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
    }

    public class IterableHeadFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"iterable");
        }

        public Object apply(Object input, Map<String, Object> args) {
            return input instanceof Iterable ? Iterables.getFirst((Iterable)((Iterable)input), null) : null;
        }
    }

    public class IterableTailFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"iterable");
        }

        public Object apply(Object input, Map<String, Object> args) {
            return input instanceof Iterable ? Iterables.skip((Iterable)((Iterable)input), (int)1) : null;
        }
    }

    public class LengthFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"collection");
        }

        public Object apply(Object input, Map<String, Object> args) {
            if (input != null) {
                if (input.getClass().isArray()) {
                    return Array.getLength(input);
                }
                if (input instanceof Collection) {
                    return ((Collection)input).size();
                }
            }
            return 0;
        }
    }

    public class ReverseFilter
    implements Filter {
        public List<String> getArgumentNames() {
            return null;
        }

        public Object apply(Object input, Map<String, Object> args) {
            ArrayList list = new ArrayList();
            if (input != null && input instanceof List) {
                list.addAll((List)input);
                Collections.reverse(list);
            }
            return list;
        }
    }

    public class InTest
    implements Test {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"collection");
        }

        public boolean apply(Object input, Map<String, Object> args) {
            return ((Collection)args.get("collection")).contains(input);
        }
    }

    private static class I18NFunction
    implements Function {
        final List<String> variableArgs = ImmutableList.of((Object)"arg0", (Object)"arg1", (Object)"arg2", (Object)"arg3", (Object)"arg4", (Object)"arg5");

        private I18NFunction() {
        }

        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"bundle", (Object)"key", (Object)"arg0", (Object)"arg1", (Object)"arg2", (Object)"arg3", (Object)"arg4", (Object)"arg5");
        }

        public Object execute(Map<String, Object> args) {
            String bundle = (String)args.get("bundle");
            String key = args.get("key").toString();
            return BundleUtil.getString((String)bundle, (String)key, (String[])this.arguments(args));
        }

        public String[] arguments(Map<String, Object> args) {
            ArrayList<String> values = new ArrayList<String>();
            for (String variableArg : this.variableArgs) {
                if (!args.containsKey(variableArg) || !(args.get(variableArg) instanceof String)) continue;
                values.add((String)args.get(variableArg));
            }
            return values.toArray(new String[0]);
        }
    }

    public static class RangeFunction
    implements Function {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"from", (Object)"to");
        }

        public Object execute(Map<String, Object> args) {
            Range range = Range.closedOpen((Comparable)((Integer)args.get("from")), (Comparable)((Integer)args.get("to")));
            return ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.integers());
        }
    }

    public class MapEntriesFunction
    implements Function {
        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"map");
        }

        public Object execute(Map<String, Object> args) {
            if (args.get("map") != null && args.get("map") instanceof Map) {
                return ((Map)args.get("map")).entrySet();
            }
            return Sets.newLinkedHashSet();
        }
    }

    private static class MapValueFunction
    implements Function {
        private MapValueFunction() {
        }

        public List<String> getArgumentNames() {
            return ImmutableList.of((Object)"map", (Object)"key");
        }

        public Object execute(Map<String, Object> args) {
            Object mapObject = args.get("map");
            Object keyObject = args.get("key");
            Preconditions.checkArgument((mapObject != null && keyObject != null ? 1 : 0) != 0, (Object)"Please specify non empty 'map' and 'key'");
            Preconditions.checkArgument((boolean)(mapObject instanceof Map), (Object)("The first argument must be of type " + Map.class.getName()));
            return ((Map)mapObject).get(keyObject);
        }
    }
}

