/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.cms.domain.CMSTemplate;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.Page$callable$archive;
import org.fenixedu.cms.domain.Page$callable$delete;
import org.fenixedu.cms.domain.Page$callable$recover;
import org.fenixedu.cms.domain.Page$callable$setCanViewGroup;
import org.fenixedu.cms.domain.Page_Base;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.domain.component.StaticPost;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Page
extends Page_Base
implements Sluggable,
Cloneable {
    public static final String SIGNAL_CREATED = "fenixedu.cms.page.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.page.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.page.edited";
    public static final String SIGNAL_ARCHIVED = "fenixedu.cms.page.archived";
    public static final String SIGNAL_RECOVERED = "fenixedu.cms.page.recovered";
    public static final Comparator<Page> CREATION_DATE_COMPARATOR;
    public static Comparator<Page> PAGE_NAME_COMPARATOR;
    private static final Logger logger;
    public static final Advice advice$delete;
    public static final Advice advice$archive;
    public static final Advice advice$recover;
    public static final Advice advice$setCanViewGroup;

    public Page(Site site, LocalizedString name) {
        DateTime now = new DateTime();
        this.setCreationDate(now);
        this.setModificationDate(now);
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCanViewGroup(Group.anyone());
        this.setSite(site);
        this.setPublished(false);
        this.setName(name);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Site getSite() {
        return super.getSite();
    }

    public void setName(LocalizedString name) {
        LocalizedString prevName = this.getName();
        super.setName(name);
        this.setModificationDate(new DateTime());
        if (prevName == null) {
            this.setSlug(StringNormalizer.slugify((String)name.getContent()));
        }
    }

    @Override
    public void setSlug(String slug) {
        super.setSlug(SlugUtils.makeSlug(this, slug));
    }

    @Override
    public boolean isValidSlug(String slug) {
        try {
            return this == this.getSite().getArchivedPagesSet().stream().filter(page -> page.getSlug() != null).filter(page -> page.getSlug().equals(slug)).findAny().orElse(this.getSite().pageForSlug(slug));
        }
        catch (CmsDomainException cmsDomainException) {
            return true;
        }
    }

    public Component componentForOid(String oid) {
        for (Component c : this.getComponentsSet()) {
            if (!c.getExternalId().equals(oid)) continue;
            return c;
        }
        return null;
    }

    public void removeComponents(Component components) {
        logger.debug("Page " + this.getSlug() + " - " + this.getExternalId() + " of Site " + this.getSite().getSlug() + " component " + components.getType() + " removed by user " + Authenticate.getUser().getUsername());
        super.removeComponents(components);
    }

    public void addComponents(Component components) {
        logger.debug("Page " + this.getSlug() + " - " + this.getExternalId() + " of Site " + this.getSite().getSlug() + " component " + components.getType() + " added by user " + Authenticate.getUser().getUsername());
        super.addComponents(components);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Page$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Page this_) {
        logger.debug("Page " + this_.getSlug() + " - " + this_.getExternalId() + " of Site " + this_.getSite().getSlug() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)this_.getOid());
        for (Component component : this_.getComponentsSet()) {
            this_.removeComponents(component);
            component.delete();
        }
        this_.getMenuItemsSet().stream().forEach(MenuItem::delete);
        this_.setTemplate(null);
        this_.setSite(null);
        this_.setCreatedBy(null);
        this_.setViewGroup(null);
        this_.deleteDomainObject();
    }

    public void archive() {
        Object object = advice$archive.perform((Callable)new Page$callable$archive(this));
    }

    static /* synthetic */ void advised$archive(Page this_) {
        this_.setPublished(false);
        this_.getStaticPost().ifPresent(post -> post.setActive(false));
        this_.setArchivedSite(this_.getSite());
        this_.setSite(null);
        this_.getMenuItemsSet().stream().forEach(MenuItem::delete);
        Signal.emit((String)SIGNAL_ARCHIVED, (Object)this_.getOid());
    }

    public void recover() {
        Object object = advice$recover.perform((Callable)new Page$callable$recover(this));
    }

    static /* synthetic */ void advised$recover(Page this_) {
        this_.setSite(this_.getArchivedSite());
        this_.setArchivedSite(null);
        Signal.emit((String)SIGNAL_RECOVERED, (Object)this_.getOid());
    }

    public String getAddress() {
        if (this.getSite() == null) {
            return null;
        }
        return CoreConfiguration.getConfiguration().applicationUrl() + "/" + this.getSite().getBaseUrl() + "/" + this.getSlug();
    }

    public Group getCanViewGroup() {
        return this.getViewGroup().toGroup();
    }

    public void setCanViewGroup(Group group) {
        Object object = advice$setCanViewGroup.perform((Callable)new Page$callable$setCanViewGroup(this, group));
    }

    static /* synthetic */ void advised$setCanViewGroup(Page this_, Group group) {
        this_.setViewGroup(group.toPersistentGroup());
    }

    public static Page create(Site site, Menu menu, MenuItem parent, LocalizedString name, boolean published, String template, User creator, Component ... components) {
        Page page = new Page(site, name);
        if (components != null && components.length > 0) {
            for (Component component : components) {
                page.addComponents(component);
            }
        }
        page.setTemplate(site.getTheme().templateForType(template));
        if (creator == null) {
            page.setCreatedBy(site.getCreatedBy());
        } else {
            page.setCreatedBy(creator);
        }
        page.setPublished(published);
        if (menu != null) {
            MenuItem.create(menu, page, name, parent);
        }
        return page;
    }

    public void setPublished(boolean published) {
        this.setModificationDate(new DateTime());
        super.setPublished(published);
    }

    public void setTemplate(CMSTemplate template) {
        this.setModificationDate(new DateTime());
        super.setTemplate(template);
        if (template != null) {
            this.setTemplateType(template.getType());
        } else {
            this.setTemplateType(null);
        }
        logger.debug("Page " + this.getSlug() + " of Site " + this.getSite().getSlug() + " template changed by user " + Authenticate.getUser());
    }

    public boolean isPublished() {
        return this.getPublished();
    }

    public String getRssUrl() {
        for (Component component : this.getComponentsSet()) {
            ListCategoryPosts listPosts;
            if (!(component instanceof ListCategoryPosts) || (listPosts = (ListCategoryPosts)((Object)component)).getCategory() == null) continue;
            return listPosts.getCategory().getRssUrl();
        }
        return null;
    }

    public String getEditUrl() {
        if (this.isStaticPage()) {
            return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/pages/" + this.getSite().getSlug() + "/" + this.getSlug() + "/edit";
        }
        return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/pages/advanced/" + this.getSite().getSlug() + "/" + this.getSlug() + "/edit";
    }

    public CMSTemplate getTemplateFromSuper() {
        return super.getTemplate();
    }

    public CMSTemplate getTemplate() {
        String templateType = this.getTemplateType();
        if (templateType == null) {
            return null;
        }
        CMSTemplate template = super.getTemplate();
        CMSTheme theme = this.getSite().getTheme();
        if (templateType != null) {
            if (template != null && template.getTheme() == theme && template.getType().equals(templateType)) {
                return template;
            }
            if (theme != null && (template = theme.templateForType(templateType)) != null) {
                return template;
            }
            if (theme.getDefaultTemplate() != null) {
                return theme.getDefaultTemplate();
            }
            return CMSTheme.getDefaultTheme().getDefaultTemplate();
        }
        return null;
    }

    public boolean isStaticPage() {
        return this.getComponentsSet().stream().filter(component -> StaticPost.class.isInstance(component)).findAny().isPresent();
    }

    public Optional<Post> getStaticPost() {
        return this.getComponentsSet().stream().filter(component -> StaticPost.class.isInstance(component)).map(component -> ((StaticPost)((Object)((Object)component))).getPost()).findFirst();
    }

    @Override
    public Page clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            HashSet components = new HashSet(this.getComponentsSet());
            LocalizedString name = this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null;
            Page clone = new Page(this.getSite(), name);
            cloneCache.setClone(this, clone);
            clone.setCanViewGroup(this.getCanViewGroup());
            clone.setPublished(this.getPublished());
            clone.setCreatedBy(this.getCreatedBy());
            clone.setModificationDate(this.getModificationDate());
            clone.setCreationDate(this.getCreationDate());
            clone.setTemplateType(this.getTemplateType());
            clone.setViewGroup(this.getViewGroup());
            components.stream().map(c -> c.clone(cloneCache)).forEach(clone::addComponents);
            return clone;
        });
    }

    public boolean isEmbedded() {
        return this.getEmbedded();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$archive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$recover = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setCanViewGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CREATION_DATE_COMPARATOR = Comparator.comparing(Page_Base::getCreationDate).reversed();
        PAGE_NAME_COMPARATOR = Comparator.comparing(Page_Base::getName);
        logger = LoggerFactory.getLogger(Page.class);
    }
}

