/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.cms.domain.Category$callable$delete;
import org.fenixedu.cms.domain.Category_Base;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Category
extends Category_Base
implements Wrappable,
Sluggable,
Cloneable {
    private static final long NUM_RECENT = 10L;
    public static final String SIGNAL_CREATED = "fenixedu.cms.category.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.category.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.category.edited";
    public static final Comparator<? super Category> CATEGORY_NAME_COMPARATOR;
    public static final Advice advice$delete;

    public Category(Site site, LocalizedString name) {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
        this.setSite(site);
        this.setName(name);
        this.setPrivileged(false);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Site getSite() {
        return super.getSite();
    }

    public void setName(LocalizedString name) {
        LocalizedString prevName = this.getName();
        super.setName(name);
        if (prevName == null) {
            this.setSlug(StringNormalizer.slugify((String)name.getContent()));
        }
    }

    @Override
    public void setSlug(String slug) {
        super.setSlug(SlugUtils.makeSlug(this, slug));
    }

    @Override
    public boolean isValidSlug(String slug) {
        try {
            Category c = this.getSite().categoryForSlug(slug);
            return c == this;
        }
        catch (CmsDomainException cmsDomainException) {
            return true;
        }
    }

    public String getAddress() {
        Page viewCategoryPage = this.getSite().getViewCategoryPage();
        return viewCategoryPage == null ? null : viewCategoryPage.getAddress() + "/" + this.getSlug();
    }

    public String getRssUrl() {
        return this.getSite().getRssUrl() + "/" + this.getSlug();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Category$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Category this_) {
        Signal.emit((String)SIGNAL_DELETED, (Object)this_.getOid());
        this_.setCreatedBy(null);
        this_.setSite(null);
        this_.getComponentsSet().stream().forEach(Component::delete);
        this_.getPostsSet().stream().forEach(post -> post.removeCategories(this));
        this_.deleteDomainObject();
    }

    @Override
    public Category clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            HashSet posts = new HashSet(this.getPostsSet());
            HashSet components = new HashSet(this.getComponentsSet());
            LocalizedString name = this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null;
            Category clone = new Category(this.getSite(), name);
            cloneCache.setClone(this, clone);
            posts.stream().map(post -> post.clone(cloneCache)).forEach(arg_0 -> ((Category)clone).addPosts(arg_0));
            components.stream().filter(ListCategoryPosts.class::isInstance).map(ListCategoryPosts.class::cast).forEach(arg_0 -> ((Category)clone).addComponents(arg_0));
            return clone;
        });
    }

    @Override
    public Wrap makeWrap() {
        return new CategoryWrap();
    }

    public String getEditUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/categories/" + this.getSite().getSlug() + "/" + this.getSlug();
    }

    public List<Post> getLatestPosts() {
        return this.getPostsSet().stream().sorted(Post.CREATION_DATE_COMPARATOR).collect(Collectors.toList());
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CATEGORY_NAME_COMPARATOR = Comparator.comparing(Category_Base::getName);
    }

    public class CategoryWrap
    extends Wrap {
        public LocalizedString getName() {
            return Category.this.getName();
        }

        public String getAddress() {
            return Category.this.getAddress();
        }

        public String getSlug() {
            return Category.this.getSlug();
        }

        public DateTime getCreationDate() {
            return Category.this.getCreationDate();
        }

        public String getRssUrl() {
            return Category.this.getRssUrl();
        }
    }
}

