/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.gson.JsonObject;
import java.util.Objects;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.CMSComponent;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.StrategyBasedComponent_Base;
import org.fenixedu.cms.rendering.TemplateContext;

public final class StrategyBasedComponent
extends StrategyBasedComponent_Base {
    private StrategyBasedComponent(CMSComponent component) {
        this.setBennu(Bennu.getInstance());
        this.setComponent(Objects.requireNonNull(component));
    }

    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        this.getComponent().handle(page, componentContext, globalContext);
    }

    public StrategyBasedComponent clone(CloneCache cloneCache) {
        return this;
    }

    public Class<?> componentType() {
        return this.getComponent().getClass();
    }

    public JsonObject json() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        return json;
    }

    static Component componentForType(Class<? extends CMSComponent> type) {
        return (Component)((Object)Bennu.getInstance().getCmsComponentsSet().stream().filter(component -> component.getComponent().getClass().equals(type)).findAny().orElseGet(() -> {
            try {
                return new StrategyBasedComponent((CMSComponent)type.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public void delete() {
    }
}

