/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Page_Base;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ComponentContextProvider;
import org.fenixedu.cms.domain.component.ComponentParameter;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.component.DynamicComponent;
import org.fenixedu.cms.domain.component.ListCategoryPosts$callable$delete;
import org.fenixedu.cms.domain.component.ListCategoryPosts_Base;
import org.fenixedu.cms.domain.component.PostsPresentationBean;
import org.fenixedu.cms.rendering.TemplateContext;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@ComponentType(name="List Category Posts", description="Lists the Posts from a given category")
public class ListCategoryPosts
extends ListCategoryPosts_Base {
    private static final int POSTS_PER_PAGE = 5;
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @DynamicComponent
    public ListCategoryPosts(@ComponentParameter(provider=CategoriesForSite.class, value="Category", required=false) Category cat) {
        this.setCategory(cat);
    }

    @DynamicComponent
    private ListCategoryPosts(JsonObject json) {
        this(Site.fromSlug(json.get("site").getAsString()).categoryForSlug(json.get("category").getAsString()));
    }

    public void handle(Page page, TemplateContext local, TemplateContext global) {
        String slug = global.getRequestContext().length > 1 ? global.getRequestContext()[1] : null;
        Category category = this.getCategory() != null ? this.getCategory() : page.getSite().categoryForSlug(slug);
        local.put("category", category.makeWrap());
        global.put("category", category.makeWrap());
        PostsPresentationBean postsPresentation = new PostsPresentationBean(category.getPostsSet());
        int currentPage = postsPresentation.currentPage(global.getParameter("p"));
        HashMap<String, Object> pagination = postsPresentation.paginate(page, currentPage, 5);
        List posts = postsPresentation.getVisiblePosts().stream().collect(Collectors.toList());
        local.put("posts", posts);
        local.put("pagination", pagination);
        global.put("posts", posts);
        global.put("pagination", pagination);
    }

    public Component clone(CloneCache cloneCache) {
        return (Component)((Object)cloneCache.getOrClone(this, obj -> {
            ListCategoryPosts clone = new ListCategoryPosts((Category)null);
            cloneCache.setClone(this, (Cloneable)((Object)clone));
            clone.setCategory(this.getCategory().clone(cloneCache));
            return clone;
        }));
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ListCategoryPosts$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ListCategoryPosts this_) {
        this_.setCategory(null);
        super.delete();
    }

    public JsonObject json() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getType());
        jsonObject.addProperty("category", this.getCategory().getSlug());
        jsonObject.addProperty("site", this.getCategory().getSite().getSlug());
        jsonObject.addProperty("page", (String)Optional.ofNullable(this.getPage()).map(Page_Base::getSlug).orElse(null));
        return jsonObject;
    }

    public String getName() {
        String name = super.getName();
        if (this.getCategory() != null) {
            return name + " (" + this.getCategory().getName().getContent() + ")";
        }
        return name;
    }

    public Page getPage() {
        if (this.getInstalledPageSet().isEmpty()) {
            return null;
        }
        return (Page)this.getInstalledPageSet().iterator().next();
    }

    public static class CategoriesForSite
    implements ComponentContextProvider<Category> {
        @Override
        public Collection<Category> provide(Page page) {
            return page.getSite().getCategoriesSet();
        }

        @Override
        public String present(Category category) {
            return category.getName().getContent();
        }
    }
}

