/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.ui;

import com.google.common.base.Strings;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;

public class SearchUtils {
    public static List<Site> searchSites(Collection<Site> allSites, String query) {
        return allSites.stream().filter(site -> SearchUtils.matches(site, query.toLowerCase())).sorted(Site.NAME_COMPARATOR).collect(Collectors.toList());
    }

    public static List<Post> searchPosts(Collection<Post> allPosts, String query) {
        return allPosts.stream().filter(post -> SearchUtils.matches(post, query)).collect(Collectors.toList());
    }

    public static List<PostFile> searchFiles(Collection<PostFile> allPostFiles, String query) {
        return allPostFiles.stream().filter(post -> SearchUtils.matches(post, query)).collect(Collectors.toList());
    }

    public static Collection<Page> searchPages(Collection<Page> allPages, String query) {
        return allPages.stream().filter(page -> SearchUtils.matches(page, query)).collect(Collectors.toSet());
    }

    private static boolean matches(Post post, String query) {
        return SearchUtils.containsContent(post.getName(), query) || SearchUtils.containsContent(post.getBody(), query) || post.getCategoriesSet().stream().filter(cat -> SearchUtils.matches(cat, query)).findAny().isPresent();
    }

    private static boolean matches(Page page, String query) {
        return SearchUtils.containsContent(page.getName(), query) || SearchUtils.containsContent(page.getSlug(), query) || SearchUtils.containsContent(page.getAddress(), query) || SearchUtils.containsContent(page.getCreatedBy(), query);
    }

    private static boolean matches(Category category, String query) {
        return SearchUtils.containsContent(category.getName(), query);
    }

    private static boolean containsContent(LocalizedString localized, String query) {
        return localized != null && !localized.isEmpty() && SearchUtils.contentFor(localized).filter(content -> SearchUtils.containsContent(content, query)).findAny().isPresent();
    }

    private static boolean containsContent(String str, String query) {
        return !Strings.isNullOrEmpty((String)str) && str.toLowerCase().contains(query);
    }

    private static Stream<String> contentFor(LocalizedString localized) {
        return localized.getLocales().stream().map(locale -> localized.getContent(locale)).filter(content -> !Strings.isNullOrEmpty((String)content));
    }

    public static boolean matches(Site site, String query) {
        return SearchUtils.containsContent(site.getName(), query) || SearchUtils.containsContent(site.getDescription(), query) || SearchUtils.containsContent(site.getSlug(), query) || SearchUtils.containsContent(site.getCreatedBy(), query);
    }

    private static boolean containsContent(User user, String query) {
        return user != null && user.getProfile() != null && SearchUtils.containsContent(user.getProfile().getFullName(), query);
    }

    private static boolean matches(PostFile postFile, String query) {
        return postFile.getFiles().getDisplayName().contains(query) || postFile.getFiles().getFilename().contains(query) || SearchUtils.matches(postFile.getPost(), query);
    }

    public static class Partition<T> {
        private final List<T> partitionItems;
        private final int currentPartitionNumber;
        private final int itemsPerPartition;
        private final int numPartitions;

        public Partition(Collection<T> allItems, Comparator<T> comparator, int itemsPerPartition, int currentPartition) {
            this.itemsPerPartition = itemsPerPartition;
            this.numPartitions = IntMath.divide((int)allItems.size(), (int)itemsPerPartition, (RoundingMode)RoundingMode.CEILING);
            this.currentPartitionNumber = Math.min(this.numPartitions, Math.max(1, currentPartition));
            this.partitionItems = allItems.stream().sorted(comparator).skip((currentPartition - 1) * itemsPerPartition).limit(itemsPerPartition).collect(Collectors.toList());
        }

        public List<T> getItems() {
            return this.partitionItems;
        }

        public int getItemsPerPartition() {
            return this.itemsPerPartition;
        }

        public int getNumber() {
            return this.currentPartitionNumber;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public boolean isFirst() {
            return this.getNumber() == 1;
        }

        public boolean isLast() {
            return this.getNumber() == this.getNumPartitions();
        }
    }
}

