/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Base64;
import org.apache.tika.Tika;
import org.joda.time.DateTime;

public class CMSThemeFile {
    private static final Tika tika = new Tika();
    private final String fullPath;
    private final byte[] content;
    private final String contentType;
    private final String fileName;
    private final DateTime lastModified;

    public CMSThemeFile(String filename, String fullPath, byte[] content) {
        this.fileName = filename;
        this.fullPath = fullPath;
        this.content = content;
        this.contentType = tika.detect(content, filename);
        this.lastModified = DateTime.now();
    }

    CMSThemeFile(JsonObject json) {
        this.fileName = json.get("fileName").getAsString();
        this.fullPath = json.get("fullPath").getAsString();
        this.contentType = json.get("contentType").getAsString();
        this.content = Base64.getDecoder().decode(json.get("content").getAsString());
        this.lastModified = new DateTime(json.get("lastModified").getAsLong());
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.content.length;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("fileName", this.fileName);
        json.addProperty("fullPath", this.fullPath);
        json.addProperty("contentType", this.contentType);
        json.addProperty("content", Base64.getEncoder().encodeToString(this.content));
        json.addProperty("lastModified", (Number)this.lastModified.getMillis());
        return json;
    }
}

