/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.bennu.io.servlet.FileDownloadServlet;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.exceptions.CmsDomainException;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=PostFile.class)
public class PostFileAdapter
implements JsonAdapter<PostFile> {
    public PostFile create(JsonElement json, JsonBuilder ctx) {
        return null;
    }

    public PostFile update(JsonElement json, PostFile postFile, JsonBuilder ctx) {
        if (postFile.getPost() != null && postFile.getPost().isStaticPost()) {
            PermissionEvaluation.ensureCanDoThis(postFile.getSite(), PermissionsArray.Permission.SEE_PAGES, PermissionsArray.Permission.EDIT_PAGE);
        } else {
            PermissionEvaluation.ensureCanDoThis(postFile.getSite(), PermissionsArray.Permission.EDIT_POSTS);
        }
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("index") && !jObj.get("index").isJsonNull()) {
            postFile.setIndex(jObj.get("index").getAsInt());
        }
        if (jObj.has("isEmbedded") && !jObj.get("isEmbedded").isJsonNull()) {
            postFile.setIsEmbedded(jObj.get("isEmbedded").getAsBoolean());
        }
        if (jObj.has("accessGroup") && !jObj.get("accessGroup").isJsonNull()) {
            postFile.getFiles().setAccessGroup(Group.parse((String)jObj.get("accessGroup").getAsString()));
        }
        Signal.emit((String)"fenixedu.cms.postFile.edited", (Object)new DomainObjectEvent((DomainObject)postFile));
        return postFile;
    }

    public JsonElement view(PostFile postFile, JsonBuilder ctx) {
        if (postFile.getPost() != null && postFile.getPost().isStaticPost()) {
            PermissionEvaluation.ensureCanDoThis(postFile.getSite(), PermissionsArray.Permission.SEE_PAGES);
        }
        JsonObject json = new JsonObject();
        json.addProperty("id", postFile.getExternalId());
        json.addProperty("index", (Number)postFile.getIndex());
        json.addProperty("isEmbedded", Boolean.valueOf(postFile.getIsEmbedded()));
        json.addProperty("post", postFile.getPost().getExternalId());
        GroupBasedFile file = postFile.getFiles();
        json.addProperty("checksum", file.getChecksum());
        json.addProperty("contentType", file.getContentType());
        json.addProperty("displayName", file.getDisplayName());
        json.addProperty("filename", file.getFilename());
        json.addProperty("size", (Number)file.getSize());
        if (file.getAccessGroup() != null) {
            if (!file.getAccessGroup().isMember(Authenticate.getUser())) {
                throw CmsDomainException.forbiden();
            }
            json.addProperty("accessGroup", file.getAccessGroup().getPresentationName());
        }
        json.addProperty("url", FileDownloadServlet.getDownloadUrl((GenericFile)file));
        return json;
    }
}

