/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain.component;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.CMSComponent;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ComponentContextProvider;
import org.fenixedu.cms.domain.component.ComponentParameter;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.component.DynamicComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class ComponentDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ComponentDescriptor.class);
    private final Class<?> type;
    private final String name;
    private final boolean stateless;
    private final Map<String, ComponentParameterDescriptor> parameters = new HashMap<String, ComponentParameterDescriptor>();
    private final Constructor<?> ctor;
    private final Constructor<?> jsonCtor;
    private final Method filter;

    ComponentDescriptor(Class<?> type) {
        this.type = type;
        ComponentType ann = type.getAnnotation(ComponentType.class);
        this.name = ann.name();
        this.stateless = CMSComponent.class.isAssignableFrom(type);
        this.filter = ComponentDescriptor.getMethodIfAvailable(type, "supportsSite", Site.class);
        if (!this.stateless) {
            this.ctor = this.getCustomCtor(type);
            this.jsonCtor = this.getJsonCtor(type);
            for (Parameter param : this.ctor.getParameters()) {
                this.parameters.put(param.getName(), new ComponentParameterDescriptor(param));
            }
        } else {
            this.ctor = null;
            this.jsonCtor = null;
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        ComponentDescriptor.notNull(clazz, "Class must not be null");
        ComponentDescriptor.notNull(methodName, "Method name must not be null");
        if (paramTypes != null) {
            return ComponentDescriptor.getMethodOrNull(clazz, methodName, paramTypes);
        }
        Set<Method> candidates = ComponentDescriptor.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    private static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String methodName) {
        Method[] methods;
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        return candidates;
    }

    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... paramTypes) {
        ComponentDescriptor.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException var3) {
            return null;
        }
    }

    private Constructor<?> getCustomCtor(Class<?> type) {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (!ctor.isAnnotationPresent(DynamicComponent.class) || this.isJsonConstructor(ctor)) continue;
            return ctor;
        }
        return ComponentDescriptor.getConstructorIfAvailable(type, new Class[0]);
    }

    private Constructor<?> getJsonCtor(Class<?> type) {
        return Stream.of(type.getDeclaredConstructors()).filter(this::isJsonConstructor).findFirst().orElse(null);
    }

    private boolean isJsonConstructor(Constructor<?> constructor) {
        return constructor.isAnnotationPresent(DynamicComponent.class) && Stream.of(constructor.getParameterTypes()).filter(parameterType -> JsonObject.class.isAssignableFrom((Class<?>)parameterType)).findAny().isPresent();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isForSite(Site site) {
        try {
            return this.filter == null ? true : (Boolean)this.filter.invoke(null, site);
        }
        catch (Exception e) {
            logger.warn("Exception when running component site filter, returning true!", (Throwable)e);
            return true;
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.getName());
        json.addProperty("name", this.name);
        json.addProperty("stateless", Boolean.valueOf(this.stateless));
        return json;
    }

    public JsonArray getParameterDescription(Page page) {
        JsonArray array = new JsonArray();
        this.parameters.values().stream().forEach(param -> array.add((JsonElement)param.toJson(page)));
        return array;
    }

    public Component instantiate(JsonObject params) throws Exception {
        Object[] arguments = new Object[this.ctor.getParameterCount()];
        for (int i = 0; i < this.ctor.getParameterCount(); ++i) {
            Parameter parameter = this.ctor.getParameters()[i];
            ComponentParameterDescriptor descriptor = this.parameters.get(parameter.getName());
            String value = params.has(parameter.getName()) ? params.get(parameter.getName()).getAsString() : null;
            Class<?> type = parameter.getType();
            Object coercedValue = descriptor.type.coerce(type, value);
            if (coercedValue == null && descriptor.isRequired()) {
                throw new IllegalArgumentException("Required parameter " + parameter.getName() + " was not found!");
            }
            arguments[i] = coercedValue;
        }
        return (Component)this.ctor.newInstance(arguments);
    }

    public Component fromJson(JsonObject jsonObject) throws Exception {
        Optional.ofNullable(this.jsonCtor).orElseThrow(() -> new RuntimeException("Components of type '" + this.getType() + "' don't have a JSON constructor"));
        this.jsonCtor.setAccessible(true);
        return (Component)this.jsonCtor.newInstance(jsonObject);
    }

    private class ComponentParameterDescriptor {
        private final ComponentParameter ann;
        private final ParameterType type;
        private final Parameter parameter;
        private final ComponentContextProvider<Object> provider;

        public ComponentParameterDescriptor(Parameter parameter) {
            this.parameter = parameter;
            this.ann = parameter.getAnnotation(ComponentParameter.class);
            this.type = this.getType(parameter.getType());
            this.provider = this.findProviderMethod();
        }

        private ComponentContextProvider<Object> findProviderMethod() {
            try {
                return this.ann.provider().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Exception while creating provider", e);
            }
        }

        private ParameterType getType(Class<?> parameterClass) {
            if (String.class == parameterClass) {
                return ParameterType.STRING;
            }
            if (Number.class.isAssignableFrom(parameterClass)) {
                return ParameterType.NUMBER;
            }
            if (Enum.class.isAssignableFrom(parameterClass)) {
                return ParameterType.ENUM;
            }
            if (DomainObject.class.isAssignableFrom(parameterClass)) {
                return ParameterType.DOMAIN_OBJECT;
            }
            if (Boolean.class.isAssignableFrom(parameterClass)) {
                return ParameterType.BOOLEAN;
            }
            throw new IllegalArgumentException("ComponentParameter parameter is not supported!");
        }

        public JsonObject toJson(Page page) {
            JsonObject json = new JsonObject();
            json.addProperty("key", this.parameter.getName());
            json.addProperty("title", this.ann.value());
            json.addProperty("type", this.type.name());
            json.addProperty("required", Boolean.valueOf(this.ann.required()));
            JsonArray values = new JsonArray();
            Iterable<?> possibleValues = this.getPossibleValues(page);
            for (Object value : possibleValues) {
                JsonObject obj = new JsonObject();
                obj.addProperty("value", this.type.stringify(value));
                obj.addProperty("label", this.provider.present(value));
                values.add((JsonElement)obj);
            }
            json.add("values", (JsonElement)values);
            return json;
        }

        private Iterable<?> getPossibleValues(Page page) {
            if (this.parameter.getType().isEnum() && this.provider instanceof ComponentContextProvider.EmptyProvider) {
                return Arrays.asList(this.parameter.getType().getEnumConstants());
            }
            return this.provider.provide(page);
        }

        public boolean isRequired() {
            return this.ann.required();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParameterType {
        STRING,
        NUMBER{

            @Override
            public Object coerce(Class<?> type, String value) throws Exception {
                return ComponentDescriptor.getMethodIfAvailable(type, "valueOf", String.class).invoke(null, value);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Object coerce(Class<?> type, String value) {
                return Boolean.valueOf(value);
            }
        }
        ,
        ENUM{

            @Override
            public String stringify(Object object) {
                return ((Enum)object).name();
            }

            @Override
            public Object coerce(Class<?> type, String value) {
                return Enum.valueOf(type, value);
            }
        }
        ,
        DOMAIN_OBJECT{

            @Override
            public String stringify(Object object) {
                return ((DomainObject)object).getExternalId();
            }

            @Override
            public Object coerce(Class<?> type, String value) {
                return FenixFramework.getDomainObject((String)value);
            }
        };


        public String stringify(Object object) {
            return String.valueOf(object);
        }

        public Object coerce(Class<?> type, String value) throws Exception {
            return value;
        }
    }
}

