/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import java.io.IOException;
import java.util.Comparator;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.bennu.io.servlet.FileDownloadServlet;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile_Base;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import pt.ist.fenixframework.DomainObject;

public class PostFile
extends PostFile_Base
implements Comparable<PostFile>,
Wrappable,
Cloneable {
    public static final String SIGNAL_CREATED = "fenixedu.cms.postFile.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.postFile.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.postFile.edited";
    public static final Comparator<PostFile> NAME_COMPARATOR = Comparator.comparing(postFile -> postFile.getFiles().getDisplayName());

    public PostFile(Post post, GroupBasedFile file, boolean isEmbedded, int index) {
        this.setSite(post.getSite());
        this.setPost(post);
        this.setFiles(file);
        this.setIsEmbedded(isEmbedded);
        this.setIndex(index);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    @Override
    public PostFile clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            try {
                GroupBasedFile fileClone = new GroupBasedFile(this.getFiles().getDisplayName(), this.getFiles().getFilename(), this.getFiles().getStream(), this.getFiles().getAccessGroup());
                return new PostFile(this.getPost(), fileClone, this.getIsEmbedded(), this.getIndex());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not clone file " + this.getFiles().getDisplayName());
            }
        });
    }

    public void setIsEmbedded(boolean isEmbedded) {
        if (isEmbedded) {
            this.getFiles().setAccessGroup(this.getPost().getCanViewGroup());
        }
        super.setIsEmbedded(isEmbedded);
    }

    @Override
    public int compareTo(PostFile o) {
        return this.getIndex().compareTo(o.getIndex());
    }

    public void delete() {
        Signal.emit((String)SIGNAL_DELETED, (Object)this.getOid());
        this.setSite(null);
        this.setPost(null);
        if (this.getFiles() != null) {
            GroupBasedFile fileToDelete = this.getFiles();
            this.setFiles(null);
            fileToDelete.delete();
        }
        this.deleteDomainObject();
    }

    public String getEditUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/media/" + this.getSite().getSlug() + "/" + this.getExternalId() + "/edit";
    }

    @Override
    public Wrap makeWrap() {
        return new PostFileWrap();
    }

    public class PostFileWrap
    extends Wrap {
        public String getName() {
            return PostFile.this.getFiles().getDisplayName();
        }

        public String getContentType() {
            return PostFile.this.getFiles().getContentType();
        }

        public String getUrl() {
            return FileDownloadServlet.getDownloadUrl((GenericFile)PostFile.this.getFiles());
        }
    }
}

