/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=Page.class)
public class PageAdapter
implements JsonAdapter<Page> {
    public Page create(JsonElement json, JsonBuilder ctx) {
        return null;
    }

    public Page update(JsonElement json, Page page, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(page.getSite(), PermissionsArray.Permission.SEE_PAGES, PermissionsArray.Permission.EDIT_PAGE);
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            page.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            page.setSlug(jObj.get("slug").getAsString());
        }
        if (jObj.has("published") && !jObj.get("published").isJsonNull()) {
            page.setPublished(jObj.get("published").getAsBoolean());
        }
        Signal.emit((String)"fenixedu.cms.page.edited", (Object)new DomainObjectEvent((DomainObject)page));
        return page;
    }

    public JsonElement view(Page page, JsonBuilder ctx) {
        PermissionEvaluation.ensureCanDoThis(page.getSite(), PermissionsArray.Permission.SEE_PAGES);
        JsonObject json = new JsonObject();
        json.addProperty("id", page.getExternalId());
        json.add("creationDate", ctx.view((Object)page.getCreationDate(), DateTimeViewer.class));
        json.add("modificationDate", ctx.view((Object)page.getModificationDate(), DateTimeViewer.class));
        json.addProperty("published", Boolean.valueOf(page.getPublished()));
        json.addProperty("site", page.getSite().getExternalId());
        if (page.getCreatedBy() != null) {
            json.addProperty("createdBy", page.getCreatedBy().getUsername());
        }
        if (page.getName() != null) {
            json.add("name", ctx.view((Object)page.getName(), LocalizedStringViewer.class));
        }
        if (page.getSlug() != null) {
            json.addProperty("slug", page.getSlug());
        }
        return json;
    }
}

