/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.cms.api.json.PageAdapter;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;

@Path(value="/cms/pages")
public class PageResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement getPage(@PathParam(value="oid") Page page) {
        return this.view(page, PageAdapter.class);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updatePage(@PathParam(value="oid") Page page, JsonElement json) {
        return this.updatePageFromJson(page, json);
    }

    private JsonElement updatePageFromJson(Page page, JsonElement json) {
        return this.view(this.update(json, page, PageAdapter.class));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deletePage(@PathParam(value="oid") Page page) {
        PermissionEvaluation.ensureCanDoThis(page.getSite(), PermissionsArray.Permission.SEE_PAGES, PermissionsArray.Permission.EDIT_PAGE, PermissionsArray.Permission.DELETE_PAGE);
        page.archive();
        return Response.ok().build();
    }
}

