/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.Role_Base;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;

public class Role
extends Role_Base {
    private static final Logger logger = LoggerFactory.getLogger(Role.class);
    public static final String SIGNAL_CREATED = "fenixedu.cms.role.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.role.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.role.edited";

    public Role(RoleTemplate template, Site site) {
        this.setRoleTemplate(template);
        this.setSite(site);
        this.setGroup(Group.nobody());
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public void delete() {
        logger.debug("Role " + this.getName().getContent() + " -  " + this.getExternalId() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)this.getOid());
        this.setRoleTemplate(null);
        this.setSite(null);
        this.setPersistentGroup(null);
        super.deleteDomainObject();
    }

    public void setGroup(Group group) {
        logger.debug("Role " + this.getName().getContent() + " - " + this.getExternalId() + " changed to " + group.getExpression() + " by user " + Authenticate.getUser().getUsername());
        this.setPersistentGroup(group.toPersistentGroup());
    }

    public Group getGroup() {
        if (this.getPersistentGroup() == null) {
            return Group.nobody();
        }
        return this.getPersistentGroup().toGroup();
    }

    public LocalizedString getName() {
        return this.getRoleTemplate() != null ? this.getRoleTemplate().getName() : new LocalizedString();
    }
}

