/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.Post$callable$archive;
import org.fenixedu.cms.domain.Post$callable$delete;
import org.fenixedu.cms.domain.Post$callable$recover;
import org.fenixedu.cms.domain.Post$callable$setCanViewGroup;
import org.fenixedu.cms.domain.PostContentRevision;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.domain.PostFile_Base;
import org.fenixedu.cms.domain.Post_Base;
import org.fenixedu.cms.domain.Sanitization;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.SlugUtils;
import org.fenixedu.cms.domain.Sluggable;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.StaticPost;
import org.fenixedu.cms.domain.wraps.UserWrap;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Post
extends Post_Base
implements Wrappable,
Sluggable,
Cloneable {
    public static final String SIGNAL_CREATED = "fenixedu.cms.post.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.post.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.post.edited";
    public static final String SIGNAL_ARCHIVED = "fenixedu.cms.post.archived";
    public static final String SIGNAL_RECOVERED = "fenixedu.cms.post.recovered";
    public static final Comparator<Post> CREATION_DATE_COMPARATOR;
    private static final Logger logger;
    private static final Object NONE;
    public static final Advice advice$delete;
    public static final Advice advice$archive;
    public static final Advice advice$recover;
    public static final Advice advice$setCanViewGroup;

    public Post(Site site) {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        DateTime now = new DateTime();
        this.setCreationDate(now);
        this.setModificationDate(now);
        this.setActive(false);
        this.setCanViewGroup(Group.anyone());
        this.setSite(site);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Site getSite() {
        return super.getSite();
    }

    public void setName(LocalizedString name) {
        LocalizedString prevName = this.getName();
        super.setName(name);
        this.setModificationDate(new DateTime());
        if (prevName == null) {
            String slug = StringNormalizer.slugify((String)name.getContent());
            this.setSlug(slug);
        }
    }

    @Override
    public void setSlug(String slug) {
        super.setSlug(SlugUtils.makeSlug(this, slug));
    }

    @Override
    public boolean isValidSlug(String slug) {
        Post p = this.getSite().getArchivedPostsSet().stream().filter(post -> post.getSlug() != null).filter(post -> post.getSlug().equals(slug)).findAny().orElse(this.getSite().postForSlug(slug));
        return p == null || p == this;
    }

    public String getAddress() {
        if (this.isStaticPost()) {
            return this.getStaticPage().get().getAddress();
        }
        if (this.getSite() == null) {
            return null;
        }
        return Optional.ofNullable(this.getSite().getViewPostPage()).map(page -> page.getAddress() + "/" + this.getSlug()).orElse(null);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Post$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Post this_) {
        logger.debug("Post " + this_.getSlug() + " - " + this_.getExternalId() + " of Site " + this_.getSite().getSlug() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)this_.getOid());
        this_.setCreatedBy(null);
        this_.setSite(null);
        this_.setViewGroup(null);
        this_.deleteFiles();
        this_.setLatestRevision(null);
        this_.getComponentSet().stream().forEach(Component::delete);
        this_.getCategoriesSet().stream().forEach(category -> category.removePosts(this));
        this_.getRevisionsSet().stream().forEach(PostContentRevision::delete);
        this_.deleteDomainObject();
    }

    public void archive() {
        Object object = advice$archive.perform((Callable)new Post$callable$archive(this));
    }

    static /* synthetic */ void advised$archive(Post this_) {
        this_.setActive(false);
        this_.setArchivedSite(this_.getSite());
        this_.setSite(null);
        Signal.emit((String)SIGNAL_ARCHIVED, (Object)this_.getOid());
    }

    public void recover() {
        Object object = advice$recover.perform((Callable)new Post$callable$recover(this));
    }

    static /* synthetic */ void advised$recover(Post this_) {
        this_.setSite(this_.getArchivedSite());
        this_.setArchivedSite(null);
        Signal.emit((String)SIGNAL_RECOVERED, (Object)this_.getOid());
    }

    public boolean hasPublicationPeriod() {
        return this.getPublicationBegin() != null && this.getPublicationEnd() != null;
    }

    public boolean isInPublicationPeriod() {
        boolean inBegin = this.getPublicationBegin() == null || this.getPublicationBegin().isBeforeNow();
        boolean inEnd = this.getPublicationEnd() == null || this.getPublicationEnd().isAfterNow();
        return inBegin && inEnd;
    }

    public boolean isVisible() {
        return this.getActive() && (!this.hasPublicationPeriod() || this.isInPublicationPeriod());
    }

    public Group getCanViewGroup() {
        return this.getViewGroup().toGroup();
    }

    public void setCanViewGroup(Group group) {
        Object object = advice$setCanViewGroup.perform((Callable)new Post$callable$setCanViewGroup(this, group));
    }

    static /* synthetic */ void advised$setCanViewGroup(Post this_, Group group) {
        super.setViewGroup(group.toPersistentGroup());
        Set groupMembers = group.getMembers().collect(Collectors.toSet());
        this_.getEmbeddedFilesSorted().forEach(postFile -> postFile.getFiles().setAccessGroup(group));
        this_.getAttachmentFilesSorted().map(PostFile_Base::getFiles).filter(file -> !file.getAccessGroup().getMembers().allMatch(groupMembers::contains)).forEach(file -> file.setAccessGroup(group));
    }

    public static Post create(Site site, Page page, LocalizedString name, LocalizedString body, LocalizedString excerpt, Category category, boolean active, User creator) {
        Post post = new Post(site);
        post.setName(name);
        post.setBodyAndExcerpt(body, excerpt);
        post.setCreationDate(new DateTime());
        if (creator == null) {
            post.setCreatedBy(page.getCreatedBy());
        } else {
            post.setCreatedBy(creator);
        }
        post.addCategories(category);
        post.setActive(active);
        return post;
    }

    public String getEditUrl() {
        return this.getStaticPage().map(Page::getEditUrl).orElse(CoreConfiguration.getConfiguration().applicationUrl() + "/cms/posts/" + this.getSite().getSlug() + "/" + this.getSlug() + "/edit");
    }

    public void fixOrder(List<PostFile> sortedItems) {
        for (int i = 0; i < sortedItems.size(); ++i) {
            sortedItems.get(i).setIndex(i);
        }
    }

    @Override
    public Post clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            HashSet categories = new HashSet(this.getCategoriesSet());
            ArrayList<PostFile> files = new ArrayList<PostFile>(this.getFilesSorted());
            Post clone = new Post(this.getSite());
            cloneCache.setClone(this, clone);
            clone.setBodyAndExcerpt(this.getBody() != null ? LocalizedString.fromJson((JsonElement)this.getBody().json()) : null, this.getExcerpt() != null ? LocalizedString.fromJson((JsonElement)this.getExcerpt().json()) : null);
            clone.setName(this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null);
            clone.setBodyAndExcerpt(this.getBody() != null ? LocalizedString.fromJson((JsonElement)this.getBody().json()) : null, this.getExcerpt() != null ? LocalizedString.fromJson((JsonElement)this.getExcerpt().json()) : null);
            clone.setLocation(this.getLocation() != null ? LocalizedString.fromJson((JsonElement)this.getLocation().json()) : null);
            clone.setMetadata(this.getMetadata() != null ? this.getMetadata().clone() : null);
            clone.setCanViewGroup(this.getCanViewGroup());
            clone.setPublicationBegin(this.getPublicationBegin());
            clone.setPublicationEnd(this.getPublicationEnd());
            clone.setCreatedBy(this.getCreatedBy());
            clone.setCreationDate(this.getCreationDate());
            clone.setViewGroup(this.getViewGroup());
            categories.stream().map(category -> category.clone(cloneCache)).forEach(clone::addCategories);
            files.stream().map(file -> file.clone(cloneCache)).forEach(clone::addFiles);
            return clone;
        });
    }

    public Stream<PostFile> getAttachmentFilesSorted() {
        return this.getFilesSet().stream().filter(pf -> !pf.getIsEmbedded()).sorted();
    }

    public Stream<PostFile> getEmbeddedFilesSorted() {
        return this.getFilesSet().stream().filter(pf -> pf.getIsEmbedded()).sorted();
    }

    private void deleteFiles() {
        ImmutableList.copyOf((Collection)this.getFilesSet()).forEach(PostFile::delete);
    }

    public List<PostFile> getFilesSorted() {
        return this.getFilesSet().stream().sorted().collect(Collectors.toList());
    }

    public void addFiles(PostFile postFile) {
        List<PostFile> list = this.getFilesSorted();
        list.add(postFile.getIndex(), postFile);
        this.fixOrder(list);
        super.addFiles(postFile);
    }

    public void removeFiles(PostFile files) {
        List<PostFile> list = this.getFilesSorted();
        list.remove(files);
        this.fixOrder(list);
        super.removeFiles(files);
    }

    public void addCategories(Category categories) {
        DateTime now = new DateTime();
        super.addCategories(categories);
        categories.getComponentsSet().forEach(component -> {
            if (component.getPage() != null) {
                component.getPage().setModificationDate(now);
            }
        });
        this.setModificationDate(now);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.setModificationDate(new DateTime());
    }

    public void setBody(LocalizedString body) {
        this.setBodyAndExcerpt(body, null);
    }

    public void setBodyAndExcerpt(LocalizedString body, LocalizedString excerpt) {
        PostContentRevision pcr = new PostContentRevision();
        pcr.setBody(body);
        pcr.setExcerpt(excerpt);
        pcr.setCreatedBy(Authenticate.getUser());
        pcr.setPrevious(this.getLatestRevision());
        pcr.setPost(this);
        pcr.setRevisionDate(new DateTime());
        this.setLatestRevision(pcr);
        this.setModificationDate(new DateTime());
        logger.debug("New post revision " + this.getSlug() + " - " + this.getExternalId() + " of Site " + this.getSite().getSlug() + " created by user " + Authenticate.getUser().getUsername());
    }

    public LocalizedString getExcerpt() {
        PostContentRevision pcr = this.getLatestRevision();
        if (pcr == null) {
            return new LocalizedString();
        }
        return pcr.getExcerpt();
    }

    public LocalizedString getBody() {
        PostContentRevision pcr = this.getLatestRevision();
        if (pcr == null) {
            return new LocalizedString();
        }
        return pcr.getBody();
    }

    public LocalizedString getPresentationBody() {
        return this.getBody();
    }

    public void setLocation(LocalizedString location) {
        super.setLocation(location);
        this.setModificationDate(new DateTime());
    }

    public void setPublicationEnd(DateTime publicationEnd) {
        super.setPublicationEnd(publicationEnd);
        this.setModificationDate(new DateTime());
    }

    public void setPublicationBegin(DateTime publicationBegin) {
        super.setPublicationBegin(publicationBegin);
        this.setModificationDate(new DateTime());
    }

    public String getCategories() {
        return this.getCategoriesSet().stream().map(x -> x.getName().getContent()).reduce((x, y) -> x + "," + y).orElse("");
    }

    public String getCategoriesString() {
        return this.getCategoriesSet().stream().map(x -> x.getName().getContent()).reduce((x, y) -> x + "," + y).orElse("");
    }

    public Optional<Page> getStaticPage() {
        return this.getComponentSet().stream().filter(component -> StaticPost.class.isInstance(component)).map(component -> component.getPage()).findFirst();
    }

    public boolean isStaticPost() {
        return this.getComponentSet().stream().filter(component -> StaticPost.class.isInstance(component)).findAny().isPresent();
    }

    @Override
    public Wrap makeWrap() {
        return new PostWrap();
    }

    public boolean isAccessible() {
        return this.getCanViewGroup().isMember(Authenticate.getUser());
    }

    public boolean isModified() {
        return !this.getCreationDate().toLocalDate().equals((Object)this.getModificationDate().toLocalDate());
    }

    public static LocalizedString sanitize(LocalizedString original) {
        return Sanitization.sanitize(original);
    }

    public Iterator<PostContentRevision> getRevisionsIterator() {
        return new Iterator<PostContentRevision>(){
            PostContentRevision t = (PostContentRevision)NONE;

            @Override
            public boolean hasNext() {
                return this.t.getNext() != null;
            }

            @Override
            public PostContentRevision next() {
                this.t = this.t == NONE ? Post.this.getLatestRevision() : this.t.getNext();
                return this.t;
            }
        };
    }

    public Iterable<PostContentRevision> getRevisions() {
        return () -> this.getRevisionsIterator();
    }

    public boolean canDelete() {
        HashSet<PermissionsArray.Permission> required = new HashSet<PermissionsArray.Permission>();
        required.add(PermissionsArray.Permission.DELETE_POSTS);
        if (!Authenticate.getUser().equals((Object)this.getCreatedBy())) {
            required.add(PermissionsArray.Permission.DELETE_OTHERS_POSTS);
        }
        if (this.isVisible()) {
            required.add(PermissionsArray.Permission.DELETE_POSTS_PUBLISHED);
        }
        return PermissionEvaluation.canDoThis(this.getSite(), required.toArray(new PermissionsArray.Permission[0]));
    }

    public boolean canEdit() {
        ArrayList<PermissionsArray.Permission> permissions = new ArrayList<PermissionsArray.Permission>();
        permissions.add(PermissionsArray.Permission.EDIT_POSTS);
        if (!Authenticate.getUser().equals((Object)this.getCreatedBy())) {
            permissions.add(PermissionsArray.Permission.EDIT_OTHERS_POSTS);
        }
        if (this.isVisible()) {
            permissions.add(PermissionsArray.Permission.EDIT_POSTS_PUBLISHED);
        }
        return PermissionEvaluation.canDoThis(this.getSite(), permissions.toArray(new PermissionsArray.Permission[0]));
    }

    public void ensureCanEditPost() {
        this.ensureCanEditPost(this.getSite());
    }

    public void ensureCanEditPost(Site site) {
        PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_POSTS);
        if (!Authenticate.getUser().equals((Object)this.getCreatedBy())) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_OTHERS_POSTS);
        }
        if (this.isVisible()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.EDIT_POSTS_PUBLISHED);
        }
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$archive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$recover = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setCanViewGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CREATION_DATE_COMPARATOR = Comparator.comparing(Post_Base::getCreationDate).reversed();
        logger = LoggerFactory.getLogger(Post.class);
        NONE = new Object();
    }

    public class PostWrap
    extends Wrap {
        public LocalizedString getName() {
            return Post.this.getName();
        }

        public String getSlug() {
            return Post.this.getSlug();
        }

        public boolean isVisible() {
            return Post.this.getCanViewGroup().isMember(Authenticate.getUser());
        }

        public String getVisibilityGroup() {
            return Post.this.getCanViewGroup().toPersistentGroup().getPresentationName();
        }

        public LocalizedString getExcerpt() {
            return Post.this.getExcerpt();
        }

        public LocalizedString getBody() {
            return Post.this.getBody();
        }

        public Wrap getCreatedBy() {
            return new UserWrap(Post.this.getCreatedBy());
        }

        public DateTime getCreationDate() {
            return Post.this.getCreationDate();
        }

        public DateTime getPublicationBegin() {
            return Post.this.getPublicationBegin();
        }

        public DateTime getPublicationEnd() {
            return Post.this.getPublicationEnd();
        }

        public DateTime getModificationDate() {
            return Post.this.getModificationDate();
        }

        public Wrap getSite() {
            return Post.this.getSite().makeWrap();
        }

        public String getAddress() {
            return Post.this.getAddress();
        }

        public String getEditAddress() {
            return CoreConfiguration.getConfiguration().applicationUrl() + "/cms/posts/" + Post.this.getSite().getSlug() + "/" + Post.this.getSlug() + "/edit";
        }

        public List<Wrap> getCategories() {
            return Post.this.getCategoriesSet().stream().map(Wrap::make).collect(Collectors.toList());
        }

        public List<Wrap> getAttachments() {
            return Post.this.getAttachmentFilesSorted().map(PostFile::makeWrap).collect(Collectors.toList());
        }

        public Wrap getMetadata() {
            return Post.this.getMetadata().makeWrap();
        }
    }
}

