/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.CloneCache;
import org.fenixedu.cms.domain.Cloneable;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem$callable$delete;
import org.fenixedu.cms.domain.MenuItem_Base;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.consistencyPredicates.ConsistencyPredicate;

public class MenuItem
extends MenuItem_Base
implements Comparable<MenuItem>,
Wrappable,
Cloneable {
    public static final Comparator<MenuItem> CREATION_DATE_COMPARATOR;
    public static final String SIGNAL_CREATED = "fenixedu.cms.menuItem.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.menuItem.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.menuItem.edited";
    private static final Logger logger;
    public static final Advice advice$delete;

    public MenuItem(Menu menu) {
        if (Authenticate.getUser() == null) {
            throw CmsDomainException.forbiden();
        }
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
        this.setFolder(false);
        this.setMenu(menu);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Menu getMenu() {
        return super.getMenu();
    }

    public void putAt(MenuItem item, int position) {
        if (item.getPosition() != null) {
            item.removeFromParent();
        }
        if (position < 0) {
            position = 0;
        } else if (position > this.getChildrenSet().size()) {
            item.removeFromParent();
            position = this.getChildrenSet().size();
        }
        ArrayList list = Lists.newArrayList(this.getChildrenSorted());
        list.add(position, item);
        MenuItem.fixOrder(list);
        item.setMenu(this.getMenu());
        this.getChildrenSet().add(item);
    }

    public void remove(MenuItem mi) {
        ArrayList items = Lists.newArrayList(this.getChildrenSorted());
        items.remove(mi);
        MenuItem.fixOrder(items);
        this.removeChildren(mi);
    }

    public void add(MenuItem mi) {
        this.putAt(mi, this.getChildrenSet().size());
    }

    public void removeFromParent() {
        if (this.getTop() != null) {
            this.getTop().remove(this);
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.setTop(null);
        this.setParent(null);
    }

    public List<MenuItem> getChildrenSorted() {
        return this.getChildrenSet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    public String getAddress() {
        if (this.getFolder()) {
            return "#";
        }
        if (this.getUrl() != null) {
            return this.getUrl();
        }
        return this.getPage().getAddress();
    }

    @ConsistencyPredicate
    public boolean parentOrTop() {
        return this.getTop() == null || this.getParent() == null;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MenuItem$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MenuItem this_) {
        logger.debug("Menu item " + this_.getName().toString() + " - " + this_.getExternalId() + " of site " + this_.getMenu().getSite().getSlug() + " deleted by user " + Authenticate.getUser().getUsername());
        Signal.emit((String)SIGNAL_DELETED, (Object)new DomainObjectEvent((DomainObject)this_.getMenu()));
        ArrayList items = Lists.newArrayList((Iterable)this_.getChildrenSet());
        this_.removeFromParent();
        items.forEach(i -> this.remove((MenuItem)i));
        this_.setCreatedBy(null);
        this_.setMenu(null);
        this_.setPage(null);
        this_.deleteDomainObject();
    }

    @Override
    public int compareTo(MenuItem o) {
        return this.getPosition() - o.getPosition();
    }

    public Integer getPosition() {
        return Optional.ofNullable(super.getPosition()).orElse(0);
    }

    public static void fixOrder(List<MenuItem> sortedItems) {
        for (int i = 0; i < sortedItems.size(); ++i) {
            sortedItems.get(i).setPosition(i);
        }
    }

    public static MenuItem create(Menu menu, Page page, LocalizedString name, MenuItem parent) {
        MenuItem menuItem = new MenuItem(menu);
        menuItem.setName(name);
        menuItem.setPage(page);
        menuItem.setFolder(page == null);
        if (menu != null) {
            if (parent != null) {
                parent.add(menuItem);
            } else {
                menu.add(menuItem);
            }
        }
        return menuItem;
    }

    @Override
    public MenuItem clone(CloneCache cloneCache) {
        return cloneCache.getOrClone(this, obj -> {
            MenuItem clone = new MenuItem(null);
            cloneCache.setClone(this, clone);
            clone.setName(this.getName() != null ? LocalizedString.fromJson((JsonElement)this.getName().json()) : null);
            clone.setPosition(this.getPosition());
            clone.setFolder(this.getFolder());
            clone.setUrl(this.getUrl());
            clone.setPage(this.getPage() != null ? this.getPage().clone(cloneCache) : null);
            clone.setParent(this.getParent() != null ? this.getParent().clone(cloneCache) : null);
            clone.setTop(this.getTop() != null ? this.getTop().clone(cloneCache) : null);
            return clone;
        });
    }

    @Override
    public Wrap makeWrap() {
        return new MenuItemWrap();
    }

    public Wrap makeWrap(Page page) {
        return new MenuItemWrap(page);
    }

    public boolean isVisible() {
        return this.getPage() == null || this.getPage().getPublished();
    }

    public boolean isEmbedded() {
        return this.getPage() != null && this.getPage().isEmbedded();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CREATION_DATE_COMPARATOR = Comparator.comparing(MenuItem_Base::getCreationDate);
        logger = LoggerFactory.getLogger(MenuItem.class);
    }

    public class MenuItemWrap
    extends Wrap {
        private final boolean active;
        private final boolean open;
        private final boolean embedded;
        private final List<Wrap> children;

        public MenuItemWrap() {
            this.children = MenuItem.this.getChildrenSorted().stream().filter(MenuItem::isVisible).map(menuItem -> menuItem.makeWrap()).collect(Collectors.toList());
            this.active = false;
            this.open = false;
            this.embedded = false;
        }

        public MenuItemWrap(Page page) {
            this.open = MenuItem.this.getPage() != null && MenuItem.this.getPage().equals(page);
            this.embedded = page != null && page.isEmbedded();
            this.children = ImmutableList.copyOf((Collection)MenuItem.this.getChildrenSorted().stream().filter(m -> m.isVisible() && !m.isEmbedded()).map(menuItem -> menuItem.makeWrap(page)).collect(Collectors.toList()));
            this.active = this.open || this.children.stream().anyMatch(item -> ((MenuItemWrap)item).open || ((MenuItemWrap)item).active);
        }

        public List<Wrap> getChildren() {
            return this.children;
        }

        public LocalizedString getName() {
            return MenuItem.this.getName();
        }

        public String getAddress() {
            return MenuItem.this.getAddress();
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isOpen() {
            return this.open;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public boolean isFolder() {
            return MenuItem.this.getFolder();
        }

        public String getRssUrl() {
            Page page = MenuItem.this.getPage();
            return page == null ? null : page.getRssUrl();
        }
    }
}

