/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.cms.CMSConfigurationManager;
import org.fenixedu.cms.domain.CMSTemplate;
import org.fenixedu.cms.domain.CMSTemplate_Base;
import org.fenixedu.cms.domain.CMSTheme$callable$changeFiles;
import org.fenixedu.cms.domain.CMSTheme$callable$delete;
import org.fenixedu.cms.domain.CMSThemeFile;
import org.fenixedu.cms.domain.CMSThemeFiles;
import org.fenixedu.cms.domain.CMSThemeLoader;
import org.fenixedu.cms.domain.CMSTheme_Base;
import org.fenixedu.cms.domain.Site;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CMSTheme
extends CMSTheme_Base {
    public static final String SIGNAL_CREATED = "fenixedu.cms.theme.created";
    public static final String SIGNAL_DELETED = "fenixedu.cms.theme.deleted";
    public static final String SIGNAL_EDITED = "fenixedu.cms.theme.edited";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$changeFiles = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CMSTheme() {
        this.setCreatedBy(Authenticate.getUser());
        this.setCreationDate(new DateTime());
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public static CMSTheme forType(String t) {
        for (CMSTheme theme : Bennu.getInstance().getCMSThemesSet()) {
            if (!theme.getType().equals(t)) continue;
            return theme;
        }
        return null;
    }

    public static void loadDefaultTheme() {
        InputStream in = CMSTheme.class.getResourceAsStream("/META-INF/resources/WEB-INF/cms-default-theme.zip");
        ZipInputStream zin = new ZipInputStream(in);
        CMSThemeLoader.createFromZipStream(zin);
    }

    public static CMSTheme getDefaultTheme() {
        return Bennu.getInstance().getCMSThemesSet().stream().filter(x -> x.isDefault()).findAny().orElseThrow(() -> new RuntimeException("There is no default theme"));
    }

    public CMSTemplate templateForType(String type) {
        CMSTemplate found = this.getTemplatesSet().stream().filter(template -> template.getType().equals(type)).findFirst().orElse(null);
        if (found == null && this.getExtended() != null) {
            return this.getExtended().templateForType(type);
        }
        return found;
    }

    public CMSThemeFile fileForPath(String path) {
        CMSThemeFile file = this.getFiles().getFileForPath(path);
        if (file == null && this.getExtended() != null) {
            return this.getExtended().fileForPath(path);
        }
        return file;
    }

    private static String getTypeForThemeFolder(String path) {
        try {
            FileInputStream fin = new FileInputStream(path + "/theme.json");
            JsonObject el = new JsonParser().parse((Reader)new BufferedReader(new InputStreamReader(fin))).getAsJsonObject();
            return el.get("type").getAsString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] contentForPath(String t) {
        String themeDevelopmentDirectory = CMSConfigurationManager.getConfiguration().themeDevelopmentDirectory();
        if (CoreConfiguration.getConfiguration().developmentMode().booleanValue() && CMSConfigurationManager.isInThemeDevelopmentMode() && this.getType().equals(CMSTheme.getTypeForThemeFolder(themeDevelopmentDirectory))) {
            try {
                return ByteStreams.toByteArray((InputStream)new FileInputStream(themeDevelopmentDirectory + t));
            }
            catch (FileNotFoundException e) {
                if (this.getExtended() != null) {
                    return this.getExtended().contentForPath(t);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        CMSThemeFile file = this.fileForPath(t);
        return file == null ? null : file.getContent();
    }

    public boolean definesPath(String string) {
        return this.contentForPath(string) != null;
    }

    public boolean isDefault() {
        return Bennu.getInstance().getDefaultCMSTheme() == this;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CMSTheme$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CMSTheme this_) {
        if (this_.getChildrenSet().size() != 0) {
            throw new RuntimeException("Themes depend of this theme. Can't delete");
        }
        Signal.emit((String)SIGNAL_DELETED, (Object)new DomainObjectEvent((DomainObject)this_));
        this_.setPrimaryBennu(null);
        this_.setBennu(null);
        for (Site site : this_.getSitesSet()) {
            site.setTheme(null);
        }
        if (this_.isDefault()) {
            if (Bennu.getInstance().getCMSThemesSet().size() == 0) {
                Bennu.getInstance().setDefaultCMSTheme(null);
            } else {
                Bennu.getInstance().setDefaultCMSTheme((CMSTheme)((Object)Bennu.getInstance().getCMSThemesSet().iterator().next()));
            }
        }
        this_.setCreatedBy(null);
        this_.setExtended(null);
        this_.getTemplatesSet().forEach(CMSTemplate::delete);
        if (this_.getPreviewImage() != null) {
            GroupBasedFile f = this_.getPreviewImage();
            this_.setPreviewImage(null);
            f.delete();
        }
        this_.deleteDomainObject();
    }

    public String getAssetsPath() {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/api/cms/assets/" + this.getType() + "/" + this.getFiles().getChecksum();
    }

    public void changeFiles(CMSThemeFiles cMSThemeFiles) {
        Object object = advice$changeFiles.perform((Callable)new CMSTheme$callable$changeFiles(this, cMSThemeFiles));
    }

    static /* synthetic */ void advised$changeFiles(CMSTheme this_, CMSThemeFiles files) {
        if (this_.getFiles() == null || !this_.getFiles().checksumMatches(files)) {
            this_.setFiles(files);
        }
    }

    public Set<CMSTemplate> getAllTemplates() {
        return Sets.union((Set)this.getTemplatesSet(), this.getExtendedTemplates());
    }

    public Set<CMSTemplate> getExtendedTemplates() {
        if (this.getExtended() != null) {
            Set myTemplateTypes = this.getTemplatesSet().stream().map(CMSTemplate_Base::getType).collect(Collectors.toSet());
            Predicate<CMSTemplate> isInherited = parentTemplate -> myTemplateTypes.contains(parentTemplate.getType());
            return this.getExtended().getAllTemplates().stream().filter(isInherited.negate()).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public Stream<Site> getAllSitesStream() {
        return Bennu.getInstance().getSitesSet().stream().filter(site -> this.getType().equals(site.getThemeType()));
    }

    public Set<Site> getSitesSet() {
        return this.getAllSitesStream().collect(Collectors.toSet());
    }
}

