/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.cms.api.json.PostFileAdapter;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.PostFile;

@Path(value="/cms/postFiles")
public class PostFileResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement getPostFile(@PathParam(value="oid") PostFile postFile) {
        return this.view(postFile, PostFileAdapter.class);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updatePostFile(@PathParam(value="oid") PostFile postFile, JsonElement json) {
        return this.updatePostFileFromJson(postFile, json);
    }

    private JsonElement updatePostFileFromJson(PostFile postFile, JsonElement json) {
        return this.view(this.update(json, postFile, PostFileAdapter.class));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deletePostFile(@PathParam(value="oid") PostFile postFile) {
        if (postFile.getPost() != null && postFile.getPost().isStaticPost()) {
            PermissionEvaluation.ensureCanDoThis(postFile.getSite(), PermissionsArray.Permission.EDIT_PAGE);
        } else {
            PermissionEvaluation.ensureCanDoThis(postFile.getSite(), PermissionsArray.Permission.EDIT_POSTS);
        }
        postFile.delete();
        return Response.ok().build();
    }
}

