/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.cms.api.json.CategoryAdapter;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;

@Path(value="/cms/categories")
public class CategoryResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement getCategory(@PathParam(value="oid") Category category) {
        return this.view(category, CategoryAdapter.class);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updateCategory(@PathParam(value="oid") Category category, JsonElement json) {
        return this.updateCategoryFromJson(category, json);
    }

    private JsonElement updateCategoryFromJson(Category category, JsonElement json) {
        return this.view(this.update(json, category, CategoryAdapter.class));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deleteCategory(@PathParam(value="oid") Category category) {
        PermissionEvaluation.ensureCanDoThis(category.getSite(), PermissionsArray.Permission.LIST_CATEGORIES, PermissionsArray.Permission.EDIT_CATEGORY, PermissionsArray.Permission.DELETE_CATEGORY);
        category.delete();
        return Response.ok().build();
    }
}

