/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.api.json.DateTimeViewer;
import org.fenixedu.bennu.core.api.json.LocalizedStringViewer;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import pt.ist.fenixframework.DomainObject;

@DefaultJsonAdapter(value=Post.class)
public class PostAdapter
implements JsonAdapter<Post> {
    public Post create(JsonElement json, JsonBuilder ctx) {
        return null;
    }

    public Post update(JsonElement json, Post post, JsonBuilder ctx) {
        String date;
        String date2;
        DateTime dateTime;
        post.ensureCanEditPost();
        JsonObject jObj = json.getAsJsonObject();
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            LocalizedString name = LocalizedString.fromJson((JsonElement)jObj.get("name"));
            if (!post.getName().equals((Object)name)) {
                post.setName(name);
            }
        }
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            String slug = jObj.get("slug").getAsString();
            if (!post.getSlug().equals(slug)) {
                post.setSlug(slug);
            }
        }
        if (jObj.has("body") && !jObj.get("body").isJsonNull() && jObj.get("body").isJsonObject()) {
            LocalizedString body = LocalizedString.fromJson((JsonElement)jObj.get("body"));
            LocalizedString excerpt = null;
            if (jObj.has("excerpt") && !jObj.get("excerpt").isJsonNull() && jObj.get("excerpt").isJsonObject()) {
                excerpt = LocalizedString.fromJson((JsonElement)jObj.get("excerpt"));
            }
            if (!post.getBody().equals((Object)body) || !post.getExcerpt().equals(excerpt)) {
                post.setBodyAndExcerpt(body, excerpt);
            }
        }
        if (jObj.has("published") && !jObj.get("published").isJsonNull()) {
            boolean published = jObj.get("published").getAsBoolean();
            if (post.getActive() != published) {
                post.setActive(published);
            }
        }
        if (jObj.has("publicationBegin") && !jObj.get("publicationBegin").isJsonNull() && !(dateTime = PostAdapter.parseDate(date2 = jObj.get("publicationBegin").getAsString())).isEqual((ReadableInstant)post.getPublicationBegin())) {
            post.setPublicationBegin(dateTime);
        }
        if (jObj.has("publicationEnd") && !jObj.get("publicationEnd").isJsonNull() && !(dateTime = PostAdapter.parseDate(date = jObj.get("publicationEnd").getAsString())).isEqual((ReadableInstant)post.getPublicationEnd())) {
            post.setPublicationEnd(dateTime);
        }
        Signal.emit((String)"fenixedu.cms.post.edited", (Object)new DomainObjectEvent((DomainObject)post));
        return post;
    }

    public static DateTime parseDate(String date) {
        DateTimeFormatter formatter = ISODateTimeFormat.dateHourMinute();
        DateTime dateTime = formatter.parseDateTime(date);
        return dateTime;
    }

    public JsonElement view(Post post, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", post.getExternalId());
        json.add("name", ctx.view((Object)post.getName(), LocalizedStringViewer.class));
        json.add("body", ctx.view((Object)post.getBody(), LocalizedStringViewer.class));
        json.add("creationDate", ctx.view((Object)post.getCreationDate(), DateTimeViewer.class));
        json.add("modificationDate", ctx.view((Object)post.getModificationDate(), DateTimeViewer.class));
        json.add("publicationBegin", ctx.view((Object)post.getPublicationBegin(), DateTimeViewer.class));
        json.add("publicationEnd", ctx.view((Object)post.getPublicationEnd(), DateTimeViewer.class));
        if (post.getCreatedBy() != null) {
            json.addProperty("createdBy", post.getCreatedBy().getUsername());
        }
        if (post.getSite() != null) {
            json.addProperty("site", post.getSite().getExternalId());
        }
        json.addProperty("slug", post.getSlug());
        json.addProperty("published", Boolean.valueOf(post.getActive()));
        return json;
    }
}

