/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tika.io.FilenameUtils;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.GroupBasedFile;
import org.fenixedu.bennu.io.servlet.FileDownloadServlet;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.Category_Base;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.Menu_Base;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Page_Base;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.PostFile;
import org.fenixedu.cms.domain.PostFile_Base;
import org.fenixedu.cms.domain.PostMetadata;
import org.fenixedu.cms.domain.Post_Base;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class SiteExporter {
    private final Site site;

    public SiteExporter(Site site) {
        this.site = site;
    }

    public ByteArrayOutputStream export() {
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(byteArrayStream));
            SiteExporter.addToZipFile("site.json", this.export(this.site), zipOutputStream);
            for (Page page : this.getSite().getPagesSet()) {
                SiteExporter.addToZipFile("pages/" + page.getSlug() + ".json", this.export(page), zipOutputStream);
            }
            for (Post post2 : this.getSite().getPostSet()) {
                SiteExporter.addToZipFile("posts/" + post2.getSlug() + ".json", this.export(post2), zipOutputStream);
            }
            for (Category category : this.getSite().getCategoriesSet()) {
                SiteExporter.addToZipFile("categories/" + category.getSlug() + ".json", this.export(category), zipOutputStream);
            }
            for (Menu menu : this.getSite().getMenusSet()) {
                SiteExporter.addToZipFile("menus/" + menu.getSlug() + ".json", this.export(menu), zipOutputStream);
            }
            for (GroupBasedFile file : this.getSite().getPostSet().stream().flatMap(post -> post.getFilesSet().stream()).map(PostFile_Base::getFiles).distinct().collect(Collectors.toList())) {
                SiteExporter.addToZipFile("files/" + file.getExternalId(), file.getStream(), zipOutputStream);
            }
            zipOutputStream.close();
            return byteArrayStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error exporting site " + this.site.getSlug(), e);
        }
    }

    public static void addToZipFile(String filename, JsonObject jsonObject, ZipOutputStream zos) throws IOException {
        SiteExporter.addToZipFile(filename, new ByteArrayInputStream(jsonObject.toString().getBytes(Charset.defaultCharset())), zos);
    }

    public static void addToZipFile(String filename, InputStream content, ZipOutputStream zos) throws IOException {
        int length;
        ZipEntry zipEntry = new ZipEntry(FilenameUtils.normalize((String)filename));
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = content.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        content.close();
    }

    protected JsonObject export(Site site) {
        JsonObject siteJson = new JsonObject();
        siteJson.addProperty("slug", site.getSlug());
        siteJson.add("name", site.getName().json());
        siteJson.add("description", site.getDescription().json());
        siteJson.add("canViewGroup", this.export(site.getCanViewGroup()));
        siteJson.addProperty("themeType", site.getThemeType());
        siteJson.addProperty("embedded", Boolean.valueOf(site.getEmbedded()));
        siteJson.addProperty("analyticsCode", site.getAnalyticsCode());
        siteJson.add("creationDate", this.toJson(site.getCreationDate()));
        siteJson.addProperty("createdBy", site.getCreatedBy().getUsername());
        siteJson.addProperty("folder", (String)Optional.ofNullable(site.getFolder()).map(AbstractDomainObject::getExternalId).orElse(null));
        siteJson.addProperty("published", Boolean.valueOf(site.getPublished()));
        siteJson.addProperty("initialPage", (String)Optional.ofNullable(site.getInitialPage()).map(Page_Base::getSlug).orElse(null));
        siteJson.add("menus", (JsonElement)this.toArray(site.getMenusSet().stream().map(Menu_Base::getSlug)));
        siteJson.add("posts", (JsonElement)this.toArray(site.getPostSet().stream().map(Post_Base::getSlug)));
        siteJson.add("pages", (JsonElement)this.toArray(site.getPagesSet().stream().map(Page_Base::getSlug)));
        siteJson.add("categories", (JsonElement)this.toArray(site.getCategoriesSet().stream().map(Category_Base::getSlug)));
        return siteJson;
    }

    protected JsonObject export(Page page) {
        JsonObject pageJson = new JsonObject();
        pageJson.addProperty("slug", page.getSlug());
        pageJson.add("name", page.getName().json());
        pageJson.addProperty("site", page.getSite().getSlug());
        pageJson.add("canViewGroup", this.export(page.getCanViewGroup()));
        pageJson.addProperty("templateType", page.getTemplateType());
        pageJson.addProperty("createdBy", page.getCreatedBy().getUsername());
        pageJson.add("creationDate", this.toJson(page.getCreationDate()));
        pageJson.addProperty("published", Boolean.valueOf(page.getPublished()));
        pageJson.add("modificationDate", this.toJson(page.getModificationDate()));
        pageJson.addProperty("published", Boolean.valueOf(page.getPublished()));
        pageJson.add("menuItems", (JsonElement)this.toArray(page.getMenuItemsSet().stream().map(AbstractDomainObject::getExternalId)));
        pageJson.add("components", (JsonElement)this.toJsonArray(page.getComponentsSet().stream().map(this::export)));
        return pageJson;
    }

    protected JsonObject export(Menu menu) {
        JsonObject json = new JsonObject();
        json.addProperty("slug", menu.getSlug());
        json.addProperty("site", menu.getSite().getSlug());
        json.add("creationDate", this.toJson(menu.getCreationDate()));
        json.addProperty("createdBy", menu.getCreatedBy().getUsername());
        json.addProperty("order", (Number)menu.getOrder());
        json.add("name", menu.getName().json());
        json.add("topLevelItems", (JsonElement)this.toJsonArray(menu.getToplevelItemsSet().stream().map(this::export)));
        return json;
    }

    protected JsonObject export(MenuItem menuItem) {
        JsonObject json = new JsonObject();
        json.add("name", menuItem.getName().json());
        json.addProperty("slug", menuItem.getExternalId());
        json.addProperty("menu", (String)Optional.ofNullable(menuItem.getMenu()).map(Menu_Base::getSlug).orElse(null));
        json.addProperty("top", (String)Optional.ofNullable(menuItem.getTop()).map(Menu_Base::getSlug).orElse(null));
        json.addProperty("parent", (String)Optional.ofNullable(menuItem.getParent()).map(AbstractDomainObject::getExternalId).orElse(null));
        json.addProperty("position", (Number)Optional.ofNullable(menuItem.getPosition()).orElse(0));
        json.addProperty("isFolder", Boolean.valueOf(menuItem.getFolder()));
        json.addProperty("page", (String)Optional.ofNullable(menuItem.getPage()).map(Page_Base::getSlug).orElse(null));
        json.addProperty("createdBy", menuItem.getCreatedBy().getUsername());
        json.add("creationDate", this.toJson(menuItem.getCreationDate()));
        json.add("children", (JsonElement)this.toJsonArray(menuItem.getChildrenSet().stream().map(this::export)));
        return json;
    }

    protected JsonObject export(Post post) {
        JsonObject json = new JsonObject();
        json.addProperty("slug", post.getSlug());
        json.addProperty("site", post.getSite().getSlug());
        json.add("name", post.getName().json());
        json.add("body", post.getBody().json());
        json.addProperty("createdBy", post.getCreatedBy().getUsername());
        json.add("creationDate", this.toJson(post.getCreationDate()));
        json.add("canViewGroup", this.export(post.getCanViewGroup()));
        json.add("categories", (JsonElement)this.toArray(post.getCategoriesSet().stream().map(Category_Base::getSlug)));
        json.addProperty("active", Boolean.valueOf(post.getActive()));
        json.add("location", Optional.ofNullable(post.getLocation()).map(LocalizedString::json).orElse((JsonElement)JsonNull.INSTANCE));
        json.add("metadata", Optional.ofNullable(post.getMetadata()).map(PostMetadata::json).orElse((JsonElement)JsonNull.INSTANCE));
        json.add("modificationDate", this.toJson(post.getModificationDate()));
        json.add("publicationBegin", this.toJson(post.getPublicationBegin()));
        json.add("publicationEnd", this.toJson(post.getPublicationEnd()));
        json.add("files", (JsonElement)this.toJsonArray(post.getFilesSet().stream().map(this::export)));
        return json;
    }

    protected JsonObject export(Category category) {
        JsonObject json = new JsonObject();
        json.addProperty("slug", category.getSlug());
        json.addProperty("site", category.getSite().getSlug());
        json.add("creationDate", this.toJson(category.getCreationDate()));
        json.addProperty("createdBy", category.getCreatedBy().getUsername());
        json.add("name", category.getName().json());
        json.add("posts", (JsonElement)this.toArray(category.getPostsSet().stream().map(Post_Base::getSlug)));
        json.add("components", (JsonElement)this.toJsonArray(category.getComponentsSet().stream().map(this::export)));
        return json;
    }

    protected JsonObject export(PostFile postFile) {
        JsonObject json = new JsonObject();
        json.addProperty("slug", postFile.getExternalId());
        json.addProperty("index", (Number)postFile.getIndex());
        json.addProperty("isEmbedded", Boolean.valueOf(postFile.getIsEmbedded()));
        json.addProperty("post", postFile.getPost().getSlug());
        json.add("viewGroup", this.export(postFile.getFiles().getAccessGroup()));
        json.addProperty("displayName", postFile.getFiles().getDisplayName());
        json.addProperty("fileName", postFile.getFiles().getFilename());
        json.addProperty("url", FileDownloadServlet.getDownloadUrl((GenericFile)postFile.getFiles()));
        json.addProperty("file", postFile.getFiles().getExternalId());
        return json;
    }

    protected JsonObject export(Component component) {
        return component.json();
    }

    private JsonElement export(Group group) {
        return group != null ? new JsonPrimitive(group.getExpression()) : JsonNull.INSTANCE;
    }

    private JsonElement toJson(DateTime date) {
        return date != null ? new JsonPrimitive(date.toDateTimeISO().toString()) : JsonNull.INSTANCE;
    }

    private JsonArray toArray(Stream<String> strStream) {
        return this.toJsonArray(strStream.map(JsonPrimitive::new));
    }

    private JsonArray toJsonArray(Stream<JsonElement> jsonElementStream) {
        JsonArray jsonArray = new JsonArray();
        jsonElementStream.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    public Site getSite() {
        return this.site;
    }
}

