/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.domain;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.domain.wraps.Wrappable;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;

public class PostMetadata
implements Serializable,
Wrappable {
    private static final long serialVersionUID = 4890885803531605616L;
    private final JsonObject metadata;

    public PostMetadata() {
        this(new JsonObject());
    }

    public PostMetadata(JsonObject metadata) {
        this.metadata = metadata;
    }

    public PostMetadata with(String key, LocalizedString value) {
        if (key != null && value != null) {
            this.metadata.add(key, value.json());
        }
        return new PostMetadata(this.metadata);
    }

    public PostMetadata with(String key, DateTime value) {
        if (key != null && value != null) {
            this.metadata.addProperty(key, value.toDateTimeISO().toString());
        }
        return new PostMetadata(this.metadata);
    }

    public PostMetadata with(String key, String value) {
        this.metadata.addProperty(key, value);
        return new PostMetadata(this.metadata);
    }

    public PostMetadata with(String key, Number value) {
        this.metadata.addProperty(key, value);
        return new PostMetadata(this.metadata);
    }

    public PostMetadata with(String key, Boolean value) {
        this.metadata.addProperty(key, value);
        return new PostMetadata(this.metadata);
    }

    public PostMetadata without(String key) {
        this.metadata.remove(key);
        return new PostMetadata(this.metadata);
    }

    public Optional<LocalizedString> getAsLocalizedString(String key) {
        return this.contains(key) ? Optional.ofNullable(LocalizedString.fromJson((JsonElement)this.get(key).get())) : Optional.empty();
    }

    public Optional<DateTime> getAsDateTime(String key) {
        return this.contains(key) ? Optional.ofNullable(DateTime.parse((String)this.get(key).get().getAsString())) : Optional.empty();
    }

    public Optional<String> getAsString(String key) {
        return this.contains(key) ? Optional.ofNullable(this.get(key).get().getAsString()) : Optional.empty();
    }

    public Optional<Number> getAsNumber(String key) {
        return this.contains(key) ? Optional.ofNullable(this.get(key).get().getAsNumber()) : Optional.empty();
    }

    public Optional<Boolean> getAsBoolean(String key) {
        return this.contains(key) ? Optional.ofNullable(this.get(key).get().getAsBoolean()) : Optional.empty();
    }

    public Optional<JsonElement> get(String key) {
        return this.contains(key) ? Optional.ofNullable(this.metadata.get(key)) : Optional.empty();
    }

    public Set<Map.Entry<String, JsonElement>> getEntries() {
        return this.metadata.entrySet();
    }

    public boolean contains(String key) {
        return this.metadata.get(key) != null && !this.metadata.get(key).isJsonNull();
    }

    public static PostMetadata fromJson(JsonElement json) {
        return new PostMetadata(json.getAsJsonObject());
    }

    public String externalize() {
        return this.metadata.toString();
    }

    public JsonElement json() {
        return this.metadata;
    }

    public static PostMetadata internalize(String json) {
        return new PostMetadata(((JsonElement)new Gson().fromJson(json, JsonElement.class)).getAsJsonObject());
    }

    @Override
    public Wrap makeWrap() {
        return new PostMetadataWrap();
    }

    public String toString() {
        return this.externalize();
    }

    public PostMetadata clone() {
        return new PostMetadata(this.metadata);
    }

    public boolean equals(Object object) {
        return PostMetadata.class.isInstance(object) && ((PostMetadata)object).json().equals(this.json());
    }

    public class PostMetadataWrap
    extends Wrap {
        public JsonElement get(String key) {
            return PostMetadata.this.metadata.get(key);
        }

        public Set<Map.Entry<String, JsonElement>> getEntries() {
            return PostMetadata.this.getEntries();
        }
    }
}

