/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.api.json.CategoryAdapter;
import org.fenixedu.cms.api.json.MenuAdapter;
import org.fenixedu.cms.api.json.PageAdapter;
import org.fenixedu.cms.api.json.PostAdapter;
import org.fenixedu.cms.api.json.SiteAdapter;
import org.fenixedu.cms.api.resource.SiteResource$callable$createCategoryFromJson;
import org.fenixedu.cms.api.resource.SiteResource$callable$createMenuFromJson;
import org.fenixedu.cms.api.resource.SiteResource$callable$createPageFromJson;
import org.fenixedu.cms.api.resource.SiteResource$callable$createPostFromJson;
import org.fenixedu.cms.domain.Category;
import org.fenixedu.cms.domain.CmsSettings;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.cms.domain.Post;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/cms/sites")
public class SiteResource
extends BennuRestResource {
    public static final Advice advice$createPostFromJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createPageFromJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createCategoryFromJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createMenuFromJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @GET
    @Produces(value={"application/json"})
    public JsonElement listAllSites() {
        return this.view(this.getAdminSites(), SiteAdapter.class);
    }

    private Stream<Site> getAdminSites() {
        return Bennu.getInstance().getSitesSet().stream().filter(s -> PermissionEvaluation.canAccess(Authenticate.getUser(), s));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement createSite(JsonElement json) {
        CmsSettings.getInstance().ensureCanManageSettings();
        return this.view(this.createSiteFromJson(json));
    }

    private Site createSiteFromJson(JsonElement json) {
        return (Site)this.create(json, Site.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement listSite(@PathParam(value="oid") Site site) {
        return this.view(site, SiteAdapter.class);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deleteSite(@PathParam(value="oid") Site site) {
        site.delete();
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updateSite(@PathParam(value="oid") Site site, JsonElement json) {
        return this.updateSiteFromJson(site, json);
    }

    private JsonElement updateSiteFromJson(Site site, JsonElement json) {
        return this.view(this.update(json, site, SiteAdapter.class));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/posts")
    public JsonElement listSitePosts(@PathParam(value="oid") Site site, @QueryParam(value="category") Set<Category> categories) {
        Set posts = site.getPostSet();
        if (categories != null && !categories.isEmpty()) {
            posts = posts.stream().filter(p -> p.getCategoriesSet().stream().anyMatch(c -> categories.contains(c))).collect(Collectors.toSet());
        }
        return this.view(posts, PostAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/posts")
    public JsonElement createPost(@PathParam(value="oid") Site site, JsonObject json) {
        return this.view(this.createPostFromJson(site, json));
    }

    private Post createPostFromJson(Site site, JsonObject jsonObject) {
        return (Post)advice$createPostFromJson.perform((Callable)new SiteResource$callable$createPostFromJson(this, site, jsonObject));
    }

    static /* synthetic */ Post advised$createPostFromJson(SiteResource this_, Site site, JsonObject jObj) {
        PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CREATE_POST);
        Post post = new Post(site);
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            post.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
            post.setSlug(jObj.get("slug").getAsString());
        }
        if (jObj.has("body") && !jObj.get("body").isJsonNull() && jObj.get("body").isJsonObject()) {
            LocalizedString excerpt = null;
            if (jObj.has("excerpt") && !jObj.get("excerpt").isJsonNull() && jObj.get("excerpt").isJsonObject()) {
                excerpt = LocalizedString.fromJson((JsonElement)jObj.get("excerpt"));
            }
            post.setBodyAndExcerpt(LocalizedString.fromJson((JsonElement)jObj.get("body")), excerpt);
        }
        return post;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/pages")
    public JsonElement listSitePages(@PathParam(value="oid") Site site) {
        return this.view(site.getPagesSet(), PageAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/pages")
    public JsonElement createPage(@PathParam(value="oid") Site site, JsonObject json) {
        return this.view(this.createPageFromJson(site, json));
    }

    private Page createPageFromJson(Site site, JsonObject jsonObject) {
        return (Page)advice$createPageFromJson.perform((Callable)new SiteResource$callable$createPageFromJson(this, site, jsonObject));
    }

    static /* synthetic */ Page advised$createPageFromJson(SiteResource this_, Site site, JsonObject jObj) {
        PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CREATE_PAGE);
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            Page page = new Page(site, LocalizedString.fromJson((JsonElement)jObj.get("name")));
            if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
                page.setSlug(jObj.get("slug").getAsString());
            }
            if (jObj.has("published") && !jObj.get("published").isJsonNull()) {
                page.setPublished(jObj.get("published").getAsBoolean());
            }
            return page;
        }
        throw CmsDomainException.badRequest("page.missing.name");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/categories")
    public JsonElement listSiteCategories(@PathParam(value="oid") Site site) {
        return this.view(site.getCategoriesSet(), CategoryAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/categories")
    public JsonElement createCategory(@PathParam(value="oid") Site site, JsonObject json) {
        return this.view(this.createCategoryFromJson(site, json));
    }

    private Category createCategoryFromJson(Site site, JsonObject jsonObject) {
        return (Category)advice$createCategoryFromJson.perform((Callable)new SiteResource$callable$createCategoryFromJson(this, site, jsonObject));
    }

    static /* synthetic */ Category advised$createCategoryFromJson(SiteResource this_, Site site, JsonObject jObj) {
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CREATE_CATEGORY);
            Category category = new Category(site, LocalizedString.fromJson((JsonElement)jObj.get("name")));
            if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
                category.setSlug(jObj.get("slug").getAsString());
            }
            return category;
        }
        throw CmsDomainException.badRequest("category.missing.name");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/menus")
    public JsonElement listSiteMenus(@PathParam(value="oid") Site site) {
        return this.view(site.getOrderedMenusSet(), MenuAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/menus")
    public JsonElement createMenu(@PathParam(value="oid") Site site, JsonObject json) {
        return this.view(this.createMenuFromJson(site, json));
    }

    private Menu createMenuFromJson(Site site, JsonObject jsonObject) {
        return (Menu)advice$createMenuFromJson.perform((Callable)new SiteResource$callable$createMenuFromJson(this, site, jsonObject));
    }

    static /* synthetic */ Menu advised$createMenuFromJson(SiteResource this_, Site site, JsonObject jObj) {
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            PermissionEvaluation.ensureCanDoThis(site, PermissionsArray.Permission.CREATE_MENU);
            Menu menu = new Menu(site, LocalizedString.fromJson((JsonElement)jObj.get("name")));
            if (jObj.has("slug") && !jObj.get("slug").isJsonNull()) {
                menu.setSlug(jObj.get("slug").getAsString());
            }
            if (jObj.has("topMenu") && !jObj.get("topMenu").isJsonNull()) {
                menu.setTopMenu(jObj.get("topMenu").getAsBoolean());
            }
            return menu;
        }
        throw CmsDomainException.badRequest("menu.missing.name");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/components")
    public JsonArray listSiteAvailableComponents(@PathParam(value="oid") Site site) {
        return Component.availableComponents(site);
    }
}

