/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.cms.api.json.MenuAdapter;
import org.fenixedu.cms.api.json.MenuItemAdapter;
import org.fenixedu.cms.api.resource.MenuResource$callable$createMenuItemFromJson;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.MenuItem;
import org.fenixedu.cms.domain.PermissionEvaluation;
import org.fenixedu.cms.domain.PermissionsArray;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/cms/menus")
public class MenuResource
extends BennuRestResource {
    public static final Advice advice$createMenuItemFromJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement getMenu(@PathParam(value="oid") Menu menu) {
        return this.view(menu, MenuAdapter.class);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public Response deleteMenu(@PathParam(value="oid") Menu menu) {
        PermissionEvaluation.ensureCanDoThis(menu.getSite(), PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.DELETE_MENU);
        menu.delete();
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}")
    public JsonElement updateMenu(@PathParam(value="oid") Menu menu, JsonElement json) {
        return this.updateMenuFromJson(menu, json);
    }

    private JsonElement updateMenuFromJson(Menu menu, JsonElement json) {
        return this.view(this.update(json, menu, MenuAdapter.class));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{oid}/menuItems")
    public JsonElement listMenuItems(@PathParam(value="oid") Menu menu) {
        return this.view(menu.getItemsSet(), MenuItemAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{oid}/menuItems")
    public JsonElement createMenuItem(@PathParam(value="oid") Menu menu, JsonObject json) {
        return this.view(this.createMenuItemFromJson(menu, json));
    }

    private MenuItem createMenuItemFromJson(Menu menu, JsonObject jsonObject) {
        return (MenuItem)advice$createMenuItemFromJson.perform((Callable)new MenuResource$callable$createMenuItemFromJson(this, menu, jsonObject));
    }

    static /* synthetic */ MenuItem advised$createMenuItemFromJson(MenuResource this_, Menu menu, JsonObject jObj) {
        PermissionEvaluation.ensureCanDoThis(menu.getSite(), PermissionsArray.Permission.LIST_MENUS, PermissionsArray.Permission.EDIT_MENU, PermissionsArray.Permission.CREATE_MENU_ITEM);
        MenuItem menuItem = new MenuItem(menu);
        if (jObj.has("name") && !jObj.get("name").isJsonNull() && jObj.get("name").isJsonObject()) {
            menuItem.setName(LocalizedString.fromJson((JsonElement)jObj.get("name")));
        }
        if (jObj.has("position") && !jObj.get("position").isJsonNull()) {
            menuItem.setPosition(jObj.get("position").getAsInt());
        }
        if (jObj.has("folder") && !jObj.get("folder").isJsonNull()) {
            menuItem.setFolder(jObj.get("folder").getAsBoolean());
        }
        if (jObj.has("url") && !jObj.get("url").isJsonNull()) {
            menuItem.setUrl(jObj.get("url").getAsString());
        }
        return menuItem;
    }
}

