/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.customer.paymentreferencecode;

import com.google.common.base.Strings;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.ui.customer.CustomerAccountingController;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.accounting.managecustomer.PaymentReferenceCodeController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerAccountingController.class)
@RequestMapping(value={"/academictreasury/customer/paymentreferencecode"})
public class CustomerAccountingPaymentReferenceCodeController
extends PaymentReferenceCodeController {
    public static final String CONTROLLER_URL = "/academictreasury/customer/paymentreferencecode";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URI = "/createpaymentcodeforseveraldebitentries";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URL = "/academictreasury/customer/paymentreferencecode/createpaymentcodeforseveraldebitentries";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URI = "/createpaymentcodeforseveraldebitentriespostback";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URL = "/academictreasury/customer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback";

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        String loggedUsername = TreasuryConstants.getAuthenticatedUsername();
        Person person = User.findByUsername((String)loggedUsername).getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode((Person)person);
        String fiscalNumber = PersonCustomer.fiscalNumber((Person)person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (PersonCustomer.findUnique((Person)person, (String)addressFiscalCountryCode, (String)fiscalNumber).get() != debtAccount.getCustomer()) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]), model);
            throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]));
        }
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.GET})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        return super.createPaymentCodeForSeveralDebitEntries(debtAccount, model);
    }

    protected String _createPaymentCodeForSeveralDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean bean, Model model) {
        bean.setUsePaymentAmountWithInterests(true);
        return super._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentriespostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createPaymentCodeForSeveralDebitEntriesPostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        return super.createPaymentCodeForSeveralDebitEntriesPostback(debtAccount, bean, model);
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.POST})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        return super.createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model, redirectAttributes);
    }

    protected String readDebtAccountUrl(DebtAccount debtAccount) {
        return String.format("%s/%s", "/academictreasury/customer/viewaccount/account/read/", debtAccount.getExternalId());
    }

    protected String getCreateUrl(DebtAccount debtAccount) {
        return "/academictreasury/customer/paymentreferencecode/createpaymentcodeforseveraldebitentries/" + debtAccount.getExternalId();
    }

    protected String getCreatePostbackUrl(DebtAccount debtAccount) {
        return "/academictreasury/customer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback/" + debtAccount.getExternalId();
    }

    public static boolean isReferenceCodesActiveForStudentPortal(FinantialInstitution finantialInstitution) {
        if (!SibsPaymentCodePool.findForSibsPaymentCodeServiceByActive((FinantialInstitution)finantialInstitution, (boolean)true).findFirst().isPresent()) {
            return false;
        }
        DigitalPaymentPlatform digitalPaymentPlatform = (DigitalPaymentPlatform)SibsPaymentCodePool.findForSibsPaymentCodeServiceByActive((FinantialInstitution)finantialInstitution, (boolean)true).findFirst().get();
        if (!DigitalPaymentPlatformPaymentMode.findUnique((DigitalPaymentPlatform)digitalPaymentPlatform, (PaymentMethod)TreasurySettings.getInstance().getMbPaymentMethod()).isPresent()) {
            return false;
        }
        return Boolean.TRUE.equals(((DigitalPaymentPlatformPaymentMode)DigitalPaymentPlatformPaymentMode.findUnique((DigitalPaymentPlatform)digitalPaymentPlatform, (PaymentMethod)TreasurySettings.getInstance().getMbPaymentMethod()).get()).getActiveForFrontend());
    }
}

