/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.treasury.IAcademicTreasuryAccountUrl;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.joda.time.LocalDate;

public class DefaultAcademicTreasuryAccountUrl
implements IAcademicTreasuryAccountUrl {
    public String getPersonAccountTreasuryManagementURL(Person person) {
        String countryCode = PersonCustomer.addressCountryCode((Person)person);
        String fiscalNumber = PersonCustomer.fiscalNumber((Person)person);
        return "/treasury/accounting/managecustomer/customer/read/" + ((PersonCustomer)PersonCustomer.findUnique((Person)person, (String)countryCode, (String)fiscalNumber).get()).getExternalId();
    }

    public String getRegistrationAccountTreasuryManagementURL(Registration registration) {
        String fiscalNumber;
        String countryCode;
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree((Degree)registration.getDegree(), (LocalDate)new LocalDate());
        if (finantialEntity == null) {
            return this.getPersonAccountTreasuryManagementURL(registration.getPerson());
        }
        FinantialInstitution inst = finantialEntity.getFinantialInstitution();
        Person person = registration.getPerson();
        PersonCustomer customer = (PersonCustomer)PersonCustomer.findUnique((Person)person, (String)(countryCode = PersonCustomer.addressCountryCode((Person)person)), (String)(fiscalNumber = PersonCustomer.fiscalNumber((Person)person))).get();
        DebtAccount account = customer.getDebtAccountFor(inst);
        if (account != null) {
            return "/treasury/accounting/managecustomer/debtaccount/read/" + customer.getDebtAccountFor(inst).getExternalId();
        }
        return this.getPersonAccountTreasuryManagementURL(person);
    }

    public String getDebtAccountURL(TreasuryEvent treasuryEvent) {
        if (DebitEntry.findActive((TreasuryEvent)treasuryEvent).findFirst().isPresent()) {
            return "/treasury/accounting/managecustomer/debtaccount/read/" + ((DebitEntry)DebitEntry.findActive((TreasuryEvent)treasuryEvent).findFirst().get()).getDebtAccount().getExternalId();
        }
        return null;
    }
}

