/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.tuitiondebtcreation.standalone;

import com.google.common.collect.Sets;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebtCreationBean;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.joda.time.LocalDate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean"})
public class OtherTuitionDebtCreationBeanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean";
    private static final String JSP_PATH = "academicTreasury/tuitiondebtcreation/tuitiondebtcreationbean";
    private static final String _CREATESTANDALONE_URI = "/createstandalone";
    public static final String CREATESTANDALONE_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/createstandalone";
    private static final String _CREATEEXTRACURRICULAR_URI = "/createextracurricular";
    public static final String CREATEEXTRACURRICULAR_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/createextracurricular";
    private static final String _BACKTOCREATE_URI = "/backtocreate";
    public static final String BACKTOCREATE_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/backtocreate";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/createpostback";
    private static final String _CREATE_REGISTRATION_URI = "/createregistration";
    public static final String CREATE_REGISTRATION_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/createregistration";
    private static final String _CONFIRMTUITIONDEBTCREATION_URI = "/confirmtuitiondebtcreation";
    public static final String CONFIRMTUITIONDEBTCREATION_URL = "/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/confirmtuitiondebtcreation";

    protected TuitionPaymentPlanGroup standaloneTuitionPaymentPlanGroup() {
        return (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get();
    }

    protected TuitionPaymentPlanGroup extracurricularTuitionPaymentPlanGroup() {
        return (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get();
    }

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/othertuitiondebtcreation/tuitiondebtcreationbean/create/";
    }

    @RequestMapping(value={"/createregistration/{debtAccountId}"}, method={RequestMethod.GET})
    public String createregistraton(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        TuitionDebtCreationBean bean = new TuitionDebtCreationBean(debtAccount, (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get());
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/createstandalone/{debtAccountId}"}, method={RequestMethod.GET})
    public String createstandalone(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        TuitionDebtCreationBean bean = new TuitionDebtCreationBean(debtAccount, this.standaloneTuitionPaymentPlanGroup());
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/createextracurricular/{debtAccountId}"}, method={RequestMethod.GET})
    public String createextracurricular(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        TuitionDebtCreationBean bean = new TuitionDebtCreationBean(debtAccount, this.extracurricularTuitionPaymentPlanGroup());
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/backtocreate/{debtAccountId}"}, method={RequestMethod.POST})
    public String backTocreate(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model) {
        return this._createFirstPage(debtAccount, bean, model);
    }

    public String _createFirstPage(DebtAccount debtAccount, TuitionDebtCreationBean bean, Model model) {
        model.addAttribute("TuitionDebtCreationBean_executionYear_options", (Object)ExecutionYear.readNotClosedExecutionYears());
        model.addAttribute("TuitionDebtCreationBean_registration_options", (Object)((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet());
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("tuitionDebtCreationBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createregistration/{debtAccountId}"}, method={RequestMethod.POST})
    public String createregistration(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            model.addAttribute("debtAccount", (Object)debtAccount);
            model.addAttribute("bean", (Object)bean);
            model.addAttribute("tuitionDebtCreationBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
            boolean dataMissing = false;
            if (bean.getRegistration() == null) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.registration.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (bean.getExecutionYear() == null) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.executionYear.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (bean.getDebtDate() == null) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.debtDate.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (!bean.isRegistrationTuition() && bean.getEnrolment() == null) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.enrolment.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (bean.getTuitionPaymentPlan() == null) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.tuitionPaymentPlan.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (dataMissing) {
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (bean.isTuitionCharged()) {
                this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.tuition.registration.already.charged", (String[])new String[0]), model);
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (bean.isRegistrationTuition()) {
                model.addAttribute("tuitionPaymentPlan", (Object)TuitionServices.usedPaymentPlan((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan()));
                model.addAttribute("installments", (Object)TuitionServices.calculateInstallmentDebitEntryBeans((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (boolean)true));
            } else if (bean.isStandaloneTuition()) {
                AcademicTreasuryEvent event = TuitionServices.findAcademicTreasuryEventTuitionForStandalone((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear());
                if (event != null && event.isChargedWithDebitEntry(bean.getEnrolment())) {
                    this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.event.is.charged", (String[])new String[0]), model);
                    return this._createFirstPage(debtAccount, bean, model);
                }
                model.addAttribute("tuitionPaymentPlan", (Object)TuitionServices.usedPaymentPlanForStandalone((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (Enrolment)bean.getEnrolment(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan()));
                model.addAttribute("installments", (Object)TuitionServices.calculateInstallmentDebitEntryBeansForStandalone((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (Set)Sets.newHashSet((Object[])new Enrolment[]{bean.getEnrolment()})));
            } else if (bean.isExtracurricularTuition()) {
                AcademicTreasuryEvent event = TuitionServices.findAcademicTreasuryEventTuitionForExtracurricular((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear());
                if (event != null && event.isChargedWithDebitEntry(bean.getEnrolment())) {
                    this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"error.TuitionDebtCreationBean.event.is.charged", (String[])new String[0]), model);
                    return this._createFirstPage(debtAccount, bean, model);
                }
                model.addAttribute("tuitionPaymentPlan", (Object)TuitionServices.usedPaymentPlanForExtracurricular((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (Enrolment)bean.getEnrolment(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan()));
                model.addAttribute("installments", (Object)TuitionServices.calculateInstallmentDebitEntryBeansForExtracurricular((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (LocalDate)bean.getDebtDate(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (Set)Sets.newHashSet((Object[])new Enrolment[]{bean.getEnrolment()})));
            }
            return this.jspPage("confirmtuitiondebtcreation");
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(debtAccount, bean, model);
        }
    }

    @RequestMapping(value={"/confirmtuitiondebtcreation/{debtAccountId}"}, method={RequestMethod.POST})
    public String confirmtuitiondebtcreation(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            boolean createdWithSuccess = false;
            if (bean.isRegistrationTuition()) {
                createdWithSuccess = TuitionServices.createTuitionForRegistration((Registration)bean.getRegistration(), (ExecutionYear)bean.getExecutionYear(), (LocalDate)bean.getDebtDate(), (boolean)true, (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (boolean)true);
            } else if (bean.isStandaloneTuition()) {
                createdWithSuccess = TuitionServices.createTuitionForStandalone((Enrolment)bean.getEnrolment(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (LocalDate)bean.getDebtDate(), (boolean)true);
            } else if (bean.isExtracurricularTuition()) {
                createdWithSuccess = TuitionServices.createTuitionForExtracurricular((Enrolment)bean.getEnrolment(), (TuitionPaymentPlan)bean.getTuitionPaymentPlan(), (LocalDate)bean.getDebtDate(), (boolean)true);
            }
            if (createdWithSuccess) {
                this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.TuitionPaymentPlan.tuition.installments.debit.entries.created.success", (String[])new String[0]), model);
                return this.redirect("/treasury/accounting/managecustomer/debtaccount/read//" + debtAccount.getExternalId(), model, redirectAttributes);
            }
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.TuitionPaymentPlan.tuition.installments.debit.entries.created.insuccess", (String[])new String[0]), model);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
        }
        return this._createFirstPage(debtAccount, bean, model);
    }

    private String jspPage(String page) {
        return "academicTreasury/tuitiondebtcreation/tuitiondebtcreationbean/" + page;
    }
}

