/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageacademictax;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.ui.manageacademictax.AcademicTaxController$callable$deleteAcademicTax;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Product;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageAcademicTax", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/academictreasury/manageacademictax/academictax"})
public class AcademicTaxController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/manageacademictax/academictax";
    private static final String JSP_PATH = "academicTreasury/manageacademictax/academictax";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academictreasury/manageacademictax/academictax/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/manageacademictax/academictax/search/delete/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/academictreasury/manageacademictax/academictax/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/manageacademictax/academictax/create";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/academictreasury/manageacademictax/academictax/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/academictreasury/manageacademictax/academictax/update/";
    public static final Advice advice$deleteAcademicTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/manageacademictax/academictax/";
    }

    private AcademicTax getAcademicTax(Model model) {
        return (AcademicTax)model.asMap().get("academicTax");
    }

    private void setAcademicTax(AcademicTax academicTax, Model model) {
        model.addAttribute("academicTax", (Object)academicTax);
    }

    public void deleteAcademicTax(AcademicTax academicTax) {
        Object object = advice$deleteAcademicTax.perform((Callable)new AcademicTaxController$callable$deleteAcademicTax(this, academicTax));
    }

    static /* synthetic */ void advised$deleteAcademicTax(AcademicTaxController this_, AcademicTax academicTax) {
        academicTax.delete();
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchacademictaxResultsDataSet", AcademicTax.findAll().sorted(AcademicTax.COMPARE_BY_PRODUCT_NAME).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/delete/{academicTaxId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="academicTaxId") AcademicTax academicTax, Model model, RedirectAttributes redirectAttributes) {
        this.processDelete(academicTax, model, redirectAttributes);
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/delete/{academicTaxId}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="academicTaxId") AcademicTax academicTax, Model model, RedirectAttributes redirectAttributes) {
        boolean success = this.processDelete(academicTax, model, redirectAttributes);
        if (success) {
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        return this.jspPage("read");
    }

    private boolean processDelete(AcademicTax academicTax, Model model, RedirectAttributes redirectAttributes) {
        this.setAcademicTax(academicTax, model);
        try {
            this.deleteAcademicTax(academicTax);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.success.create", (String[])new String[0]), model);
            return true;
        }
        catch (AcademicTreasuryDomainException ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return false;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("AcademicTax_product_options", AcademicTreasurySettings.getInstance().getEmolumentsProductGroup().getProductsSet().stream().sorted(Product.COMPARE_BY_NAME).collect(Collectors.toList()));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="product", required=false) Product product, @RequestParam(value="appliedonregistration", required=false) boolean appliedOnRegistration, @RequestParam(value="appliedonregistrationfirstyear", required=false) boolean appliedOnRegistrationFirstYear, @RequestParam(value="appliedonregistrationsubsequentyears", required=false) boolean appliedOnRegistrationSubsequentYears, @RequestParam(value="appliedautomatically", required=false) boolean appliedAutomatically, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicTax academicTax = AcademicTax.create((Product)product, (boolean)appliedOnRegistration, (boolean)appliedOnRegistrationFirstYear, (boolean)appliedOnRegistrationSubsequentYears, (boolean)appliedAutomatically);
            return this.redirect(READ_URL + academicTax.getExternalId(), model, redirectAttributes);
        }
        catch (AcademicTreasuryDomainException ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") AcademicTax academicTax, Model model) {
        this.setAcademicTax(academicTax, model);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") AcademicTax academicTax, Model model) {
        model.addAttribute("academicTax", (Object)academicTax);
        return this.jspPage("update");
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") AcademicTax academicTax, @RequestParam(value="appliedonregistration", required=false) boolean appliedOnRegistration, @RequestParam(value="appliedonregistrationfirstyear", required=false) boolean appliedOnRegistrationFirstYear, @RequestParam(value="appliedonregistrationsubsequentyears", required=false) boolean appliedOnRegistrationSubsequentYears, @RequestParam(value="appliedautomatically", required=false) boolean appliedAutomatically, Model model, RedirectAttributes redirectAttributes) {
        try {
            academicTax.edit(appliedOnRegistration, appliedOnRegistrationFirstYear, appliedOnRegistrationSubsequentYears, appliedAutomatically);
            return this.redirect(READ_URL + academicTax.getExternalId(), model, redirectAttributes);
        }
        catch (AcademicTreasuryDomainException ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(academicTax, model);
    }

    private String jspPage(String page) {
        return "academicTreasury/manageacademictax/academictax/" + page;
    }
}

