/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.integration.tuitioninfo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoSettings;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeBean;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@RequestMapping(value={"/academictreasury/erptuitioninfotype"})
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.ERPTuitionInfoType.title", accessGroup="#managers")
public class ERPTuitionInfoTypeController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/erptuitioninfotype";
    public static final String JSP_PATH = "academicTreasury/erptuitioninfotype";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/erptuitioninfotype/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/erptuitioninfotype/create";
    private static final String _REMOVE_TUITION_PRODUCT_URI = "/removetuitionproduct";
    public static final String REMOVE_TUITION_PRODUCT_URL = "/academictreasury/erptuitioninfotype/removetuitionproduct";
    private static final String _ADD_TUITION_PRODUCT_URI = "/addtuitionproduct";
    public static final String ADD_TUITION_PRODUCT_URL = "/academictreasury/erptuitioninfotype/addtuitionproduct";
    private static final String _ADD_DEGREE_TYPE_URI = "/adddegreetype";
    public static final String ADD_DEGREE_TYPE_URL = "/academictreasury/erptuitioninfotype/adddegreetype";
    private static final String _ADD_DEGREES_URI = "/adddegrees";
    public static final String ADD_DEGREES_URL = "/academictreasury/erptuitioninfotype/adddegrees";
    private static final String _ADD_DEGREE_CURRICULAR_PLANS_URI = "/adddegreecurricularplans";
    public static final String ADD_DEGREE_CURRICULAR_PLANS_URL = "/academictreasury/erptuitioninfotype/adddegreecurricularplans";
    private static final String _CHOOSE_TUITION_PAYMENT_PLAN_GROUP_URI = "/choosetuitionpaymentplangroup";
    public static final String CHOOSE_TUITION_PAYMENT_PLAN_GROUP_URL = "/academictreasury/erptuitioninfotype/choosetuitionpaymentplangroup";
    private static final String _CHOOSE_DEGREE_TYPE_POSTBACK_URI = "/choosedegreetypepostback";
    public static final String CHOOSE_DEGREE_TYPE_POSTBACK_URL = "/academictreasury/erptuitioninfotype/choosedegreetypepostback";
    private static final String _CHOOSE_DEGREE_INFORMATION_TO_ADD_URI = "/choosedegreeinformationtoadd";
    public static final String CHOOSE_DEGREE_INFORMATION_TO_ADD_URL = "/academictreasury/erptuitioninfotype/choosedegreeinformationtoadd";
    private static final String _REMOVE_DEGREE_TYPE_URI = "/removedegreetype";
    public static final String REMOVE_DEGREE_TYPE_URL = "/academictreasury/erptuitioninfotype/removedegreetype";
    private static final String _REMOVE_DEGREE_URI = "/removedegree";
    public static final String REMOVE_DEGREE_URL = "/academictreasury/erptuitioninfotype/removedegree";
    private static final String _REMOVE_DEGREE_CURRICULAR_PLAN_URI = "/removedegreecurricularplan";
    public static final String REMOVE_DEGREE_CURRICULAR_PLAN_URL = "/academictreasury/erptuitioninfotype/removedegreecurricularplan";
    private static final String _UPDATE_URI = "/update";
    public static final String UPDATE_URL = "/academictreasury/erptuitioninfotype/update";
    private static final String _DELETE_URI = "/delete";
    public static final String DELETE_URL = "/academictreasury/erptuitioninfotype/delete";
    private static final String _TOOGLE_ACTIVE_URI = "/toogleactive";
    public static final String TOOGLE_ACTIVE_URL = "/academictreasury/erptuitioninfotype/toogleactive";
    private static final String _TOOGLE_EXPORTATION_ACTIVE_URI = "/toogleexportationactive";
    public static final String TOOGLE_EXPORTATION_ACTIVE_URL = "/academictreasury/erptuitioninfotype/toogleexportationactive";

    @RequestMapping
    public String home() {
        return "redirect:/academictreasury/erptuitioninfotype/search/" + ExecutionYear.readCurrentExecutionYear().getExternalId();
    }

    @RequestMapping(value={"/search/{executionYearId}"}, method={RequestMethod.GET})
    public String search(Model model, @PathVariable(value="executionYearId") ExecutionYear executionYear) {
        Set erpTuitionInfoTypesSet = ERPTuitionInfoType.findForExecutionYear((ExecutionYear)executionYear).collect(Collectors.toSet());
        ArrayList executionYearOptions = new ArrayList(ExecutionYear.readNotClosedExecutionYears());
        Collections.sort(executionYearOptions, ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("executionYearOptions", executionYearOptions);
        model.addAttribute("result", erpTuitionInfoTypesSet);
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/create/{executionYearId}"}, method={RequestMethod.GET})
    public String create(Model model, @PathVariable(value="executionYearId") ExecutionYear executionYear) {
        ERPTuitionInfoTypeBean bean = new ERPTuitionInfoTypeBean(executionYear);
        bean.update();
        return this._create(executionYear, bean, model);
    }

    private String _create(@PathVariable(value="executionYearId") ExecutionYear executionYear, ERPTuitionInfoTypeBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("beanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage(_CREATE_URI);
    }

    @RequestMapping(value={"/create/{executionYearId}"}, method={RequestMethod.POST})
    public String createpost(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            ERPTuitionInfoType.create((ERPTuitionInfoTypeBean)bean);
            return this.redirect("/academictreasury/erptuitioninfotype/search/" + executionYear.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._create(executionYear, bean, model);
        }
    }

    @RequestMapping(value={"/removetuitionproduct/{executionYearId}/{productId}"}, method={RequestMethod.POST})
    public String removetuitionproduct(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="productId") Product product, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.removeTuitionProduct(product);
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/addtuitionproduct/{executionYearId}"}, method={RequestMethod.POST})
    public String addtuitionproduct(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.addTuitionProduct();
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/adddegreetype/{executionYearId}"}, method={RequestMethod.POST})
    public String adddegreetype(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        try {
            bean.addDegreeType();
            bean.update();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/adddegrees/{executionYearId}"}, method={RequestMethod.POST})
    public String adddegrees(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        try {
            bean.addDegrees();
            bean.update();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/adddegreecurricularplans/{executionYearId}"}, method={RequestMethod.POST})
    public String adddegreecurricularplan(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        try {
            bean.addDegreeCurricularPlans();
            bean.update();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/choosetuitionpaymentplangroup/{executionYearId}/{tuitionPaymentPlanGroupId}"}, method={RequestMethod.POST})
    public String choosetuitionpaymentplangroup(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="tuitionPaymentPlanGroupId") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        TuitionPaymentPlanGroup e = (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get();
        TuitionPaymentPlanGroup s = (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get();
        TuitionPaymentPlanGroup r = (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get();
        if (!Lists.newArrayList((Object[])new TuitionPaymentPlanGroup[]{r, s, e}).contains(tuitionPaymentPlanGroup)) {
            throw new RuntimeException("invalid request");
        }
        bean.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup);
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/choosedegreetypepostback/{executionYearId}"}, method={RequestMethod.POST})
    public String choosedegreetypepostback(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/choosedegreeinformationtoadd/{executionYearId}/{option}"}, method={RequestMethod.POST})
    public String choosedegreeinformationtoadd(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="option") String option, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        if (!Lists.newArrayList((Object[])new String[]{"DEGREE_TYPE_OPTION", "DEGREES_OPTION", "DEGREE_CURRICULAR_PLANS_OPTIONS"}).contains(option)) {
            throw new RuntimeException("invalid request");
        }
        bean.setDegreeInfoSelectOption(option);
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/removedegreetype/{executionYearId}/{degreeTypeId}"}, method={RequestMethod.POST})
    public String removedegreetype(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeTypeId") DegreeType degreeType, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.removeDegreeType(degreeType);
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/removedegree/{executionYearId}/{degreeId}"}, method={RequestMethod.POST})
    public String removedegree(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeId") Degree degree, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.removeDegree(degree);
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/removedegreecurricularplan/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String removedegreecurricularplan(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model) {
        bean.removeDegreeCurricularPlan(degreeCurricularPlan);
        bean.update();
        if (bean.isToUpdate()) {
            return this._update(executionYear, bean, model);
        }
        return this._create(executionYear, bean, model);
    }

    @RequestMapping(value={"/update/{executionYearId}/{erpTuitionInfoTypeId}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="erpTuitionInfoTypeId") ERPTuitionInfoType erpTuitionInfoType, Model model) {
        ERPTuitionInfoTypeBean bean = new ERPTuitionInfoTypeBean(erpTuitionInfoType);
        return this._update(executionYear, bean, model);
    }

    private String _update(ExecutionYear executionYear, ERPTuitionInfoTypeBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("beanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage(_UPDATE_URI);
    }

    @RequestMapping(value={"/update/{executionYearId}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") ERPTuitionInfoTypeBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            bean.getErpTuitionInfoType().edit(bean);
            return "redirect:/academictreasury/erptuitioninfotype/search/" + executionYear.getExternalId();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._update(executionYear, bean, model);
        }
    }

    @RequestMapping(value={"/delete/{executionYearId}/{erpTuitionInfoTypeId}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="erpTuitionInfoTypeId") ERPTuitionInfoType erpTuitionInfoType, Model model, RedirectAttributes redirectAttributes) {
        try {
            erpTuitionInfoType.delete();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect("/academictreasury/erptuitioninfotype/search/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/toogleactive/{executionYearId}/{erpTuitionInfoTypeId}"}, method={RequestMethod.POST})
    public String toogleactive(@PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="erpTuitionInfoTypeId") ERPTuitionInfoType erpTuitionInfoType, Model model, RedirectAttributes redirectAttributes) {
        try {
            erpTuitionInfoType.toogleActive();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect("/academictreasury/erptuitioninfotype/search/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/toogleexportationactive/{executionYearId}"}, method={RequestMethod.POST})
    public String toogleexportationactive(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        try {
            ERPTuitionInfoSettings.getInstance().toogleExportationActive();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect("/academictreasury/erptuitioninfotype/search/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }
}

