/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.exemptions.requests;

import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.exemptions.requests.ExemptionsGenerationRequestFile;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.ExemptionsGenerationRequestFile.title", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/exemptionsgenerationrequestfile"})
public class ExemptionsGenerationRequestFileController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/exemptionsgenerationrequestfile";
    private static final String JSP_PATH = "academicTreasury/exemptionsgenerationrequestfile";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/exemptionsgenerationrequestfile/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/exemptionsgenerationrequestfile/create";
    private static final String _CONFIRMDEBTCREATION_URI = "/confirmdebtcreation";
    public static final String CONFIRMDEBTCREATION_URL = "/academictreasury/exemptionsgenerationrequestfile/confirmdebtcreation";
    private static final String _PROCESSREQUEST_URI = "/processrequest";
    public static final String PROCESSREQUEST_URL = "/academictreasury/exemptionsgenerationrequestfile/processrequest";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/academictreasury/exemptionsgenerationrequestfile/download";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/exemptionsgenerationrequestfile/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("requestFiles", ExemptionsGenerationRequestFile.findAll().sorted(ExemptionsGenerationRequestFile.COMPARE_BY_CREATION_DATE).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return this._createFirstPage(model);
    }

    public String _createFirstPage(Model model) {
        model.addAttribute("treasuryExemptionTypesSet", TreasuryExemptionType.findAll().sorted(TreasuryExemptionType.COMPARE_BY_NAME).collect(Collectors.toList()));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="treasuryExemptionTypeId", required=false) TreasuryExemptionType treasuryExemptionType, @RequestParam(value="requestFile", required=true) MultipartFile requestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            byte[] content = requestFile.getBytes();
            if (treasuryExemptionType == null) {
                this.addErrorMessage("error.ExemptionsGenerationRequestFile.treasuryExemptionType.required", model);
                return this._createFirstPage(model);
            }
            ExemptionsGenerationRequestFile.readExcel((TreasuryExemptionType)treasuryExemptionType, (byte[])content);
            ExemptionsGenerationRequestFile file = ExemptionsGenerationRequestFile.create((TreasuryExemptionType)treasuryExemptionType, (String)requestFile.getOriginalFilename(), (byte[])content);
            return this.redirect("/academictreasury/exemptionsgenerationrequestfile/confirmdebtcreation/" + file.getExternalId(), model, redirectAttributes);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(model);
        }
    }

    @RequestMapping(value={"/confirmdebtcreation/{fileId}"}, method={RequestMethod.GET})
    public String confirmdebtcreation(@PathVariable(value="fileId") ExemptionsGenerationRequestFile exemptionsGenerationRequestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            model.addAttribute("exemptionsGenerationRequestFile", (Object)exemptionsGenerationRequestFile);
            model.addAttribute("rows", (Object)ExemptionsGenerationRequestFile.readExcel((TreasuryExemptionType)exemptionsGenerationRequestFile.getTreasuryExemptionType(), (byte[])exemptionsGenerationRequestFile.getContent()));
            model.addAttribute("requestFile", (Object)exemptionsGenerationRequestFile);
            model.addAttribute("processable", (Object)true);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
        }
        return this.jspPage("confirm");
    }

    @RequestMapping(value={"/processrequest/{fileId}"}, method={RequestMethod.POST})
    public String processrequest(@PathVariable(value="fileId") ExemptionsGenerationRequestFile exemptionsGenerationRequestFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            exemptionsGenerationRequestFile.process();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle((String)"label.MassiveDebtGenerationRequestFile.success", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.confirmdebtcreation(exemptionsGenerationRequestFile, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/download/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable(value="fileId") ExemptionsGenerationRequestFile exemptionsGenerationRequestFile, HttpServletRequest request, HttpServletResponse response, Model model) {
        response.setContentLength(exemptionsGenerationRequestFile.getContent().length);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", "attachment; filename=" + exemptionsGenerationRequestFile.getFilename());
        try {
            response.getOutputStream().write(exemptionsGenerationRequestFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/exemptionsgenerationrequestfile/" + page;
    }
}

