/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct$callable$create;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct$callable$delete;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct$callable$update;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPTuitionInfoProduct
extends ERPTuitionInfoProduct_Base {
    public static final Advice advice$update = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ERPTuitionInfoProduct() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ERPTuitionInfoProduct(String code, String name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoProduct.bennu.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoProduct.code.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoProduct.name.required", new String[0]);
        }
        if (ERPTuitionInfoProduct.findByCode(this.getCode()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoProduct.code.not.unique", new String[0]);
        }
    }

    public void update(String string) {
        Object object = advice$update.perform((Callable)new ERPTuitionInfoProduct$callable$update(this, string));
    }

    static /* synthetic */ void advised$update(ERPTuitionInfoProduct this_, String name) {
        this_.setName(name);
        this_.checkRules();
    }

    private boolean isDeletable() {
        return this.getErpTuitionInfoTypesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ERPTuitionInfoProduct$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ERPTuitionInfoProduct this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoProduct.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<ERPTuitionInfoProduct> findAll() {
        return FenixFramework.getDomainRoot().getErpTuitionInfoProductsSet().stream();
    }

    public static Stream<ERPTuitionInfoProduct> findByCode(String code) {
        return ERPTuitionInfoProduct.findAll().filter(p -> p.getCode().equals(code));
    }

    public static ERPTuitionInfoProduct create(String string, String string2) {
        return (ERPTuitionInfoProduct)((Object)advice$create.perform((Callable)new ERPTuitionInfoProduct$callable$create(string, string2)));
    }

    static /* synthetic */ ERPTuitionInfoProduct advised$create(String code, String name) {
        return new ERPTuitionInfoProduct(code, name);
    }
}

