/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;

public class DebtAccountReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.finantialInstitutionName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.code", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.customerActive", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.addressCountryCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.vatNumberValid", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.totalInDebt", new String[0])};
    final DebtAccount debtAccount;
    private PersonCustomer personCustomer;
    boolean completed = false;
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String finantialInstitutionName;
    private String customerId;
    private String customerCode;
    private boolean customerActive;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private String addressCountryCode;
    private Integer studentNumber;
    private boolean vatNumberValid;
    private BigDecimal totalInDebt;
    private BigDecimal dueInDebt;
    private String decimalSeparator;
    private Set<Registration> activeRegistrations;

    public DebtAccountReportEntryBean(DebtAccount debtAccount, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ".";
        this.debtAccount = debtAccount;
        try {
            Student student;
            if (this.debtAccount.getCustomer().isPersonCustomer()) {
                this.personCustomer = (PersonCustomer)this.debtAccount.getCustomer();
            }
            this.identification = debtAccount.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)debtAccount);
            this.creationDate = treasuryServices.versioningCreationDate((Object)debtAccount);
            this.finantialInstitutionName = debtAccount.getFinantialInstitution().getName();
            this.customerId = debtAccount.getCustomer().getExternalId();
            this.customerCode = debtAccount.getCustomer().getCode();
            this.customerActive = debtAccount.getCustomer().isActive();
            this.name = debtAccount.getCustomer().getName();
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)debtAccount.getCustomer()).getPerson().getIdDocumentType() != null) {
                this.identificationType = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getIdDocumentType().getLocalizedName();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
                this.identificationType = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedName();
            }
            this.identificationNumber = debtAccount.getCustomer().getIdentificationNumber();
            this.vatNumber = debtAccount.getCustomer().getUiFiscalNumber();
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null) {
                this.email = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInstitutionalOrDefaultEmailAddressValue();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null) {
                this.email = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
            }
            this.address = debtAccount.getCustomer().getUiCompleteAddress();
            this.addressCountryCode = this.valueOrEmpty(debtAccount.getCustomer().getAddressCountryCode());
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent() != null) {
                this.studentNumber = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getNumber();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent() != null) {
                this.studentNumber = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent().getNumber();
            }
            this.vatNumberValid = FiscalCodeValidation.isValidFiscalNumber((String)debtAccount.getCustomer().getAddressCountryCode(), (String)debtAccount.getCustomer().getFiscalNumber());
            this.totalInDebt = debtAccount.getTotalInDebt();
            this.dueInDebt = debtAccount.getDueInDebt();
            this.activeRegistrations = new HashSet<Registration>();
            if (this.debtAccount.getCustomer().isPersonCustomer() && (student = this.personCustomer.getAssociatedPerson().getStudent()) != null) {
                this.activeRegistrations = student.getActiveRegistrationStream().collect(Collectors.toSet());
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(debtAccount, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            ExcelUtil.createCellWithValue((Row)row, (int)0, (String)this.identification);
            if (!this.completed) {
                ExcelUtil.createCellWithValue((Row)row, (int)1, (String)AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.versioningCreator);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.finantialInstitutionName));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerActive));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.name));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationType));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.email));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.address));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.addressCountryCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.studentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumberValid));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.totalInDebt.toString());
            if (",".equals(this.decimalSeparator)) {
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.totalInDebt.toString().replace(".", ","));
            } else {
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.totalInDebt.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.debtAccount, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public String getVersioningCreator() {
        return this.versioningCreator;
    }

    public void setVersioningCreator(String versioningCreator) {
        this.versioningCreator = versioningCreator;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getFinantialInstitutionName() {
        return this.finantialInstitutionName;
    }

    public void setFinantialInstitutionName(String finantialInstitutionName) {
        this.finantialInstitutionName = finantialInstitutionName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public boolean isCustomerActive() {
        return this.customerActive;
    }

    public void setCustomerActive(boolean customerActive) {
        this.customerActive = customerActive;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddressCountryCode() {
        return this.addressCountryCode;
    }

    public void setAddressCountryCode(String addressCountryCode) {
        this.addressCountryCode = addressCountryCode;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public boolean isVatNumberValid() {
        return this.vatNumberValid;
    }

    public void setVatNumberValid(boolean vatNumberValid) {
        this.vatNumberValid = vatNumberValid;
    }

    public BigDecimal getTotalInDebt() {
        return this.totalInDebt;
    }

    public void setTotalInDebt(BigDecimal totalInDebt) {
        this.totalInDebt = totalInDebt;
    }

    public BigDecimal getDueInDebt() {
        return this.dueInDebt;
    }

    public void setDueInDebt(BigDecimal dueInDebt) {
        this.dueInDebt = dueInDebt;
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public PersonCustomer getPersonCustomer() {
        return this.personCustomer;
    }

    public void setPersonCustomer(PersonCustomer personCustomer) {
        this.personCustomer = personCustomer;
    }

    public Set<Registration> getActiveRegistrations() {
        return this.activeRegistrations;
    }

    public void setActiveRegistrations(Set<Registration> activeRegistrations) {
        this.activeRegistrations = activeRegistrations;
    }
}

