/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.exemptions;

import java.util.stream.Stream;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.tuition.exemptions.StatuteExemptionByIntervalMapEntry_Base;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import pt.ist.fenixframework.FenixFramework;

public class StatuteExemptionByIntervalMapEntry
extends StatuteExemptionByIntervalMapEntry_Base {
    public StatuteExemptionByIntervalMapEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public StatuteExemptionByIntervalMapEntry(FinantialEntity finantialEntity, ExecutionInterval executionInterval, StatuteType statuteType, TreasuryExemptionType treasuryExemptionType) {
        this();
        this.setFinantialEntity(finantialEntity);
        this.setExecutionInterval(executionInterval);
        this.setStatuteType(statuteType);
        this.setTreasuryExemptionType(treasuryExemptionType);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException("error.StatuteExemptionByIntervalMapEntry.domainRoot.required");
        }
        if (this.getFinantialEntity() == null) {
            throw new IllegalStateException("error.StatuteExemptionByIntervalMapEntry.finantialEntity.required");
        }
        if (this.getExecutionInterval() == null) {
            throw new IllegalStateException("error.StatuteExemptionByIntervalMapEntry.executionInterval.required");
        }
        if (this.getStatuteType() == null) {
            throw new IllegalStateException("error.StatuteExemptionByIntervalMapEntry.statuteType.required");
        }
        if (this.getTreasuryExemptionType() == null) {
            throw new IllegalStateException("error.StatuteExemptionByIntervalMapEntry.treasuryExemptionType.required");
        }
        if (StatuteExemptionByIntervalMapEntry.find(this.getFinantialEntity(), this.getExecutionInterval(), this.getStatuteType(), this.getTreasuryExemptionType()).count() > 1L) {
            throw new IllegalStateException(AcademicTreasuryConstants.academicTreasuryBundle("error.StatuteExemptionByIntervalMapEntry.already.mapped", new String[0]));
        }
    }

    public static Stream<StatuteExemptionByIntervalMapEntry> find(FinantialEntity finantialEntity, ExecutionInterval executionInterval) {
        return executionInterval.getStatuteExemptionByIntervalMapEntrySet().stream().filter(e -> e.getFinantialEntity() == finantialEntity);
    }

    public static Stream<StatuteExemptionByIntervalMapEntry> find(FinantialEntity finantialEntity, ExecutionInterval executionInterval, StatuteType statuteType, TreasuryExemptionType treasuryExemptionType) {
        return StatuteExemptionByIntervalMapEntry.find(finantialEntity, executionInterval).filter(s -> s.getStatuteType() == statuteType).filter(s -> s.getTreasuryExemptionType() == treasuryExemptionType);
    }

    public static StatuteExemptionByIntervalMapEntry create(FinantialEntity finantialEntity, ExecutionInterval executionInterval, StatuteType statuteType, TreasuryExemptionType treasuryExemptionType) {
        return new StatuteExemptionByIntervalMapEntry(finantialEntity, executionInterval, statuteType, treasuryExemptionType);
    }
}

