/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies.massive;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.IMassiveDebtGenerationStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFileBean;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRowResult;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanOrder;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.academictreasury.util.ExcelUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class TuitionAcademicTaxGenerationStrategy
implements IMassiveDebtGenerationStrategy<MassiveDebtGenerationRowResult> {
    private static final int MAX_COLS = 5;
    private static final int STUDENT_NUMBER_IDX = 0;
    private static final int STUDENT_NAME_IDX = 1;
    private static final int DEGREE_IDX = 2;
    private static final int DCP_IDX = 3;
    private static final int TUITION_PLAN_IDX = 4;

    @Override
    public void checkRules(MassiveDebtGenerationRequestFile file) {
        if (file.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.executionYear.required", new String[0]);
        }
        if (file.getTuitionPaymentPlanGroup() == null && file.getAcademicTax() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.tuitionPaymentPlanGroup.or.academic.tax.required", new String[0]);
        }
        if (file.getTuitionPaymentPlanGroup() != null && file.getAcademicTax() != null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.tuitionPaymentPlanGroup.and.academic.tax.specified", new String[0]);
        }
        if (file.getDebtDate() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.debtDate.required", new String[0]);
        }
    }

    @Override
    public void process(MassiveDebtGenerationRequestFile file) {
        MassiveDebtGenerationRequestFileBean bean = new MassiveDebtGenerationRequestFileBean(file);
        List<MassiveDebtGenerationRowResult> rowResult = this.readExcel(file.getContent(), bean);
        for (MassiveDebtGenerationRowResult row : rowResult) {
            try {
                boolean createdAcademicTax;
                if (file.getTuitionPaymentPlanGroup() != null) {
                    boolean createdTuition = TuitionServices.createTuitionForRegistration(row.getStudentCurricularPlan().getRegistration(), file.getExecutionYear(), file.getDebtDate(), true, row.getTuitionPaymentPlan(), true);
                    if (createdTuition) continue;
                    Integer registrationNumber = row.getStudentCurricularPlan().getRegistration().getNumber();
                    String studentName = row.getStudentCurricularPlan().getRegistration().getStudent().getName();
                    String tuitionPaymentPlanName = row.getTuitionPaymentPlan().getConditionsDescription();
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.tuition.not.created", new String[]{String.valueOf(registrationNumber), studentName, tuitionPaymentPlanName});
                }
                if (file.getAcademicTax() == null || (createdAcademicTax = AcademicTaxServices.createAcademicTaxForDefaultFinantialEntity(row.getStudentCurricularPlan().getRegistration(), file.getExecutionYear(), file.getAcademicTax(), file.getDebtDate(), true))) continue;
                Integer registrationNumber = row.getStudentCurricularPlan().getRegistration().getNumber();
                String studentName = row.getStudentCurricularPlan().getRegistration().getStudent().getName();
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.academicTax.not.created", new String[]{String.valueOf(registrationNumber), studentName});
            }
            catch (Exception e) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.debt.not.created", new String[]{String.valueOf(row.getRowNum()), String.valueOf(row.getStudentCurricularPlan().getRegistration().getNumber()), row.getStudentCurricularPlan().getRegistration().getPerson().getName(), e.getLocalizedMessage()});
            }
        }
        file.setWhenProcessed(new DateTime());
    }

    @Override
    public List<MassiveDebtGenerationRowResult> readExcel(byte[] content, MassiveDebtGenerationRequestFileBean bean) {
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = bean.getTuitionPaymentPlanGroup();
        AcademicTax academicTax = bean.getAcademicTax();
        ExecutionYear executionYear = bean.getExecutionYear();
        LocalDate debtDate = bean.getDebtDate();
        try {
            if (executionYear == null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.executionYear.required", new String[0]);
            }
            if (tuitionPaymentPlanGroup == null && academicTax == null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.tuitionPaymentPlanGroup.or.academic.tax.required", new String[0]);
            }
            if (tuitionPaymentPlanGroup != null && academicTax != null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.tuitionPaymentPlanGroup.and.academic.tax.specified", new String[0]);
            }
            if (debtDate == null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.debtDate.required", new String[0]);
            }
            List<List<String>> data = ExcelUtils.readExcel(new ByteArrayInputStream(content), 5);
            ArrayList result = Lists.newArrayList();
            int rowNum = 0;
            for (List<String> row : data) {
                if (++rowNum == 1) continue;
                if (Strings.isNullOrEmpty((String)row.get(0))) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.student.number.invalid", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)row.get(1))) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.student.name.invalid", String.valueOf(rowNum));
                }
                if (Strings.isNullOrEmpty((String)row.get(2))) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.degree.code.invalid", String.valueOf(rowNum));
                }
                int registrationNumber = -1;
                try {
                    registrationNumber = Integer.parseInt(row.get(0).trim());
                }
                catch (NumberFormatException e) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.student.number.invalid", String.valueOf(rowNum));
                }
                String studentName = row.get(1).trim();
                String degreeCode = row.get(2).trim();
                String dcpName = row.get(3).trim();
                String tuitionPaymentPlanName = row.get(4) != null ? row.get(4).trim() : null;
                Degree degree = Degree.find((String)degreeCode);
                if (degree == null) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.degree.not.found", String.valueOf(rowNum));
                }
                Registration registration = this.findActiveRegistration(executionYear, registrationNumber, degree, dcpName, rowNum);
                if (registration == null) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.registration.not.found", String.valueOf(rowNum));
                }
                if (!registration.getStudent().getName().trim().equals(studentName)) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.student.name.not.equal", String.valueOf(rowNum));
                }
                StudentCurricularPlan studentCurricularPlan = null;
                studentCurricularPlan = !Strings.isNullOrEmpty((String)dcpName) ? registration.getStudentCurricularPlan(executionYear) : registration.getLastStudentCurricularPlan();
                if (!Strings.isNullOrEmpty((String)dcpName) && !studentCurricularPlan.getName().equals(dcpName)) {
                    throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.dcp.name.not.equal", String.valueOf(rowNum));
                }
                if (tuitionPaymentPlanGroup != null) {
                    TuitionPaymentPlanOrder tuitionPaymentPlanOrder = TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(tuitionPaymentPlanGroup, studentCurricularPlan.getDegreeCurricularPlan(), executionYear).filter(t -> t.getTuitionPaymentPlan().getConditionsDescription().equals(tuitionPaymentPlanName)).findFirst().orElse(null);
                    if (tuitionPaymentPlanOrder == null) {
                        throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.tuition.payment.plan.not.found", new String[]{String.valueOf(rowNum), studentCurricularPlan.getName(), tuitionPaymentPlanName});
                    }
                    result.add(new MassiveDebtGenerationRowResult(rowNum, executionYear, studentCurricularPlan, tuitionPaymentPlanOrder.getTuitionPaymentPlan(), debtDate));
                    continue;
                }
                if (academicTax != null) {
                    result.add(new MassiveDebtGenerationRowResult(rowNum, executionYear, studentCurricularPlan, academicTax, debtDate));
                    continue;
                }
                throw new RuntimeException("error");
            }
            return result;
        }
        catch (IOException e) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.invalid.sheet", new String[0]);
        }
    }

    private Registration findActiveRegistration(ExecutionYear executionYear, int registrationNumber, Degree degree, String dcpName, int rowNum) {
        Registration result = null;
        for (Registration registration : Registration.readByNumber((Integer)registrationNumber)) {
            RegistrationState lastRegistrationState = registration.getLastRegistrationState(executionYear);
            if (lastRegistrationState == null || !lastRegistrationState.isActive() || registration.getDegree() != degree || !Strings.isNullOrEmpty((String)dcpName) && registration.getStudentCurricularPlan(executionYear) == null || Strings.isNullOrEmpty((String)dcpName) && registration.getLastStudentCurricularPlan() == null || !Strings.isNullOrEmpty((String)dcpName) && !registration.getStudentCurricularPlan(executionYear).getName().equals(dcpName)) continue;
            if (result != null) {
                throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.found.more.than.one.registration", String.valueOf(rowNum));
            }
            result = registration;
        }
        return result;
    }

    @Override
    public boolean isDebtDateRequired() {
        return true;
    }

    @Override
    public boolean isExecutionYearRequired() {
        return true;
    }

    @Override
    public boolean isForAcademicTaxRequired() {
        return true;
    }

    @Override
    public boolean isFinantialInstitutionRequired() {
        return false;
    }

    @Override
    public boolean isReasonRequired() {
        return false;
    }

    @Override
    public String viewUrl() {
        return "/WEB-INF/academicTreasury/debtGeneration/strategies/massive/TuitionAcademicTaxGenerationStrategy.jsp";
    }

    @Override
    public String dataDescription(MassiveDebtGenerationRequestFile file) {
        if (file.getTuitionPaymentPlanGroup() != null) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionAcademicTaxGenerationStrategy.dataDescription.tuitionPaymentPlanGroup", file.getTuitionPaymentPlanGroup().getName().getContent(), file.getExecutionYear().getQualifiedName(), file.getDebtDate().toString("dd/MM/yyyy"));
        }
        return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionAcademicTaxGenerationStrategy.dataDescription.academicTax", file.getAcademicTax().getProduct().getName().getContent(), file.getExecutionYear().getQualifiedName(), file.getDebtDate().toString("dd/MM/yyyy"));
    }
}

