/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.academictax;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.dto.academictax.AcademicTaxDebtCreationBean$callable$updateData;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTaxDebtCreationBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private LocalDate debtDate;
    private ExecutionYear executionYear;
    private Registration registration;
    private FinantialEntity finantialEntity;
    private EnrolmentEvaluation improvementEvaluation;
    private DebtAccount debtAccount;
    private List<TreasuryTupleDataSourceBean> registrationDataSource;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource;
    private List<TreasuryTupleDataSourceBean> academicTaxesDataSource;
    private List<TreasuryTupleDataSourceBean> improvementEnrolmentEvaluationsDataSource;
    private AcademicTax academicTax;
    private boolean improvementTaxSelected;
    private String errorMessage;
    public static final Advice advice$updateData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AcademicTaxDebtCreationBean(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
        this.updateData();
    }

    public void updateData() {
        Object object = advice$updateData.perform((Callable)new AcademicTaxDebtCreationBean$callable$updateData(this));
    }

    static /* synthetic */ void advised$updateData(AcademicTaxDebtCreationBean this_) {
        RegistrationDataByExecutionYear findRegistrationDataByExecutionYear;
        if (!(this_.executionYear == null || this_.registration != null && this_.possibleExecutionYears().contains(this_.executionYear))) {
            this_.executionYear = null;
            this_.improvementEvaluation = null;
        }
        this_.getAcademicTaxesDataSource();
        this_.getRegistrationDataSource();
        this_.getExecutionYearDataSource();
        this_.getImprovementEnrolmentEvaluationsDataSource();
        this_.isImprovementTaxSelected();
        this_.debtDate = this_.registration != null && this_.executionYear != null ? ((findRegistrationDataByExecutionYear = this_.findRegistrationDataByExecutionYear(this_.registration, this_.executionYear)) != null ? findRegistrationDataByExecutionYear.getEnrolmentDate() : new LocalDate()) : new LocalDate();
        this_.getErrorMessage();
    }

    private RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(rd -> rd.getExecutionYear() == executionYear).findAny().orElse(null);
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        this.executionYearDataSource = Lists.newArrayList();
        for (ExecutionYear executionYear : this.possibleExecutionYears()) {
            String id = executionYear.getExternalId();
            Object text = executionYear.getQualifiedName();
            if (this.registration != null) {
                Set<EnrolmentEvaluation> enrolments;
                Set<Object> set = enrolments = this.isImprovementTax() ? TuitionServices.improvementEnrolments(this.registration, executionYear) : TuitionServices.normalEnrolmentsIncludingAnnuled(this.registration, executionYear);
                if (enrolments.size() == 1) {
                    text = (String)text + " " + AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxDebtCreationBean.enrolments.one", new String[0]);
                } else if (enrolments.size() > 1) {
                    text = (String)text + " " + AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxDebtCreationBean.enrolments", String.valueOf(enrolments.size()));
                }
            }
            this.executionYearDataSource.add(new TreasuryTupleDataSourceBean(id, (String)text));
        }
        return this.executionYearDataSource;
    }

    private List<ExecutionYear> possibleExecutionYears() {
        if (this.academicTax == null || this.registration == null) {
            return Lists.newArrayList();
        }
        return Sets.newHashSet((Iterable)ExecutionYear.readNotClosedExecutionYears()).stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList());
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationDataSource() {
        if (!this.isStudent()) {
            this.registrationDataSource = Lists.newArrayList();
            return this.registrationDataSource;
        }
        this.registrationDataSource = ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet().stream().map(r -> {
            String degreeCode = r.getDegree().getCode();
            String degreePresentationName = r.getDegree().getPresentationName(this.getExecutionYear());
            String registrationDate = r.getStartDate() != null ? r.getStartDate().toString("yyyy-MM-dd") : "";
            String agreement = r.getRegistrationProtocol() != null ? r.getRegistrationProtocol().getDescription().getContent() : "";
            TreasuryTupleDataSourceBean t = new TreasuryTupleDataSourceBean(r.getExternalId(), String.format("[%s] %s (%s %s)", degreeCode, degreePresentationName, registrationDate, agreement));
            return t;
        }).collect(Collectors.toList());
        return this.registrationDataSource;
    }

    public boolean isCharged() {
        if (this.academicTax == null) {
            return false;
        }
        if (this.registration == null || this.executionYear == null) {
            return false;
        }
        if (this.isImprovementTax() && this.improvementEvaluation == null) {
            return false;
        }
        if (this.isImprovementTax()) {
            return AcademicTaxServices.isImprovementAcademicTaxCharged(this.registration, this.executionYear, this.improvementEvaluation);
        }
        return AcademicTaxServices.isAcademicTaxCharged(this.registration, this.executionYear, this.academicTax);
    }

    public String getErrorMessage() {
        this.errorMessage = "";
        if (this.academicTax == null) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.AcademicTaxDebtCreation.select.academic.tax", new String[0]);
            return this.errorMessage;
        }
        if (this.registration == null || this.executionYear == null) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.AcademicTaxDebtCreation.select.registration.and.execution.year", new String[0]);
            return this.errorMessage;
        }
        if (this.isImprovementTax() && this.improvementEvaluation == null) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.AcademicTaxDebtCreation.select.improvement.evaluation", new String[0]);
            return this.errorMessage;
        }
        if (this.isCharged()) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.AcademicTaxDebtCreation.academic.tax.already.charged", new String[0]);
            return this.errorMessage;
        }
        return this.errorMessage;
    }

    public List<TreasuryTupleDataSourceBean> getAcademicTaxesDataSource() {
        this.academicTaxesDataSource = AcademicTax.findAll().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getProduct().getName().getContent())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        return this.academicTaxesDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getImprovementEnrolmentEvaluationsDataSource() {
        if (!this.isStudent()) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        if (this.academicTax == null) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        if (!this.academicTax.isImprovementTax()) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        if (this.getRegistration() == null || this.getExecutionYear() == null) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        this.improvementEnrolmentEvaluationsDataSource = TuitionServices.improvementEnrolments(this.getRegistration(), this.getExecutionYear()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getEnrolment().getName().getContent() + " - " + l.getExecutionPeriod().getQualifiedName())).collect(Collectors.toList()).stream().sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        return this.improvementEnrolmentEvaluationsDataSource;
    }

    public boolean isImprovementTax() {
        return this.academicTax != null && this.academicTax.isImprovementTax();
    }

    public boolean isStudent() {
        return this.debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent() != null;
    }

    public boolean isImprovementTaxSelected() {
        this.improvementTaxSelected = this.isImprovementTax();
        return this.improvementTaxSelected;
    }

    public LocalDate getDebtDate() {
        return this.debtDate;
    }

    public void setDebtDate(LocalDate debtDate) {
        this.debtDate = debtDate;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity finantialEntity) {
        this.finantialEntity = finantialEntity;
    }

    public AcademicTax getAcademicTax() {
        return this.academicTax;
    }

    public void setAcademicTax(AcademicTax academicTax) {
        this.academicTax = academicTax;
    }

    public EnrolmentEvaluation getImprovementEvaluation() {
        return this.improvementEvaluation;
    }

    public void setImprovementEvaluation(EnrolmentEvaluation improvementEvaluation) {
        this.improvementEvaluation = improvementEvaluation;
    }
}

