/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.academicservicerequest;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.dto.academicservicerequest.AcademicServiceRequestDebtCreationBean$callable$updateData;
import org.fenixedu.academictreasury.services.EmolumentServices;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicServiceRequestDebtCreationBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private LocalDate debtDate;
    private Registration registration;
    private DebtAccount debtAccount;
    private List<TreasuryTupleDataSourceBean> registrationDataSource;
    private List<TreasuryTupleDataSourceBean> academicServiceRequestesDataSource;
    private AcademicServiceRequest academicServiceRequest;
    public static final Advice advice$updateData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AcademicServiceRequestDebtCreationBean(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
        this.updateData();
    }

    public void updateData() {
        Object object = advice$updateData.perform((Callable)new AcademicServiceRequestDebtCreationBean$callable$updateData(this));
    }

    static /* synthetic */ void advised$updateData(AcademicServiceRequestDebtCreationBean this_) {
        if (this_.registration == null) {
            this_.academicServiceRequest = null;
        }
        this_.getRegistrationDataSource();
        this_.getAcademicServiceRequestesDataSource();
        if (this_.registration != null && this_.academicServiceRequest != null) {
            this_.debtDate = EmolumentServices.possibleDebtDateOnAcademicService((ITreasuryServiceRequest)this_.academicServiceRequest);
            if (this_.debtDate == null) {
                this_.debtDate = new LocalDate();
            }
        } else {
            this_.debtDate = new LocalDate();
        }
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationDataSource() {
        if (!this.isStudent()) {
            this.registrationDataSource = Lists.newArrayList();
            return this.registrationDataSource;
        }
        this.registrationDataSource = ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet().stream().map(r -> {
            String degreeCode = r.getDegree().getCode();
            String degreePresentationName = r.getDegree().getPresentationName();
            String registrationDate = r.getStartDate() != null ? r.getStartDate().toString("yyyy-MM-dd") : "";
            String agreement = r.getRegistrationProtocol() != null ? r.getRegistrationProtocol().getDescription().getContent() : "";
            TreasuryTupleDataSourceBean t = new TreasuryTupleDataSourceBean(r.getExternalId(), String.format("[%s] %s (%s %s)", degreeCode, degreePresentationName, registrationDate, agreement));
            return t;
        }).collect(Collectors.toList());
        return this.registrationDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getAcademicServiceRequestesDataSource() {
        if (this.registration == null) {
            this.academicServiceRequestesDataSource = Lists.newArrayList();
            return this.academicServiceRequestesDataSource;
        }
        this.academicServiceRequestesDataSource = AcademicTreasuryEvent.find(((PersonCustomer)this.debtAccount.getCustomer()).getAssociatedPerson()).filter(e -> e.isAcademicServiceRequestEvent()).map(e -> e.getITreasuryServiceRequest()).map(r -> new TreasuryTupleDataSourceBean(r.getExternalId(), String.format("[%s] %s", r.getServiceRequestNumberYear(), r.getDescription()))).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        return this.academicServiceRequestesDataSource;
    }

    public boolean isStudent() {
        return this.debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent() != null;
    }

    public LocalDate getDebtDate() {
        return this.debtDate;
    }

    public void setDebtDate(LocalDate debtDate) {
        this.debtDate = debtDate;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public AcademicServiceRequest getAcademicServiceRequest() {
        return this.academicServiceRequest;
    }

    public void setAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        this.academicServiceRequest = academicServiceRequest;
    }
}

