/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.calculators;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.tuition.ITuitionRegistrationServiceParameters;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionCalculatorAggregator_Base;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;

public class TuitionCalculatorAggregator
extends TuitionCalculatorAggregator_Base {
    public TuitionCalculatorAggregator() {
    }

    public TuitionCalculatorAggregator(LocalizedString name) {
        this();
        this.setName(name);
    }

    public void delete() {
        this.getTuitionPaymentPlanCalculatorChildSet().forEach(TuitionPaymentPlanCalculator::delete);
        super.delete();
    }

    public boolean isValid() {
        return this.getTuitionPaymentPlanCalculatorChildSet().stream().map(c -> c.isValid()).reduce((a, c) -> a != false && c != false).orElse(false);
    }

    public BigDecimal getTotalAmount(Registration registration) {
        return this.getTotalAmount(registration, (ITuitionRegistrationServiceParameters)null);
    }

    public BigDecimal getTotalAmount(Registration registration, ITuitionRegistrationServiceParameters parameters) {
        Predicate<TuitionPaymentPlanCalculator> conditionValidTo = tuitionPaymentPlanCalculator -> tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().stream().allMatch(c -> c.isValidTo(registration, this.getExecutionYear(), null));
        BigDecimal totalAmount = this.getTuitionPaymentPlanCalculatorChildSet().stream().filter(conditionValidTo).map(c -> c.getTotalAmount(registration, parameters)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (this.getMinimumAmount() != null) {
            totalAmount = totalAmount.max(this.getMinimumAmount());
        }
        if (this.getMaximumAmount() != null) {
            totalAmount = totalAmount.min(this.getMaximumAmount());
        }
        return totalAmount;
    }

    public BigDecimal getTotalAmount(Enrolment enrolment) {
        return this.getTotalAmount(enrolment, (ITuitionRegistrationServiceParameters)null);
    }

    public BigDecimal getTotalAmount(Enrolment enrolment, ITuitionRegistrationServiceParameters parameters) {
        Predicate<TuitionPaymentPlanCalculator> conditionValidTo = tuitionPaymentPlanCalculator -> tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().isEmpty() || tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().stream().allMatch(c -> c.isValidTo(enrolment.getRegistration(), this.getExecutionYear(), enrolment));
        BigDecimal totalAmount = this.getTuitionPaymentPlanCalculatorChildSet().stream().filter(conditionValidTo).map(c -> c.getTotalAmount(enrolment, parameters)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (this.getMinimumAmount() != null) {
            totalAmount = totalAmount.max(this.getMinimumAmount());
        }
        if (this.getMaximumAmount() != null) {
            totalAmount = totalAmount.min(this.getMaximumAmount());
        }
        return totalAmount;
    }

    public String getCalculationDescription(Registration registration) {
        Predicate<TuitionPaymentPlanCalculator> conditionValidTo = tuitionPaymentPlanCalculator -> tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().isEmpty() || tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().stream().allMatch(c -> c.isValidTo(registration, this.getExecutionYear(), null));
        return this.getTuitionPaymentPlanCalculatorChildSet().stream().filter(conditionValidTo).map(c -> c.getCalculationDescription(registration)).reduce((a, c) -> a + c).get();
    }

    public String getCalculationDescription(Enrolment enrolment) {
        Predicate<TuitionPaymentPlanCalculator> conditionValidTo = tuitionPaymentPlanCalculator -> tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().isEmpty() || tuitionPaymentPlanCalculator.getTuitionConditionRulesSet().stream().allMatch(c -> c.isValidTo(enrolment.getRegistration(), this.getExecutionYear(), enrolment));
        return this.getTuitionPaymentPlanCalculatorChildSet().stream().filter(conditionValidTo).map(c -> c.getCalculationDescription(enrolment)).reduce((a, c) -> a + c).get();
    }

    public LocalizedString getParametersDescription() {
        LocalizedString description = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.TuitionCalculatorAggregator.description", new String[0]);
        BinaryOperator appendLocalizedString = (l1, l2) -> l1.append(l2, "\n");
        description.append(this.getTuitionPaymentPlanCalculatorChildSet().stream().sorted((a, c) -> a.getExternalId().compareTo(c.getExternalId())).map(c -> c.getParametersDescription()).reduce(new LocalizedString(), appendLocalizedString), "\n");
        return description;
    }

    public TuitionPaymentPlanCalculator copyTo(TuitionPaymentPlan tuitionPaymentPlanTarget) {
        TuitionCalculatorAggregator copy2 = TuitionCalculatorAggregator.create(this.getName());
        copy2.setTuitionPaymentPlan(tuitionPaymentPlanTarget);
        this.getTuitionPaymentPlanCalculatorChildSet().forEach(c -> c.copyTo(copy2));
        return copy2;
    }

    public TuitionPaymentPlanCalculator copyTo(TuitionCalculatorAggregator tuitionCalculatorAggregatorTarget) {
        TuitionCalculatorAggregator copy2 = TuitionCalculatorAggregator.create(this.getName());
        copy2.setTuitionCalculatorParentAggregator(tuitionCalculatorAggregatorTarget);
        this.getTuitionPaymentPlanCalculatorChildSet().forEach(c -> c.copyTo(copy2));
        return copy2;
    }

    public void fillWithParametersFromImportation(String parameters) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ConfigJsonType rootNode = (ConfigJsonType)objectMapper.readValue(parameters, ConfigJsonType.class);
            if (rootNode == null) {
                throw new IllegalArgumentException("error.TuitionCalculatorAggregator.fillWithParametersFromImportation.root.empty");
            }
            if (rootNode.childs == null || rootNode.childs.isEmpty()) {
                throw new IllegalArgumentException("error.TuitionCalculatorAggregator.fillWithParametersFromImportation.childs.empty");
            }
            for (ConfigChildJsonType configChildJsonType : rootNode.childs) {
                TuitionPaymentPlanCalculator childCalculator = (TuitionPaymentPlanCalculator)((Object)Class.forName(configChildJsonType.childClassName).getConstructor(LocalizedString.class).newInstance(new LocalizedString(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale(), configChildJsonType.childName)));
                childCalculator.setTuitionCalculatorParentAggregator(this);
                childCalculator.fillWithParametersFromImportation(configChildJsonType.childParameters);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalizedString getCalculatorPresentationName() {
        LocalizedString description = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.TuitionCalculatorAggregator.description", new String[0]);
        return description;
    }

    public static TuitionCalculatorAggregator create(LocalizedString name) {
        return new TuitionCalculatorAggregator(name);
    }

    private static class ConfigJsonType {
        List<ConfigChildJsonType> childs;

        private ConfigJsonType() {
        }
    }

    private static class ConfigChildJsonType {
        String childClassName;
        String childName;
        String childParameters;

        private ConfigChildJsonType() {
        }
    }
}

