/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.treasury.domain.bennu.signals.BennuSignalsHandler;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class HandleSettlementNotePayment
implements BennuSignalsHandler<SettlementNote> {
    public void handleObject(SettlementNote settlementNote) {
        boolean toReturn = true;
        try {
            toReturn = !FenixFramework.isDomainObjectValid((DomainObject)settlementNote);
        }
        catch (Throwable t) {
            toReturn = true;
        }
        if (toReturn) {
            return;
        }
        for (SettlementEntry s : settlementNote.getSettlemetEntries().collect(Collectors.toSet())) {
            AcademicTreasuryEvent academicTreasuryEvent;
            DebitEntry d;
            InvoiceEntry invoiceEntry = s.getInvoiceEntry();
            if (!(invoiceEntry instanceof DebitEntry) || (d = (DebitEntry)invoiceEntry).getTreasuryEvent() == null || !(d.getTreasuryEvent() instanceof AcademicTreasuryEvent) || !(academicTreasuryEvent = (AcademicTreasuryEvent)d.getTreasuryEvent()).isForTreasuryEventTarget()) continue;
            ((IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)academicTreasuryEvent);
        }
    }
}

