/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeAcademicEntry_Base;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.fenixframework.FenixFramework;

public class ERPTuitionInfoTypeAcademicEntry
extends ERPTuitionInfoTypeAcademicEntry_Base {
    public ERPTuitionInfoTypeAcademicEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private ERPTuitionInfoTypeAcademicEntry(ERPTuitionInfoType type, DegreeType degreeType) {
        this();
        this.setErpTuitionInfoType(type);
        this.setDegreeType(degreeType);
        this.setForRegistration(true);
        this.setForStandalone(false);
        this.setForExtracurricular(false);
        this.checkRules();
    }

    private ERPTuitionInfoTypeAcademicEntry(ERPTuitionInfoType type, Degree degree) {
        this();
        this.setErpTuitionInfoType(type);
        this.setDegreeType(degree.getDegreeType());
        this.setDegree(degree);
        this.setForRegistration(true);
        this.setForStandalone(false);
        this.setForExtracurricular(false);
        this.checkRules();
    }

    private ERPTuitionInfoTypeAcademicEntry(ERPTuitionInfoType type, DegreeCurricularPlan degreeCurricularPlan) {
        this();
        this.setErpTuitionInfoType(type);
        this.setDegreeType(degreeCurricularPlan.getDegree().getDegreeType());
        this.setDegree(degreeCurricularPlan.getDegree());
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setForRegistration(true);
        this.setForStandalone(false);
        this.setForExtracurricular(false);
        this.checkRules();
    }

    private ERPTuitionInfoTypeAcademicEntry(ERPTuitionInfoType type, boolean forStandalone, boolean forExtracurricular) {
        this();
        this.setErpTuitionInfoType(type);
        this.setForRegistration(false);
        this.setForStandalone(forStandalone);
        this.setForExtracurricular(forExtracurricular);
        this.checkRules();
    }

    void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.bennu.required", new String[0]);
        }
        if (this.getErpTuitionInfoType() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.erpTuitionInfoType.required", new String[0]);
        }
        if (!(this.isForRegistration() ^ this.isForStandalone() ^ this.isForExtracurricular())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeEntry.for.one.tuition.type.only", new String[0]);
        }
        if (this.isForRegistration() && this.getDegreeType() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeEntry.degreeType.required", new String[0]);
        }
        if (this.getDegree() != null && this.getDegree().getDegreeType() != this.getDegreeType()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeEntry.degreeType.of.degree.not.match.assigned.degree.type", new String[0]);
        }
        if (this.getDegreeCurricularPlan() != null && this.getDegreeCurricularPlan().getDegree() != this.getDegree()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeEntry.degree.of.degreeCurricularPlan.not.match.assigned.degree", new String[0]);
        }
        if ((this.isForStandalone() || this.isForExtracurricular()) && this.getDegreeType() != null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeEntry.degreeType.not.supported.for.standalone.or.extracurricular", new String[0]);
        }
        this.checkAcademicEntriesColisions();
    }

    private void checkAcademicEntriesColisions() {
        for (ERPTuitionInfoTypeAcademicEntry academicEntry : this.getErpTuitionInfoType().getErpTuitionInfoTypeAcademicEntriesSet()) {
            this.checkColision(academicEntry);
        }
    }

    private void checkColision(ERPTuitionInfoTypeAcademicEntry academicEntry) {
        block9: {
            Set allAcademicEntries;
            block12: {
                block11: {
                    ExecutionYear executionYear;
                    block10: {
                        block8: {
                            executionYear = academicEntry.getErpTuitionInfoType().getExecutionYear();
                            allAcademicEntries = ERPTuitionInfoType.findForExecutionYear(executionYear).filter(t -> !Sets.intersection((Set)academicEntry.getErpTuitionInfoType().getTuitionProductsSet(), (Set)t.getTuitionProductsSet()).isEmpty()).flatMap(t -> t.getErpTuitionInfoTypeAcademicEntriesSet().stream()).collect(Collectors.toSet());
                            if (!academicEntry.isDefinedForDegreeType()) break block8;
                            for (ERPTuitionInfoTypeAcademicEntry otherEntry : allAcademicEntries) {
                                if (academicEntry == otherEntry || academicEntry.getDegreeType() != otherEntry.getDegreeType()) continue;
                                throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.duplicated.for.degreeType", otherEntry.getDegreeType().getName().getContent());
                            }
                            break block9;
                        }
                        if (!academicEntry.isDefinedForDegree()) break block10;
                        for (ERPTuitionInfoTypeAcademicEntry otherEntry : allAcademicEntries) {
                            if (academicEntry == otherEntry) continue;
                            if ((otherEntry.isDefinedForDegree() || otherEntry.isDefinedForDegreeCurricularPlan()) && academicEntry.getDegree() == otherEntry.getDegree()) {
                                throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.duplicated.for.degree", otherEntry.getDegree().getPresentationName());
                            }
                            if (!otherEntry.isDefinedForDegreeType() || academicEntry.getDegreeType() != otherEntry.getDegreeType()) continue;
                            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.degreeType.of.degree.defined", new String[]{academicEntry.getDegree().getPresentationName(), otherEntry.getDegreeType().getName().getContent()});
                        }
                        break block9;
                    }
                    if (!academicEntry.isDefinedForDegreeCurricularPlan()) break block11;
                    for (ERPTuitionInfoTypeAcademicEntry otherEntry : allAcademicEntries) {
                        if (academicEntry == otherEntry) continue;
                        if (otherEntry.isDefinedForDegreeCurricularPlan() && academicEntry.getDegreeCurricularPlan() == otherEntry.getDegreeCurricularPlan()) {
                            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.duplicated.for.degreeCurricularPlan", otherEntry.getDegreeCurricularPlan().getName());
                        }
                        if (otherEntry.isDefinedForDegree() && academicEntry.getDegree() == otherEntry.getDegree()) {
                            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.degree.of.degreeCurricularPlan.defined", new String[]{academicEntry.getDegreeCurricularPlan().getName(), otherEntry.getDegree().getPresentationName()});
                        }
                        if (!otherEntry.isDefinedForDegreeType() || academicEntry.getDegreeType() != otherEntry.getDegreeType()) continue;
                        throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.degreeType.of.degreeCurricularPlan.defined", new String[]{academicEntry.getDegreeCurricularPlan().getPresentationName(executionYear), otherEntry.getDegreeType().getName().getContent()});
                    }
                    break block9;
                }
                if (!academicEntry.isForStandalone()) break block12;
                for (ERPTuitionInfoTypeAcademicEntry otherEntry : allAcademicEntries) {
                    if (academicEntry == otherEntry || !otherEntry.isForStandalone()) continue;
                    throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.duplicated.for.standalone", new String[0]);
                }
                break block9;
            }
            if (!academicEntry.isForExtracurricular()) break block9;
            for (ERPTuitionInfoTypeAcademicEntry otherEntry : allAcademicEntries) {
                if (academicEntry == otherEntry || !otherEntry.isForExtracurricular()) continue;
                throw new AcademicTreasuryDomainException("error.ERPTuitionInfoTypeAcademicEntry.entry.duplicated.for.extracurricular", new String[0]);
            }
        }
    }

    public boolean isForRegistration() {
        return this.getForRegistration();
    }

    public boolean isForStandalone() {
        return this.getForStandalone();
    }

    public boolean isForExtracurricular() {
        return this.getForExtracurricular();
    }

    public boolean isDefinedForDegreeCurricularPlan() {
        return this.isForRegistration() && this.getDegreeCurricularPlan() != null;
    }

    public boolean isDefinedForDegree() {
        return this.isForRegistration() && this.getDegree() != null && this.getDegreeCurricularPlan() == null;
    }

    public boolean isDefinedForDegreeType() {
        return this.isForRegistration() && this.getDegreeType() != null && this.getDegree() == null && this.getDegreeCurricularPlan() == null;
    }

    public boolean isAppliedForRegistration(Registration registration, ExecutionYear executionYear) {
        if (executionYear != this.getErpTuitionInfoType().getExecutionYear()) {
            return false;
        }
        if (this.isDefinedForDegreeCurricularPlan() && this.getDegreeCurricularPlan() == registration.getStudentCurricularPlan(executionYear).getDegreeCurricularPlan()) {
            return true;
        }
        if (this.isDefinedForDegree() && this.getDegree() == registration.getDegree()) {
            return true;
        }
        return this.isDefinedForDegreeType() && this.getDegreeType() == registration.getDegreeType();
    }

    public boolean isAppliedOnAcademicTreasuryEvent(AcademicTreasuryEvent event, ExecutionYear executionYear) {
        if (executionYear != this.getErpTuitionInfoType().getExecutionYear()) {
            return false;
        }
        Set debtProducts = DebitEntry.findActive((TreasuryEvent)event).map(d -> d.getProduct()).filter(p -> p != TreasurySettings.getInstance().getInterestProduct()).collect(Collectors.toSet());
        if (!this.getErpTuitionInfoType().getTuitionProductsSet().containsAll(debtProducts)) {
            if (!Sets.intersection((Set)this.getErpTuitionInfoType().getTuitionProductsSet(), debtProducts).isEmpty()) {
                throw new AcademicTreasuryDomainException("error.ERPTuitionInfo.event.define.some.of.the.products.of.type.but.not.all", new String[]{event.getPerson().getStudent().getNumber().toString(), event.getPerson().getStudent().getName(), this.getErpTuitionInfoType().getErpTuitionInfoProduct().getName()});
            }
            return false;
        }
        Registration registration = event.getRegistration();
        if (this.isForRegistration() && event.isForRegistrationTuition() && this.isAppliedForRegistration(registration, executionYear)) {
            return true;
        }
        if (this.isForStandalone() && event.isForStandaloneTuition()) {
            return true;
        }
        return this.isForExtracurricular() && event.isForExtracurricularTuition();
    }

    public LocalizedString getDescription() {
        if (this.isDefinedForDegreeType()) {
            LocalizedString result = new LocalizedString();
            for (Locale locale : TreasuryConstants.getAvailableLocales()) {
                result = result.with(locale, this.getDegreeType().getName().getContent(locale));
            }
            return result;
        }
        if (this.isDefinedForDegree()) {
            LocalizedString result = new LocalizedString();
            for (Locale locale : TreasuryConstants.getAvailableLocales()) {
                result = result.with(locale, String.format("[%s] %s", this.getDegree().getCode(), this.getDegree().getPresentationName()));
            }
            return result;
        }
        if (this.isDefinedForDegreeCurricularPlan()) {
            LocalizedString result = new LocalizedString();
            for (Locale locale : TreasuryConstants.getAvailableLocales()) {
                result = result.with(locale, String.format("[%s] %s - %s", this.getDegree().getCode(), this.getDegree().getPresentationName(), this.getDegreeCurricularPlan().getName()));
            }
            return result;
        }
        if (this.isForStandalone()) {
            return AcademicTreasuryConstants.academicTreasuryBundleI18N("label.ERPTuitionInfoTypeAcademicEntry.standalone.description", new String[0]);
        }
        if (this.isForExtracurricular()) {
            return AcademicTreasuryConstants.academicTreasuryBundleI18N("label.ERPTuitionInfoTypeAcademicEntry.extracurricular.description", new String[0]);
        }
        throw new RuntimeException("error");
    }

    public void delete() {
        this.setDomainRoot(null);
        this.setErpTuitionInfoType(null);
        this.setDegreeCurricularPlan(null);
        this.setDegree(null);
        this.setDegreeType(null);
        this.deleteDomainObject();
    }

    public static ERPTuitionInfoTypeAcademicEntry createForRegistrationTuition(ERPTuitionInfoType type, DegreeType degreeType) {
        return new ERPTuitionInfoTypeAcademicEntry(type, degreeType);
    }

    public static ERPTuitionInfoTypeAcademicEntry createForRegistrationTuition(ERPTuitionInfoType type, Degree degree) {
        return new ERPTuitionInfoTypeAcademicEntry(type, degree);
    }

    public static ERPTuitionInfoTypeAcademicEntry createForRegistrationTuition(ERPTuitionInfoType type, DegreeCurricularPlan degreeCurricularPlan) {
        return new ERPTuitionInfoTypeAcademicEntry(type, degreeCurricularPlan);
    }

    public static ERPTuitionInfoTypeAcademicEntry createForStandaloneTuition(ERPTuitionInfoType type) {
        return new ERPTuitionInfoTypeAcademicEntry(type, true, false);
    }

    public static ERPTuitionInfoTypeAcademicEntry createForExtracurricularTuition(ERPTuitionInfoType type) {
        return new ERPTuitionInfoTypeAcademicEntry(type, false, true);
    }
}

