/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.event;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IPaymentReferenceCode;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent$callable$delete;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEventType;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent_Base;
import org.fenixedu.academictreasury.domain.event.TreasuryEventDefaultMethods;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxEventTarget;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class AcademicTreasuryEvent
extends AcademicTreasuryEvent_Base
implements IAcademicTreasuryEvent,
IAcademicServiceRequestAndAcademicTaxTreasuryEvent {
    private static Logger logger;
    private static Set<Function<Person, Set<IAcademicTreasuryEvent>>> ACADEMIC_TREASURY_READERS;
    public static final Advice advice$delete;

    public AcademicTreasuryEvent() {
        this.setCustomAcademicDebt(false);
    }

    @Deprecated
    protected AcademicTreasuryEvent(ITreasuryServiceRequest iTreasuryServiceRequest) {
        this();
        this.initForTreasuryServiceRequest(iTreasuryServiceRequest.getPerson(), iTreasuryServiceRequest, ServiceRequestMapEntry.findProduct(iTreasuryServiceRequest));
    }

    protected AcademicTreasuryEvent(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Product product, Registration registration, ExecutionYear executionYear) {
        this();
        this.initForTuition(tuitionPaymentPlanGroup, product, registration, executionYear);
        this.checkRules();
    }

    protected AcademicTreasuryEvent(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        this();
        this.initForAcademicTax(academicTax, registration, executionYear);
        this.checkRules();
    }

    protected AcademicTreasuryEvent(FinantialEntity finantialEntity, Product product, IAcademicTreasuryTarget target) {
        this();
        this.initAcademicTreasuryEventTarget(finantialEntity, product, target);
        this.checkRules();
    }

    protected AcademicTreasuryEvent(Product product, Registration registration, ExecutionYear executionYear, int customAcademicDebtNumberOfUnits, int customAcademicDebtNumberOfPages, boolean customAcademicDebtUrgent, LocalDate customAcademicDebtEventDate, String academicProcessNumber) {
        this.initForCustomAcademicDebt(product, registration, executionYear, customAcademicDebtNumberOfUnits, customAcademicDebtNumberOfPages, customAcademicDebtUrgent, customAcademicDebtEventDate, academicProcessNumber);
        this.checkRules();
    }

    protected void init(FinantialEntity finantialEntity, Product product, LocalizedString name) {
        throw new RuntimeException("wrong call");
    }

    @Deprecated
    private void initForTreasuryServiceRequest(Person person, ITreasuryServiceRequest iTreasuryServiceRequest, Product product) {
        Degree degree;
        FinantialEntity finantialEntity;
        LocalDate eventDate;
        LocalDate localDate = eventDate = iTreasuryServiceRequest.getRequestDate() != null ? iTreasuryServiceRequest.getRequestDate().toLocalDate() : null;
        if (eventDate == null) {
            eventDate = new LocalDate();
        }
        if ((finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(degree = iTreasuryServiceRequest.getRegistration().getDegree(), eventDate)) == null && FinantialEntity.findAll().count() == 1L) {
            finantialEntity = (FinantialEntity)FinantialEntity.findAll().iterator().next();
        }
        super.init(finantialEntity, product, AcademicTreasuryEvent.nameForAcademicServiceRequest(product, iTreasuryServiceRequest));
        this.setPerson(person);
        this.setITreasuryServiceRequest(iTreasuryServiceRequest);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(this.fillPropertiesMap()));
        this.setDescription(this.descriptionForAcademicServiceRequest());
        this.checkRules();
    }

    public static LocalizedString nameForAcademicServiceRequest(Product product, ITreasuryServiceRequest iTreasuryServiceRequest) {
        LocalizedString result = new LocalizedString();
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String extString;
            StrSubstitutor str;
            Object text;
            ExecutionYear executionYear = iTreasuryServiceRequest.getExecutionYear();
            if (executionYear != null) {
                text = String.format("%s [%s - %s] (%s)", product.getName().getContent(locale), iTreasuryServiceRequest.getRegistration().getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName(), iTreasuryServiceRequest.getServiceRequestNumberYear());
                if (!StringUtils.isEmpty((String)serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat())) {
                    str = new StrSubstitutor(iTreasuryServiceRequest.getPropertyValuesMap());
                    extString = str.replace(serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat());
                    text = (String)text + " " + extString;
                }
                result = result.with(locale, (String)text);
                continue;
            }
            text = String.format("%s [%s] (%s)", product.getName().getContent(locale), iTreasuryServiceRequest.getRegistration().getDegree().getPresentationName(null, locale), iTreasuryServiceRequest.getServiceRequestNumberYear());
            if (!StringUtils.isEmpty((String)serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat())) {
                str = new StrSubstitutor(iTreasuryServiceRequest.getPropertyValuesMap());
                extString = str.replace(serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat());
                text = (String)text + " " + extString;
            }
            result = result.with(locale, (String)text);
        }
        return result;
    }

    private void initForTuition(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Product product, Registration registration, ExecutionYear executionYear) {
        Degree degree;
        FinantialEntity finantialEntity;
        RegistrationDataByExecutionYear data = this.findRegistrationDataByExecutionYear(registration, executionYear);
        LocalDate eventDate = null;
        eventDate = data != null && data.getEnrolmentDate() != null ? data.getEnrolmentDate() : executionYear.getBeginLocalDate();
        if (eventDate == null) {
            eventDate = new LocalDate();
        }
        if ((finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(degree = registration.getDegree(), eventDate)) == null && FinantialEntity.findAll().count() == 1L) {
            finantialEntity = (FinantialEntity)FinantialEntity.findAll().iterator().next();
        }
        super.init(finantialEntity, product, this.nameForTuition(product, registration, executionYear));
        this.setPerson(registration.getPerson());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup);
        this.setRegistration(registration);
        this.setExecutionYear(executionYear);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(this.fillPropertiesMap()));
        this.checkRules();
    }

    private RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(rd -> rd.getExecutionYear() == executionYear).findAny().orElse(null);
    }

    private LocalizedString nameForTuition(Product product, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String name = String.format("%s [%s - %s]", product.getName().getContent(locale), registration.getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName());
            result = result.with(locale, name);
        }
        return result;
    }

    private void initForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        Degree degree;
        FinantialEntity finantialEntity;
        RegistrationDataByExecutionYear data = this.findRegistrationDataByExecutionYear(registration, executionYear);
        LocalDate eventDate = null;
        eventDate = data != null && data.getEnrolmentDate() != null ? data.getEnrolmentDate() : executionYear.getBeginLocalDate();
        if (eventDate == null) {
            eventDate = new LocalDate();
        }
        if ((finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(degree = registration.getDegree(), eventDate)) == null && FinantialEntity.findAll().count() == 1L) {
            finantialEntity = (FinantialEntity)FinantialEntity.findAll().iterator().next();
        }
        super.init(finantialEntity, academicTax.getProduct(), AcademicTreasuryEvent.nameForAcademicTax(academicTax, registration, executionYear));
        this.setAcademicTax(academicTax);
        this.setPerson(registration.getPerson());
        this.setRegistration(registration);
        this.setExecutionYear(executionYear);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(this.fillPropertiesMap()));
        this.checkRules();
    }

    public static LocalizedString nameForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        if (AcademicTreasurySettings.getInstance().getUseCustomAcademicDebtFormat()) {
            return AcademicTreasuryEvent.buildCustomNameForAcademicTax(academicTax, registration, executionYear);
        }
        return AcademicTreasuryEvent.defaultNameForAcademicTax(academicTax, registration, executionYear);
    }

    private static LocalizedString buildCustomNameForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        if (!academicTax.isAppliedOnRegistration()) {
            throw new RuntimeException("error.AcademicTreasuryEvent.buildCustomNameForAcademicTax.isAppliedOnRegistration.not.supported");
        }
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            String degreePresentationName = registration.getDegree().getPresentationName(executionYear, locale);
            String degreeName = registration.getDegree().getNameI18N(executionYear).getContent(locale);
            Product product = academicTax.getProduct();
            LocalizedString productName = product.getName();
            valueMap.put("productName", StringUtils.isNotEmpty((String)productName.getContent(locale)) ? productName.getContent(locale) : productName.getContent());
            valueMap.put("degreeCode", registration.getDegree().getCode());
            valueMap.put("degreePresentationName", degreePresentationName);
            valueMap.put("degreeName", degreeName);
            valueMap.put("executionYearName", executionYear.getQualifiedName());
            LocalizedString formatToUse = AcademicTreasurySettings.getInstance().getCustomAcademicDebtFormat();
            String name = StrSubstitutor.replace((Object)formatToUse.getContent(locale), valueMap);
            result = result.with(locale, name);
        }
        return result;
    }

    private static LocalizedString defaultNameForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String name = null;
            name = academicTax.isAppliedOnRegistration() ? String.format("%s [%s - %s]", academicTax.getProduct().getName().getContent(locale), registration.getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName()) : String.format("%s [%s]", academicTax.getProduct().getName().getContent(locale), executionYear.getQualifiedName());
            result = result.with(locale, name);
        }
        return result;
    }

    private void initAcademicTreasuryEventTarget(FinantialEntity finantialEntity, Product product, IAcademicTreasuryTarget target) {
        if (target == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.target.required", new String[0]);
        }
        if (finantialEntity == null && target.getAcademicTreasuryTargetDegree() != null) {
            LocalDate eventDate = target.getAcademicTreasuryTargetEventDate();
            if (eventDate == null) {
                eventDate = new LocalDate();
            }
            finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(target.getAcademicTreasuryTargetDegree(), eventDate);
        }
        if (finantialEntity == null && FinantialEntity.findAll().count() == 1L) {
            finantialEntity = (FinantialEntity)FinantialEntity.findAll().iterator().next();
        }
        super.init(finantialEntity, product, target.getAcademicTreasuryTargetDescription());
        this.setPerson(target.getAcademicTreasuryTargetPerson());
        this.setTreasuryEventTarget((AbstractDomainObject)target);
    }

    private void initForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear, int customAcademicDebtNumberOfUnits, int customAcademicDebtNumberOfPages, boolean customAcademicDebtUrgent, LocalDate customAcademicDebtEventDate, String academicProcessNumber) {
        FinantialEntity finantialEntity;
        LocalDate eventDate;
        LocalizedString nameForCustomAcademicDebt = AcademicTreasuryEvent.nameForCustomAcademicDebt(product, registration, executionYear);
        if (StringUtils.isNotEmpty((String)academicProcessNumber)) {
            nameForCustomAcademicDebt = nameForCustomAcademicDebt.append(" [" + academicProcessNumber + "]");
        }
        if ((eventDate = customAcademicDebtEventDate) == null) {
            eventDate = executionYear.getBeginLocalDate();
        }
        if (eventDate == null) {
            eventDate = new LocalDate();
        }
        if ((finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(registration.getDegree(), eventDate)) == null && FinantialEntity.findAll().count() == 1L) {
            finantialEntity = (FinantialEntity)FinantialEntity.findAll().iterator().next();
        }
        super.init(finantialEntity, product, nameForCustomAcademicDebt);
        this.setPerson(registration.getPerson());
        this.setCustomAcademicDebt(true);
        this.setRegistration(registration);
        this.setExecutionYear(executionYear);
        this.setCustomAcademicDebtNumberOfUnits(customAcademicDebtNumberOfUnits);
        this.setCustomAcademicDebtNumberOfPages(customAcademicDebtNumberOfPages);
        this.setCustomAcademicDebtUrgent(customAcademicDebtUrgent);
        this.setCustomAcademicDebtEventDate(customAcademicDebtEventDate);
        super.setAcademicProcessNumber(academicProcessNumber);
    }

    public static LocalizedString nameForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear) {
        if (AcademicTreasurySettings.getInstance().getUseCustomAcademicDebtFormat()) {
            return AcademicTreasuryEvent.buildCustomNameForCustomAcademicDebt(product, registration, executionYear);
        }
        return AcademicTreasuryEvent.defaultNameForCustomAcademicDebt(product, registration, executionYear);
    }

    private static LocalizedString buildCustomNameForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            String degreePresentationName = registration.getDegree().getPresentationName(executionYear, locale);
            String degreeName = registration.getDegree().getNameI18N(executionYear).getContent(locale);
            LocalizedString productName = product.getName();
            valueMap.put("productName", StringUtils.isNotEmpty((String)productName.getContent(locale)) ? productName.getContent(locale) : productName.getContent());
            valueMap.put("degreeCode", registration.getDegree().getCode());
            valueMap.put("degreePresentationName", degreePresentationName);
            valueMap.put("degreeName", degreeName);
            valueMap.put("executionYearName", executionYear.getQualifiedName());
            LocalizedString formatToUse = AcademicTreasurySettings.getInstance().getCustomAcademicDebtFormat();
            String name = StrSubstitutor.replace((Object)formatToUse.getContent(locale), valueMap);
            result = result.with(locale, name);
        }
        return result;
    }

    private static LocalizedString defaultNameForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String name = String.format("%s [%s - %s]", product.getName().getContent(), registration.getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName());
            result = result.with(locale, name);
        }
        return result;
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getPerson() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.person.required", new String[0]);
        }
        if (!(this.isForAcademicServiceRequest() || this.isTuitionEvent() || this.isForAcademicTax() || this.isForImprovementTax() || this.isForTreasuryEventTarget() || this.isCustomAcademicDebt())) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.not.for.service.request.nor.tuition.nor.academic.tax", new String[0]);
        }
        if (!(this.isForAcademicServiceRequest() ^ this.isForRegistrationTuition() ^ this.isForStandaloneTuition() ^ this.isForExtracurricularTuition() ^ this.isForImprovementTax() ^ this.isForAcademicTax() ^ this.isForTreasuryEventTarget() ^ this.isCustomAcademicDebt())) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.for.one.type", new String[0]);
        }
        if ((this.isTuitionEvent() || this.isForImprovementTax()) && this.getRegistration() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.registration.required", new String[0]);
        }
        if ((this.isTuitionEvent() || this.isForImprovementTax()) && this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.executionYear.required", new String[0]);
        }
        if (this.isForAcademicServiceRequest() && AcademicTreasuryEvent.find(this.getITreasuryServiceRequest()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.event.for.academicServiceRequest.duplicate", new String[0]);
        }
        if (this.isForAcademicServiceRequest()) {
            this.getITreasuryServiceRequest();
        }
        if (this.isForRegistrationTuition() && AcademicTreasuryEvent.findForRegistrationTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.registration.tuition.duplicate", new String[0]);
        }
        if (this.isForStandaloneTuition() && AcademicTreasuryEvent.findForStandaloneTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.standalone.tuition.duplicate", new String[0]);
        }
        if (this.isForExtracurricularTuition() && AcademicTreasuryEvent.findForExtracurricularTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.extracurricular.tuition.duplicate", new String[0]);
        }
        if (this.isForImprovementTax() && AcademicTreasuryEvent.findForImprovementTuition(this.getRegistration(), this.getExecutionYear()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.improvement.tuition.duplicate", new String[0]);
        }
        if (this.isForAcademicTax() && this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.execution.year.required", new String[0]);
        }
        if (this.isForAcademicTax() && this.getRegistration() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.registration.required", new String[0]);
        }
        if (this.isForAcademicTax() && AcademicTreasuryEvent.findForAcademicTax(this.getRegistration(), this.getExecutionYear(), this.getAcademicTax()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.academic.tax.duplicate", new String[0]);
        }
        if (this.isForCustomAcademicDebt() && this.getRegistration() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.custom.academic.debt.registration.required", new String[0]);
        }
        if (this.isForCustomAcademicDebt() && this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.custom.academic.debt.execution.year.required", new String[0]);
        }
        if (this.isForCustomAcademicDebt() && this.getCustomAcademicDebtEventDate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.for.custom.academic.debt.event.date.required", new String[0]);
        }
    }

    public boolean isCustomAcademicDebt() {
        return this.getCustomAcademicDebt();
    }

    public boolean isForCustomAcademicDebt() {
        return this.isCustomAcademicDebt();
    }

    public boolean isForTreasuryEventTarget() {
        return this.getTreasuryEventTarget() != null;
    }

    public boolean isForAcademicServiceRequest() {
        return this.getITreasuryServiceRequest() != null;
    }

    public boolean isForRegistrationTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForRegistration();
    }

    public boolean isForStandaloneTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForStandalone();
    }

    public boolean isLegacy() {
        return false;
    }

    public boolean isForLegacy() {
        return this.isLegacy();
    }

    public boolean isCustomAcademicDebtUrgent() {
        return this.getCustomAcademicDebtUrgent();
    }

    public boolean isForExtracurricularTuition() {
        return this.getTuitionPaymentPlanGroup() != null && this.getTuitionPaymentPlanGroup().isForExtracurricular();
    }

    public boolean isForImprovementTax() {
        return this.getAcademicTax() != null && this.getAcademicTax() == AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
    }

    public boolean isForAcademicTax() {
        return this.getAcademicTax() != null && !this.isImprovementTax();
    }

    public static int numberOfUnits(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryConstants.getNumberOfUnits(iTreasuryServiceRequest);
    }

    public int getNumberOfUnits() {
        if (this.isForAcademicServiceRequest()) {
            return AcademicTreasuryEvent.numberOfUnits(this.getITreasuryServiceRequest());
        }
        if (this.isForAcademicTax()) {
            return 0;
        }
        if (this.isForImprovementTax()) {
            return 0;
        }
        if (this.isTuitionEvent()) {
            return 0;
        }
        if (this.isForCustomAcademicDebt()) {
            return this.getCustomAcademicDebtNumberOfUnits();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.numberOfUnits.not.applied", new String[0]);
    }

    public static int numberOfPages(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return iTreasuryServiceRequest.hasNumberOfPages() ? iTreasuryServiceRequest.getNumberOfPages() : 0;
    }

    public int getNumberOfPages() {
        if (this.isForAcademicServiceRequest()) {
            return AcademicTreasuryEvent.numberOfPages(this.getITreasuryServiceRequest());
        }
        if (this.isForAcademicTax()) {
            return 0;
        }
        if (this.isForImprovementTax()) {
            return 0;
        }
        if (this.isTuitionEvent()) {
            return 0;
        }
        if (this.isForCustomAcademicDebt()) {
            return this.getCustomAcademicDebtNumberOfPages();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.numberOfPages.not.applied", new String[0]);
    }

    public static boolean urgentRequest(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return iTreasuryServiceRequest.isUrgent();
    }

    public boolean isUrgentRequest() {
        if (this.isForAcademicServiceRequest()) {
            return AcademicTreasuryEvent.urgentRequest(this.getITreasuryServiceRequest());
        }
        if (this.isForAcademicTax()) {
            return false;
        }
        if (this.isForImprovementTax()) {
            return false;
        }
        if (this.isTuitionEvent()) {
            return false;
        }
        if (this.isForCustomAcademicDebt()) {
            return this.isCustomAcademicDebtUrgent();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.urgentRequest.not.applied", new String[0]);
    }

    public LocalDate getRequestDate() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().getRequestDate().toLocalDate();
        }
        if (this.isForAcademicTax() && !this.isForImprovementTax()) {
            RegistrationDataByExecutionYear registrationDataByExecutionYear = this.findRegistrationDataByExecutionYear(this.getRegistration(), this.getExecutionYear());
            return registrationDataByExecutionYear != null ? registrationDataByExecutionYear.getEnrolmentDate() : new LocalDate();
        }
        if (this.isForImprovementTax()) {
            RegistrationDataByExecutionYear registrationDataByExecutionYear = this.findRegistrationDataByExecutionYear(this.getRegistration(), this.getExecutionYear());
            return registrationDataByExecutionYear != null ? registrationDataByExecutionYear.getEnrolmentDate() : new LocalDate();
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.requestDate.not.applied", new String[0]);
    }

    public static Locale language(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return iTreasuryServiceRequest.getLanguage();
    }

    public Locale getLanguage() {
        if (this.isForAcademicServiceRequest()) {
            return AcademicTreasuryEvent.language(this.getITreasuryServiceRequest());
        }
        if (this.isForAcademicTax()) {
            return null;
        }
        if (this.isForImprovementTax()) {
            return null;
        }
        if (this.isTuitionEvent()) {
            return null;
        }
        if (this.isForCustomAcademicDebt()) {
            return null;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.language.not.applied", new String[0]);
    }

    public boolean isChargedWithDebitEntry(TuitionInstallmentTariff tariff) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getProduct().equals((Object)tariff.getProduct())).count() > 0L;
    }

    public boolean isCharged() {
        return TreasuryEventDefaultMethods.isCharged((TreasuryEvent)this);
    }

    public boolean isChargedWithDebitEntry(Enrolment enrolment) {
        if (!this.isForStandaloneTuition() && !this.isForExtracurricularTuition()) {
            throw new RuntimeException("wrong call");
        }
        return this.findActiveEnrolmentDebitEntry(enrolment).isPresent();
    }

    public boolean isChargedWithDebitEntry(EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        return this.findActiveEnrolmentEvaluationDebitEntry(enrolmentEvaluation).isPresent();
    }

    public LocalDate getTreasuryEventDate() {
        if (this.isForAcademicServiceRequest()) {
            return this.getITreasuryServiceRequest().getRequestDate().toLocalDate();
        }
        if (this.isForImprovementTax() || this.isForAcademicTax() || this.isForRegistrationTuition() || this.isForExtracurricularTuition() || this.isForStandaloneTuition()) {
            RegistrationDataByExecutionYear data = this.findRegistrationDataByExecutionYear(this.getRegistration(), this.getExecutionYear());
            if (data != null && data.getEnrolmentDate() != null) {
                return data.getEnrolmentDate();
            }
            return this.getExecutionYear().getBeginLocalDate();
        }
        if (this.isForTreasuryEventTarget()) {
            return ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).getAcademicTreasuryTargetEventDate();
        }
        if (this.isForCustomAcademicDebt()) {
            return this.getCustomAcademicDebtEventDate();
        }
        throw new RuntimeException("dont know how to handle this!");
    }

    public Optional<? extends DebitEntry> findActiveAcademicServiceRequestDebitEntry() {
        return DebitEntry.findActive((TreasuryEvent)this).findFirst();
    }

    public Optional<? extends DebitEntry> findActiveEnrolmentDebitEntry(Enrolment enrolment) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getCurricularCourse() == enrolment.getCurricularCourse() && d.getExecutionSemester() == enrolment.getExecutionPeriod()).findFirst();
    }

    public Optional<? extends DebitEntry> findActiveEnrolmentEvaluationDebitEntry(EnrolmentEvaluation enrolmentEvaluation) {
        return DebitEntry.findActive((TreasuryEvent)this).filter(d -> d.getCurricularCourse() == enrolmentEvaluation.getEnrolment().getCurricularCourse() && d.getExecutionSemester() == enrolmentEvaluation.getExecutionPeriod() && d.getEvaluationSeason() == enrolmentEvaluation.getEvaluationSeason()).findFirst();
    }

    public void associateEnrolment(DebitEntry debitEntry, Enrolment enrolment) {
        if (!this.isForStandaloneTuition() && !this.isForExtracurricularTuition()) {
            throw new RuntimeException("wrong call");
        }
        if (enrolment == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.enrolment.cannot.be.null", new String[0]);
        }
        if (enrolment.isOptional()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.optional.enrolments.not.supported", new String[0]);
        }
        debitEntry.setCurricularCourse(enrolment.getCurricularCourse());
        debitEntry.setExecutionSemester(enrolment.getExecutionInterval());
    }

    public void associateEnrolmentEvaluation(DebitEntry debitEntry, EnrolmentEvaluation enrolmentEvaluation) {
        if (!this.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        if (enrolmentEvaluation == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.enrolmentEvaluation.cannot.be.null", new String[0]);
        }
        debitEntry.setCurricularCourse(enrolmentEvaluation.getEnrolment().getCurricularCourse());
        debitEntry.setExecutionSemester(enrolmentEvaluation.getEnrolment().getExecutionInterval());
        if (enrolmentEvaluation.getExecutionInterval() != null) {
            debitEntry.setExecutionSemester(enrolmentEvaluation.getExecutionInterval());
        }
        debitEntry.setEvaluationSeason(enrolmentEvaluation.getEvaluationSeason());
    }

    public Set<Product> getPossibleProductsToExempt() {
        if (this.isForRegistrationTuition()) {
            return TuitionPaymentPlan.find(this.getTuitionPaymentPlanGroup(), this.getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getDegreeCurricularPlan(), this.getExecutionYear()).map(t -> t.getTuitionInstallmentTariffsSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream().map(i -> i.getProduct()).collect(Collectors.toSet());
        }
        return Sets.newHashSet((Object[])new Product[]{this.getProduct()});
    }

    private LocalizedString descriptionForAcademicServiceRequest() {
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(this.getITreasuryServiceRequest());
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String text = this.getProduct().getName().getContent(locale) + ": " + this.getITreasuryServiceRequest().getServiceRequestNumberYear();
            if (!StringUtils.isEmpty((String)serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat())) {
                StrSubstitutor str = new StrSubstitutor(this.getITreasuryServiceRequest().getPropertyValuesMap());
                String extString = str.replace(serviceRequestMapEntry.getDebitEntryDescriptionExtensionFormat());
                text = text + " " + extString;
            }
            result = result.with(locale, text);
        }
        return result;
    }

    public String getDegreeCode() {
        if (this.getDegree() == null) {
            return null;
        }
        return this.getDegree().getCode();
    }

    public String getDegreeName() {
        if (this.getDegree() == null) {
            return null;
        }
        if (this.getExecutionYear() != null) {
            return this.getDegree().getPresentationName(this.getExecutionYear());
        }
        return this.getDegree().getPresentationName();
    }

    public Degree getDegree() {
        Degree degree = this.degree();
        if (degree != null) {
            return degree;
        }
        return super.getDegree();
    }

    public String getExecutionYearName() {
        if (super.getExecutionYear() != null) {
            return super.getExecutionYear().getQualifiedName();
        }
        if (this.isForTreasuryEventTarget() && ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).getAcademicTreasuryTargetExecutionYear() != null) {
            return ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).getAcademicTreasuryTargetExecutionYear().getQualifiedName();
        }
        return null;
    }

    private Degree degree() {
        Degree degree = null;
        if (this.isForRegistrationTuition() && this.getRegistration() != null) {
            degree = this.getRegistration().getDegree();
        } else if (this.isForStandaloneTuition() || this.isForExtracurricularTuition()) {
            if (this.getRegistration() != null) {
                degree = this.getRegistration().getDegree();
            }
        } else if (this.isForImprovementTax()) {
            if (this.getRegistration() != null) {
                degree = this.getRegistration().getDegree();
            }
        } else if (this.isForAcademicTax() && this.getRegistration() != null) {
            degree = this.getRegistration().getDegree();
        } else if (this.isForAcademicServiceRequest() && this.getRegistration() != null) {
            degree = this.getRegistration().getDegree();
        } else if (this.isForCustomAcademicDebt() && this.getRegistration() != null) {
            degree = this.getRegistration().getDegree();
        } else {
            if (this.isForTreasuryEventTarget() && ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).getAcademicTreasuryTargetDegree() != null) {
                return ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).getAcademicTreasuryTargetDegree();
            }
            if (this.isForAcademicServiceRequest() && this.getITreasuryServiceRequest() != null && this.getITreasuryServiceRequest().getRegistration() != null) {
                degree = this.getITreasuryServiceRequest().getRegistration().getDegree();
            }
        }
        return degree;
    }

    public AcademicTreasuryEventType getTreasuryEventTypeCode() {
        if (this.isForAcademicServiceRequest()) {
            return AcademicTreasuryEventType.ACADEMIC_SERVICE_REQUEST;
        }
        if (this.isForAcademicTax()) {
            return AcademicTreasuryEventType.ACADEMIC_TAX;
        }
        if (this.isForExtracurricularTuition()) {
            return AcademicTreasuryEventType.EXTRACURRICULAR_TUITION;
        }
        if (this.isForImprovementTax()) {
            return AcademicTreasuryEventType.IMPROVEMENT_TAX;
        }
        if (this.isForRegistrationTuition()) {
            return AcademicTreasuryEventType.REGISTRATION_TUITION;
        }
        if (this.isForStandaloneTuition()) {
            return AcademicTreasuryEventType.STANDALONE_TUITION;
        }
        if (this.isForTreasuryEventTarget()) {
            return AcademicTreasuryEventType.TREASURY_EVENT_TARGET;
        }
        if (this.isLegacy()) {
            return AcademicTreasuryEventType.LEGACY;
        }
        if (this.isCustomAcademicDebt()) {
            return AcademicTreasuryEventType.CUSTOM_ACADEMIC_DEBT;
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unkwnown.type", new String[0]);
    }

    public void mergeToTargetPerson(Person targetPerson) {
        super.setPerson(targetPerson);
        if (this.isForTreasuryEventTarget() && this.getTreasuryEventTarget() != null && this.getTreasuryEventTarget() instanceof ReservationTaxEventTarget) {
            ((ReservationTaxEventTarget)this.getTreasuryEventTarget()).mergeToTargetPerson(targetPerson);
        }
    }

    public void mergeDebitEntriesAndExemptions(AcademicTreasuryEvent event) {
        if (this.getTreasuryEventTypeCode() != event.getTreasuryEventTypeCode()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.for.different.types", new String[0]);
        }
        if (this.isForAcademicServiceRequest()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
        }
        if (this.isForAcademicTax()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
            if (this.getAcademicTax() != event.getAcademicTax()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.academic.tax", new String[0]);
            }
        } else if (this.isForExtracurricularTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForImprovementTax()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForRegistrationTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else if (this.isForStandaloneTuition()) {
            if (this.getExecutionYear() != event.getExecutionYear()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.different.execution.year", new String[0]);
            }
        } else {
            if (this.isForTreasuryEventTarget()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
            }
            if (this.isForLegacy()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
            }
            if (this.isCustomAcademicDebt()) {
                throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.cannot.merge.not.supported", new String[0]);
            }
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unkwnown.type", new String[0]);
        }
        for (DebitEntry debitEntry : Sets.newHashSet((Iterable)event.getDebitEntriesSet())) {
            debitEntry.setTreasuryEvent((TreasuryEvent)this);
        }
    }

    public void copyDebitEntryInformation(DebitEntry sourceDebitEntry, DebitEntry copyDebitEntry) {
        copyDebitEntry.setCurricularCourse(sourceDebitEntry.getCurricularCourse());
        copyDebitEntry.setEvaluationSeason(sourceDebitEntry.getEvaluationSeason());
        copyDebitEntry.setExecutionSemester(sourceDebitEntry.getExecutionSemester());
    }

    public boolean isDeletable() {
        return this.getDebitEntriesSet().isEmpty() && this.getTreasuryExemptionsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicTreasuryEvent$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicTreasuryEvent this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.AcademicTreasuryEvent.cannot.delete", new String[0]);
        }
        this_.setPerson(null);
        this_.setITreasuryServiceRequest(null);
        this_.setTuitionPaymentPlanGroup(null);
        this_.setRegistration(null);
        this_.setAcademicTax(null);
        this_.setRegistration(null);
        this_.setExecutionYear(null);
        this_.setAcademicTax(null);
        this_.setTreasuryEventTarget(null);
        super.delete();
    }

    public Optional<Tariff> findMatchTariff(FinantialEntity finantialEntity, Product product, LocalDate when) {
        if (this.getDegree() != null) {
            return Optional.ofNullable(AcademicTariff.findMatch(finantialEntity, product, this.getDegree(), when.toDateTimeAtStartOfDay()));
        }
        return Optional.ofNullable(AcademicTariff.findMatch(finantialEntity, product, when.toDateTimeAtStartOfDay()));
    }

    public boolean isEventAccountedAsTuition() {
        if (this.isForTreasuryEventTarget()) {
            return ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).isEventAccountedAsTuition();
        }
        return this.isForRegistrationTuition() || this.isForStandaloneTuition() || this.isForExtracurricularTuition();
    }

    public boolean isEventDiscountInTuitionFee() {
        if (this.isForTreasuryEventTarget()) {
            return ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).isEventDiscountInTuitionFee();
        }
        return false;
    }

    public boolean isEventDiscountInTuitionFeeWithTreasuryExemption() {
        return true;
    }

    public TreasuryExemptionType getTreasuryExemptionToApplyInEventDiscountInTuitionFee() {
        if (this.isForTreasuryEventTarget() && this.getTreasuryEventTarget() instanceof ReservationTaxEventTarget) {
            return ((ReservationTaxEventTarget)this.getTreasuryEventTarget()).getReservationTax().getTreasuryExemptionType();
        }
        return null;
    }

    public static Stream<? extends AcademicTreasuryEvent> findAll() {
        return TreasuryEvent.findAll().filter(e -> e instanceof AcademicTreasuryEvent).map(AcademicTreasuryEvent.class::cast);
    }

    public static Stream<? extends AcademicTreasuryEvent> find(Person person) {
        return person.getAcademicTreasuryEventSet().stream();
    }

    public static Stream<? extends AcademicTreasuryEvent> find(ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findAll().filter(e -> e.getExecutionYear() == executionYear);
    }

    public static Stream<? extends AcademicTreasuryEvent> find(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration.getPerson()).filter(e -> e.getRegistration() == registration).filter(l -> l.getExecutionYear() == executionYear);
    }

    public static Stream<? extends AcademicTreasuryEvent> find(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (iTreasuryServiceRequest == null) {
            throw new RuntimeException("wrong call");
        }
        return AcademicTreasuryEvent.findAll().filter(e -> e.getITreasuryServiceRequest() != null && e.getITreasuryServiceRequest().getExternalId().equals(iTreasuryServiceRequest.getExternalId()));
    }

    public static Optional<? extends AcademicTreasuryEvent> findUnique(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.find(iTreasuryServiceRequest).findFirst();
    }

    @Deprecated
    public static AcademicTreasuryEvent createForAcademicServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return new AcademicTreasuryEvent(iTreasuryServiceRequest);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForRegistrationTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForRegistrationTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForRegistrationTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForRegistrationTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForRegistrationTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForStandaloneTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForStandaloneTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForStandaloneTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForStandaloneTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForStandaloneTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForExtracurricularTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForExtracurricularTuition());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForExtracurricularTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForExtracurricularTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForExtracurricularTuition(Product product, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), product, registration, executionYear);
    }

    protected static Stream<? extends AcademicTreasuryEvent> findForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration, executionYear).filter(e -> e.isForImprovementTax());
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findForImprovementTuition(registration, executionYear).findFirst();
    }

    public static AcademicTreasuryEvent createForImprovementTuition(Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(AcademicTreasurySettings.getInstance().getImprovementAcademicTax(), registration, executionYear);
    }

    public static Stream<? extends AcademicTreasuryEvent> findAllForAcademicTax(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (AcademicTax academicTax : AcademicTax.findAll().collect(Collectors.toSet())) {
            result.addAll(AcademicTreasuryEvent.findForAcademicTax(registration, executionYear, academicTax).collect(Collectors.toSet()));
        }
        return result.stream();
    }

    public static Stream<? extends AcademicTreasuryEvent> findForAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return AcademicTreasuryEvent.find(registration.getPerson()).filter(e -> e.isForAcademicTax() && e.getAcademicTax() == academicTax && e.getExecutionYear() == executionYear && (!e.getAcademicTax().isAppliedOnRegistration() && e.getPerson() == registration.getPerson() || e.getRegistration() == registration));
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return AcademicTreasuryEvent.findForAcademicTax(registration, executionYear, academicTax).findFirst();
    }

    public static Optional<? extends AcademicTreasuryEvent> findUniqueForTarget(Person person, IAcademicTreasuryTarget target) {
        return AcademicTreasuryEvent.find(person).filter(a -> a.getTreasuryEventTarget() == target).findFirst();
    }

    public static Stream<? extends AcademicTreasuryEvent> findByDescription(Person person, String description, boolean trimmed) {
        return AcademicTreasuryEvent.find(person).filter(t -> !trimmed && t.getDescription().getContent().equals(description) || trimmed && t.getDescription().getContent().trim().equals(description));
    }

    public static AcademicTreasuryEvent createForAcademicTax(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        return new AcademicTreasuryEvent(academicTax, registration, executionYear);
    }

    public static AcademicTreasuryEvent createForAcademicTreasuryEventTarget(FinantialEntity finantialEntity, Product product, IAcademicTreasuryTarget target) {
        return new AcademicTreasuryEvent(finantialEntity, product, target);
    }

    public static AcademicTreasuryEvent createForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear, int customAcademicDebtNumberOfUnits, int customAcademicDebtNumberOfPages, boolean customAcademicDebtUrgent, LocalDate customAcademicDebtEventDate, String academicProcessNumber) {
        return new AcademicTreasuryEvent(product, registration, executionYear, customAcademicDebtNumberOfUnits, customAcademicDebtNumberOfPages, customAcademicDebtUrgent, customAcademicDebtEventDate, academicProcessNumber);
    }

    public static Stream<? extends AcademicTreasuryEvent> findForCustomAcademicDebt(Product product, Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.find(registration.getPerson()).filter(e -> e.getExecutionYear() == executionYear).filter(e -> e.isCustomAcademicDebt()).filter(e -> e.getRegistration() == registration).filter(e -> e.getProduct() == product);
    }

    private Map<String, String> fillPropertiesMap() {
        HashMap propertiesMap = Maps.newHashMap();
        if (this.isForAcademicServiceRequest()) {
            propertiesMap.put(AcademicTreasuryEventKeys.ACADEMIC_SERVICE_REQUEST_NAME.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getServiceRequestType().getName().getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.ACADEMIC_SERVICE_REQUEST_NUMBER_YEAR.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getServiceRequestNumberYear());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getRegistration().getDegree().getPresentationName(this.getITreasuryServiceRequest().getExecutionYear()));
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getRegistration().getDegree().getCode());
            if (this.getITreasuryServiceRequest().hasExecutionYear()) {
                propertiesMap.put(AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getExecutionYear().getQualifiedName());
            }
            propertiesMap.put(AcademicTreasuryEventKeys.DETAILED.getDescriptionI18N().getContent(), this.booleanLabel(this.getITreasuryServiceRequest().isDetailed()).getContent());
            propertiesMap.put(AcademicTreasuryEventKeys.URGENT.getDescriptionI18N().getContent(), this.booleanLabel(this.getITreasuryServiceRequest().isUrgent()).getContent());
            if (this.getITreasuryServiceRequest().hasLanguage()) {
                propertiesMap.put(AcademicTreasuryEventKeys.LANGUAGE.getDescriptionI18N().getContent(), this.getITreasuryServiceRequest().getLanguage().getLanguage());
            }
        } else if (this.isForRegistrationTuition() || this.isForStandaloneTuition() || this.isForExtracurricularTuition()) {
            propertiesMap.put(AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), this.getExecutionYear().getQualifiedName());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), this.getRegistration().getDegree().getPresentationName(this.getExecutionYear()));
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), this.getRegistration().getDegreeCurricularPlanName());
            propertiesMap.put(AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), this.getRegistration().getDegree().getCode());
        }
        return propertiesMap;
    }

    private LocalizedString booleanLabel(boolean detailed) {
        return AcademicTreasuryConstants.academicTreasuryBundleI18N(detailed ? "label.true" : "label.false", new String[0]);
    }

    public static BigDecimal getEnrolledEctsUnits(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Registration registration, ExecutionYear executionYear) {
        if (tuitionPaymentPlanGroup.isForRegistration()) {
            return TuitionServices.normalEnrolmentsWithoutAnnuled(registration, executionYear).stream().map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        }
        if (tuitionPaymentPlanGroup.isForStandalone()) {
            return TuitionServices.standaloneEnrolmentsWithoutAnnuled(registration, executionYear).stream().map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        }
        if (tuitionPaymentPlanGroup.isForExtracurricular()) {
            return TuitionServices.extracurricularEnrolmentsWithoutAnnuled(registration, executionYear).stream().map(e -> new BigDecimal(e.getEctsCredits())).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unknown.tuition.group", new String[0]);
    }

    public BigDecimal getEnrolledEctsUnits() {
        return AcademicTreasuryEvent.getEnrolledEctsUnits(this.getTuitionPaymentPlanGroup(), this.getRegistration(), this.getExecutionYear());
    }

    public static BigDecimal getEnrolledCoursesCount(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Registration registration, ExecutionYear executionYear) {
        if (tuitionPaymentPlanGroup.isForRegistration()) {
            return new BigDecimal(TuitionServices.normalEnrolmentsWithoutAnnuled(registration, executionYear).size());
        }
        if (tuitionPaymentPlanGroup.isForStandalone()) {
            return new BigDecimal(TuitionServices.standaloneEnrolmentsWithoutAnnuled(registration, executionYear).size());
        }
        if (tuitionPaymentPlanGroup.isForExtracurricular()) {
            return new BigDecimal(TuitionServices.extracurricularEnrolmentsWithoutAnnuled(registration, executionYear).size());
        }
        throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.unknown.tuition.group", new String[0]);
    }

    public BigDecimal getEnrolledCoursesCount() {
        return AcademicTreasuryEvent.getEnrolledCoursesCount(this.getTuitionPaymentPlanGroup(), this.getRegistration(), this.getExecutionYear());
    }

    public void updatePricingFields(BigDecimal baseAmount, BigDecimal amountForAdditionalUnits, BigDecimal amountForPages, BigDecimal maximumAmount, BigDecimal amountForLanguageTranslationRate, BigDecimal amountForUrgencyRate) {
        super.setBaseAmount(baseAmount);
        super.setAmountForAdditionalUnits(amountForAdditionalUnits);
        super.setAmountForPages(amountForPages);
        super.setMaximumAmount(maximumAmount);
        super.setAmountForLanguageTranslationRate(amountForLanguageTranslationRate);
        super.setAmountForUrgencyRate(amountForUrgencyRate);
    }

    public String getDebtAccountURL() {
        return TreasuryEventDefaultMethods.getDebtAccountURL((TreasuryEvent)this);
    }

    public boolean isTuitionEvent() {
        return this.isForRegistrationTuition() || this.isForStandaloneTuition() || this.isForExtracurricularTuition();
    }

    public boolean isAcademicServiceRequestEvent() {
        return this.isForAcademicServiceRequest();
    }

    public boolean isAcademicTax() {
        return this.isForAcademicTax();
    }

    public boolean isImprovementTax() {
        return this.isForImprovementTax();
    }

    public boolean isExempted() {
        return TreasuryEventDefaultMethods.isExempted((TreasuryEvent)this);
    }

    public boolean isDueDateExpired(LocalDate when) {
        return TreasuryEventDefaultMethods.isDueDateExpired((TreasuryEvent)this, when);
    }

    public boolean isBlockingAcademicalActs(LocalDate when) {
        return TreasuryEventDefaultMethods.isBlockingAcademicalActs((TreasuryEvent)this, when);
    }

    public LocalDate getDueDate() {
        return DebitEntry.findActive((TreasuryEvent)this).sorted(DebitEntry.COMPARE_BY_DUE_DATE).map(l -> l.getDueDate()).findFirst().orElse(null);
    }

    public LocalDate getDueDate(Product product) {
        return DebitEntry.findActive((TreasuryEvent)this, (Product)product).sorted(DebitEntry.COMPARE_BY_DUE_DATE).map(l -> l.getDueDate()).findFirst().orElse(null);
    }

    public String getExemptionReason() {
        return TreasuryEventDefaultMethods.getExemptionReason((TreasuryEvent)this);
    }

    public String getExemptionTypeName() {
        return TreasuryEventDefaultMethods.getExemptionTypeName((TreasuryEvent)this, AcademicTreasuryConstants.DEFAULT_LANGUAGE);
    }

    public String getExemptionTypeName(Locale locale) {
        return TreasuryEventDefaultMethods.getExemptionTypeName((TreasuryEvent)this, locale);
    }

    public List<IAcademicTreasuryEventPayment> getPaymentsList() {
        return TreasuryEventDefaultMethods.getPaymentsList((TreasuryEvent)this);
    }

    public void invokeSettlementCallbacks(SettlementNote settlementNote) {
        if (this.isForTreasuryEventTarget()) {
            ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)this);
        }
    }

    public void invokeSettlementCallbacks(TreasuryExemption treasuryExemption) {
        if (this.isForTreasuryEventTarget()) {
            ((IAcademicTreasuryTarget)this.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)this);
        }
    }

    public BigDecimal getBaseAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.baseAmount.unavailable", new String[0]);
        }
        return super.getBaseAmount();
    }

    public BigDecimal getAdditionalUnitsAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.additionalUnitsAmount.unavailable", new String[0]);
        }
        return super.getAmountForAdditionalUnits();
    }

    public BigDecimal getMaximumAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.maximumAmount.unavailable", new String[0]);
        }
        return super.getMaximumAmount();
    }

    public BigDecimal getPagesAmount() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.pagesAmount.unavailable", new String[0]);
        }
        return super.getAmountForPages();
    }

    public BigDecimal getAmountForLanguageTranslationRate() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.amountForLanguageTranslationRate.unavailable", new String[0]);
        }
        return super.getAmountForLanguageTranslationRate();
    }

    public BigDecimal getAmountForUrgencyRate() {
        if (!this.isChargedWithDebitEntry()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.amountForUrgencyRate.unavailable", new String[0]);
        }
        return super.getAmountForUrgencyRate();
    }

    public String formatMoney(BigDecimal moneyValue) {
        return TreasuryEventDefaultMethods.formatMoney((TreasuryEvent)this, moneyValue);
    }

    public boolean isOnlinePaymentsActive() {
        return TreasuryEventDefaultMethods.isOnlinePaymentsActive((TreasuryEvent)this);
    }

    public void annulDebts(String reason) {
        TreasuryEventDefaultMethods.annulDebts((TreasuryEvent)this, reason);
    }

    public List<IPaymentReferenceCode> getPaymentReferenceCodesList() {
        return TreasuryEventDefaultMethods.getPaymentReferenceCodesList((TreasuryEvent)this);
    }

    protected List<DebitEntry> orderedTuitionDebitEntriesList() {
        if (!this.isForRegistrationTuition()) {
            throw new AcademicTreasuryDomainException("error.AcademicTreasuryEvent.only.tuition.for.registration.supported", new String[0]);
        }
        return DebitEntry.findActive((TreasuryEvent)this).sorted((a, b) -> a.getExternalId().compareTo(b.getExternalId())).collect(Collectors.toList());
    }

    public String getERPIntegrationMetadata() {
        String degreeCode = "";
        String executionYear = "";
        if (this.getDegree() != null) {
            degreeCode = this.getDegree().getCode();
        } else if (this.getPropertiesMap().containsKey((Object)AcademicTreasuryEventKeys.DEGREE_CODE)) {
            degreeCode = (String)this.getPropertiesMap().get((Object)AcademicTreasuryEventKeys.DEGREE_CODE);
        }
        if (this.getExecutionYear() != null) {
            executionYear = this.getExecutionYear().getQualifiedName();
        } else if (this.getPropertiesMap().containsKey((Object)AcademicTreasuryEventKeys.EXECUTION_YEAR)) {
            executionYear = (String)this.getPropertiesMap().get((Object)AcademicTreasuryEventKeys.EXECUTION_YEAR);
        }
        return "{\"" + AcademicTreasuryEventKeys.DEGREE_CODE + "\":\"" + degreeCode + "\",\"" + AcademicTreasuryEventKeys.EXECUTION_YEAR + "\":\"" + executionYear + "\"}";
    }

    public LocalizedString getEventTargetCurrentState() {
        try {
            if (this.isForAcademicServiceRequest()) {
                return this.getAcademicRequestStateDescription();
            }
            if (this.isForAcademicTax()) {
                return this.registrationStateDescription();
            }
            if (this.isForExtracurricularTuition()) {
                return this.registrationStateDescription();
            }
            if (this.isForImprovementTax()) {
                return this.registrationStateDescription();
            }
            if (this.isForRegistrationTuition()) {
                return this.registrationStateDescription();
            }
            if (this.isForStandaloneTuition()) {
                return this.registrationStateDescription();
            }
            if (this.isForTreasuryEventTarget()) {
                IAcademicTreasuryTarget target = (IAcademicTreasuryTarget)this.getTreasuryEventTarget();
                return target.getEventTargetCurrentState();
            }
            if (this.isLegacy()) {
                return new LocalizedString();
            }
            if (this.isCustomAcademicDebt()) {
                return this.registrationStateDescription();
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return new LocalizedString();
    }

    private LocalizedString getAcademicRequestStateDescription() {
        ITreasuryServiceRequest request = this.getITreasuryServiceRequest();
        AcademicServiceRequest serviceRequest = (AcademicServiceRequest)request;
        AcademicServiceRequestSituationType currentSituationType = serviceRequest.getAcademicServiceRequestSituationType();
        if (currentSituationType != null) {
            LocalizedString ls = new LocalizedString();
            for (Locale locale : TreasuryConstants.getAvailableLocales()) {
                ls = ls.with(locale, currentSituationType.getLocalizedName(locale));
            }
            return ls;
        }
        return new LocalizedString();
    }

    private LocalizedString registrationStateDescription() {
        Registration registration = this.getRegistration();
        RegistrationStateType activeStateType = registration.getActiveStateType();
        if (activeStateType != null) {
            return activeStateType.getName();
        }
        return new LocalizedString();
    }

    @Deprecated
    public void setAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        super.setAcademicServiceRequest(academicServiceRequest);
    }

    public void setITreasuryServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest) {
        super.setAcademicServiceRequest((AcademicServiceRequest)iTreasuryServiceRequest);
    }

    @Deprecated
    public AcademicServiceRequest getAcademicServiceRequest() {
        return super.getAcademicServiceRequest();
    }

    public ITreasuryServiceRequest getITreasuryServiceRequest() {
        return (ITreasuryServiceRequest)super.getAcademicServiceRequest();
    }

    public String getPersonName() {
        if (this.getPerson() != null) {
            return this.getPerson().getName();
        }
        return null;
    }

    public FinantialEntity getAssociatedFinantialEntity() {
        if (this.getDegree() != null) {
            Degree degree = this.getDegree();
            FinantialEntity finantialEntityOfDegree = AcademicTreasuryConstants.getFinantialEntityOfDegree(degree, this.getTreasuryEventDate());
            return finantialEntityOfDegree;
        }
        return super.getAssociatedFinantialEntity();
    }

    public BigDecimal getRegistrationTuitionAmountToPayIncludingOtherTuitionRelatedEmolumentsAndExcludingInterests() {
        if (!this.isForRegistrationTuition()) {
            throw new RuntimeException("error.AcademicTreasuryEvent.getRegistrationTuitionAmountToPayIncludingOtherTuitionRelatedEmolumentsAndExcludingInterests.invalid.event.type");
        }
        BigDecimal registrationTuitionAmount = this.getAmountWithVatToPay().subtract(this.getInterestsAmountToPay());
        Predicate<TreasuryEvent> considerTreasuryEvents = t -> {
            if (!(t instanceof AcademicTreasuryEvent)) {
                return true;
            }
            AcademicTreasuryEvent ate = (AcademicTreasuryEvent)((Object)t);
            if (ate.isForRegistrationTuition()) {
                return false;
            }
            if (ate.isForStandaloneTuition()) {
                return false;
            }
            return !ate.isForExtracurricularTuition();
        };
        BigDecimal otherTuitionAmount = AcademicTreasuryEvent.getAllAcademicTreasuryEventsOfPerson(this.getPerson()).stream().map(TreasuryEvent.class::cast).filter(t -> t != this).filter(considerTreasuryEvents).filter(t -> t.isEventAccountedAsTuition()).filter(t -> this.getExecutionYear().getQualifiedName().equals(t.getExecutionYearName())).filter(t -> this.getDegreeCode().equals(t.getDegreeCode())).map(t -> t.getAmountWithVatToPay().subtract(t.getInterestsAmountToPay())).reduce(BigDecimal.ZERO, BigDecimal::add);
        return registrationTuitionAmount.add(otherTuitionAmount);
    }

    public static void registerAcademicTreasuryEvent(Function<Person, Set<IAcademicTreasuryEvent>> reader) {
        ACADEMIC_TREASURY_READERS.add(reader);
    }

    public static Set<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsOfPerson(Person person) {
        HashSet<IAcademicTreasuryEvent> result = new HashSet<IAcademicTreasuryEvent>();
        AcademicTreasuryEvent.find(person).collect(Collectors.toCollection(() -> result));
        ACADEMIC_TREASURY_READERS.stream().flatMap(reader -> ((Set)reader.apply(person)).stream()).collect(Collectors.toCollection(() -> result));
        return result;
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(AcademicTreasuryEvent.class);
        ACADEMIC_TREASURY_READERS = new HashSet<Function<Person, Set<IAcademicTreasuryEvent>>>();
    }

    public static enum AcademicTreasuryEventKeys {
        ACADEMIC_SERVICE_REQUEST_NAME("1"),
        ACADEMIC_SERVICE_REQUEST_NUMBER_YEAR("2"),
        EXECUTION_YEAR("3"),
        EXECUTION_SEMESTER("4"),
        EVALUATION_SEASON("5"),
        DETAILED("6"),
        URGENT("7"),
        LANGUAGE("8"),
        BASE_AMOUNT("9"),
        UNITS_FOR_BASE("10"),
        UNIT_AMOUNT("11"),
        ADDITIONAL_UNITS("12"),
        CALCULATED_UNITS_AMOUNT("13"),
        PAGE_AMOUNT("14"),
        NUMBER_OF_PAGES("15"),
        CALCULATED_PAGES_AMOUNT("16"),
        MAXIMUM_AMOUNT("17"),
        AMOUNT_WITHOUT_RATES("18"),
        FOREIGN_LANGUAGE_RATE("19"),
        CALCULATED_FOREIGN_LANGUAGE_RATE("20"),
        URGENT_PERCENTAGE("21"),
        CALCULATED_URGENT_AMOUNT("22"),
        FINAL_AMOUNT("23"),
        TUITION_PAYMENT_PLAN("24"),
        TUITION_PAYMENT_PLAN_CONDITIONS("25"),
        TUITION_CALCULATION_TYPE("26"),
        FIXED_AMOUNT("27"),
        ECTS_CREDITS("28"),
        AMOUNT_PER_ECTS("29"),
        ENROLLED_COURSES("30"),
        AMOUNT_PER_COURSE("31"),
        DUE_DATE("32"),
        DEGREE("33"),
        DEGREE_CODE("34"),
        DEGREE_CURRICULAR_PLAN("35"),
        ENROLMENT("36"),
        FACTOR("37"),
        TOTAL_ECTS_OR_UNITS("38"),
        COURSE_FUNCTION_COST("39"),
        DEFAULT_TUITION_TOTAL_AMOUNT("40"),
        USED_DATE("41"),
        TUITION_PAYOR_DEBT_ACCOUNT("42"),
        EFFECTIVE_TUITION_PAYMENT_PLAN("43"),
        CUSTOM_CALCULATOR("44"),
        CALCULATED_AMOUNT_TYPE("45");

        private String code;

        private AcademicTreasuryEventKeys(String code) {
            this.code = code;
        }

        public LocalizedString getDescriptionI18N() {
            return AcademicTreasuryConstants.academicTreasuryBundleI18N("label." + AcademicTreasuryEventKeys.class.getSimpleName() + "." + this.name(), new String[0]);
        }

        public static String valueFor(DebitEntry debitEntry, AcademicTreasuryEventKeys key) {
            if (debitEntry.getPropertiesMap() == null) {
                return null;
            }
            LocalizedString descriptionI18N = key.getDescriptionI18N();
            if (debitEntry.getPropertiesMap().containsKey(descriptionI18N.getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE))) {
                return (String)debitEntry.getPropertiesMap().get(descriptionI18N.getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
            }
            return null;
        }
    }
}

