/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class AcademicTreasuryConstants {
    private static final int SCALE = 20;
    public static final int EXTENDED_CURRENCY_DECIMAL_DIGITS = 4;
    public static final String BUNDLE = "resources.AcademicTreasuryResources";
    public static final BigDecimal HUNDRED_PERCENT = new BigDecimal("100.00");
    public static final BigDecimal DEFAULT_QUANTITY = new BigDecimal(1);
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD = "yyyy/MM/dd HH:mm:ss";
    public static final String STANDARD_DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final DateTime INFINITY_DATE = new DateTime().plusYears(500);
    public static final TreasuryTupleDataSourceBean SELECT_OPTION = new TreasuryTupleDataSourceBean();
    public static final Locale DEFAULT_LANGUAGE;
    public static final String DEFAULT_COUNTRY = "PT";
    public static final Locale ENGLISH_LANGUAGE;

    @Deprecated
    public static boolean isForeignLanguage(Locale language) {
        return !language.getLanguage().equals(DEFAULT_LANGUAGE.getLanguage());
    }

    @Deprecated
    public static boolean isDefaultCountry(String country) {
        if (Strings.isNullOrEmpty((String)country)) {
            return false;
        }
        return DEFAULT_COUNTRY.equals(country.toUpperCase());
    }

    public static boolean isNegative(BigDecimal value) {
        return !AcademicTreasuryConstants.isZero(value) && !AcademicTreasuryConstants.isPositive(value);
    }

    public static boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static boolean isPositive(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) < 0;
    }

    public static boolean isGreaterThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public static BigDecimal defaultScale(BigDecimal v) {
        return v.setScale(20, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return a.divide(b, 20, RoundingMode.HALF_EVEN);
    }

    public static String academicTreasuryBundle(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(BUNDLE, key, args);
    }

    public static String academicTreasuryBundle(Locale locale, String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(locale, BUNDLE, key, args);
    }

    public static LocalizedString academicTreasuryBundleI18N(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundleI18N(BUNDLE, key, args);
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, LocalDate when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when.toDateTimeAtStartOfDay());
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, DateTime when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when);
    }

    public static Integer getNumberOfUnits(ITreasuryServiceRequest request) {
        if (request.hasNumberOfUnits()) {
            return request.getNumberOfUnits();
        }
        if (request.hasNumberOfDays()) {
            return request.getNumberOfDays();
        }
        Integer numberOfApprovedExtraCurriculum = request.hasApprovedExtraCurriculum() ? request.getApprovedExtraCurriculum().size() : 0;
        Integer numberOfApprovedStandaloneCurriculum = request.hasApprovedStandaloneCurriculum() ? request.getApprovedStandaloneCurriculum().size() : 0;
        Integer numberOfApprovedEnrolments = request.hasApprovedEnrolments() ? request.getApprovedEnrolments().size() : 0;
        Integer numberOfCurriculum = request.hasCurriculum() ? request.getCurriculum().size() : 0;
        int numberOfEnrolments = request.hasEnrolmentsByYear() ? request.getEnrolmentsByYear().size() : 0;
        numberOfEnrolments += request.hasStandaloneEnrolmentsByYear() ? request.getStandaloneEnrolmentsByYear().size() : 0;
        return numberOfApprovedExtraCurriculum + numberOfApprovedStandaloneCurriculum + numberOfApprovedEnrolments + numberOfCurriculum + (numberOfEnrolments += request.hasExtracurricularEnrolmentsByYear() ? request.getExtracurricularEnrolmentsByYear().size() : 0);
    }

    public static FinantialEntity getFinantialEntityOfDegree(Degree degree, LocalDate when) {
        return AcademicTreasuryConstants.getFinantialEntityOfUnit(degree.getUnit(), when);
    }

    public static FinantialEntity getFinantialEntityOfUnit(Unit unit, LocalDate when) {
        if (unit == null) {
            return null;
        }
        List candidateFinantialEntities = unit.getAllParentUnits().stream().map(parent -> parent.getFinantialEntity()).filter(Objects::nonNull).sorted(FinantialEntity.COMPARE_BY_NAME).collect(Collectors.toList());
        if (candidateFinantialEntities.size() == 1) {
            return (FinantialEntity)candidateFinantialEntities.iterator().next();
        }
        if (candidateFinantialEntities.size() > 1) {
            return (FinantialEntity)candidateFinantialEntities.iterator().next();
        }
        return null;
    }

    public static Set<Degree> readDegrees(FinantialEntity finantialEntity) {
        if (finantialEntity.getUnit() != null) {
            return finantialEntity.getUnit().getAllSubUnits().stream().filter(u -> u.isDegreeUnit()).filter(u -> u.getDegree() != null).map(u -> u.getDegree()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Registration registration, ExecutionInterval executionInterval) {
        return Sets.newHashSet(AcademicTreasuryConstants.findStatuteTypes(registration, executionInterval));
    }

    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return AcademicTreasuryConstants.findStatuteTypesByYear(registration, (ExecutionYear)executionInterval);
        }
        return AcademicTreasuryConstants.findStatuteTypesByChildInterval(registration, executionInterval);
    }

    private static Collection<StatuteType> findStatuteTypesByYear(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            result.addAll(AcademicTreasuryConstants.findStatuteTypesByChildInterval(registration, executionInterval));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypesByChildInterval(Registration registration, ExecutionInterval executionInterval) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionInterval(executionInterval) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionInterval executionInterval) {
        return AcademicTreasuryConstants.findVisibleStatuteTypes(registration, executionInterval).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        return AcademicTreasuryConstants.findStatuteTypes(registration, executionInterval).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }

    public static PhysicalAddress createPhysicalAddress(Person person, Country countryOfResidence, String districtOfResidence, String districtSubdivisionOfResidence, String areaCode, String address) {
        PhysicalAddressData data = new PhysicalAddressData();
        data.setAddress(address);
        data.setCountryOfResidence(countryOfResidence);
        data.setDistrictOfResidence(districtOfResidence);
        data.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        data.setAreaCode(areaCode);
        PhysicalAddress physicalAddress = PhysicalAddress.createPhysicalAddress((Party)person, (PhysicalAddressData)data, (PartyContactType)PartyContactType.PERSONAL, (Boolean)false);
        physicalAddress.setValid();
        return physicalAddress;
    }

    static {
        SELECT_OPTION.setId("");
        try {
            SELECT_OPTION.setText(AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryTupleDataSourceBean.select.description", new String[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
            SELECT_OPTION.setText("Select Option");
        }
        DEFAULT_LANGUAGE = new Locale(DEFAULT_COUNTRY);
        ENGLISH_LANGUAGE = new Locale("EN");
    }
}

