/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$create;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$delete;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$edit;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.academictreasury.util.LocalizedStringUtil;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlanGroup
extends TuitionPaymentPlanGroup_Base {
    public static final Comparator<TuitionPaymentPlanGroup> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected TuitionPaymentPlanGroup() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TuitionPaymentPlanGroup(String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setForRegistration(forRegistration);
        this.setForStandalone(forStandalone);
        this.setForExtracurricular(forExtracurricular);
        this.setCurrentProduct(currentProduct);
        this.setBypassInstallmentNameIfSingleInstallmentApplied(false);
        this.checkRules();
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.name.required", new String[0]);
        }
        if (!(this.isForRegistration() ^ this.isForStandalone() ^ this.isForExtracurricular())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.only.one.type.supported", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForRegistration().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.registration.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForStandalone().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.standalone.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForExtracurricular().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.extracurricular.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findByCode(this.getCode()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.code.already.exists", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, Product product, boolean bl4, boolean bl5, LocalizedString localizedString2, LocalizedString localizedString3) {
        Object object = advice$edit.perform((Callable)new TuitionPaymentPlanGroup$callable$edit(this, string, localizedString, bl, bl2, bl3, product, bl4, bl5, localizedString2, localizedString3));
    }

    static /* synthetic */ void advised$edit(TuitionPaymentPlanGroup this_, String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct, boolean bypassInstallmentNameIfSingleInstallmentApplied, boolean useCustomDebitEntryDescriptionFormat, LocalizedString installmentDebitEntryDescriptionFormat, LocalizedString oneInstallmentDebitEntryDescriptionFormat) {
        super.setCode(code);
        super.setName(name);
        super.setForRegistration(forRegistration);
        super.setForStandalone(forStandalone);
        super.setForExtracurricular(forExtracurricular);
        super.setCurrentProduct(currentProduct);
        super.setBypassInstallmentNameIfSingleInstallmentApplied(bypassInstallmentNameIfSingleInstallmentApplied);
        super.setUseCustomDebitEntryDescriptionFormat(useCustomDebitEntryDescriptionFormat);
        super.setInstallmentDebitEntryDescriptionFormat(installmentDebitEntryDescriptionFormat);
        super.setOneInstallmentDebitEntryDescriptionFormat(oneInstallmentDebitEntryDescriptionFormat);
        this_.checkRules();
    }

    public boolean isForRegistration() {
        return this.getForRegistration();
    }

    public boolean isForStandalone() {
        return this.getForStandalone();
    }

    public boolean isForExtracurricular() {
        return this.getForExtracurricular();
    }

    public boolean isForImprovement() {
        return this.getForImprovement();
    }

    public boolean isBypassInstallmentNameIfSingleInstallmentApplied() {
        return this.getBypassInstallmentNameIfSingleInstallmentApplied();
    }

    public boolean isDeletable() {
        return this.getAcademicTreasuryEventSet().isEmpty() && this.getTuitionPaymentPlansSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TuitionPaymentPlanGroup$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TuitionPaymentPlanGroup this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        super.deleteDomainObject();
    }

    public static Stream<TuitionPaymentPlanGroup> findAll() {
        return FenixFramework.getDomainRoot().getTuitionPaymentPlanGroupsSet().stream();
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForRegistration() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForRegistration());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForStandalone() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForStandalone());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForImprovement() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForImprovement());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForExtracurricular() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForExtracurricular());
    }

    protected static Stream<TuitionPaymentPlanGroup> findByCode(String code) {
        return TuitionPaymentPlanGroup.findAll().filter(l -> StringNormalizer.normalize((String)l.getCode().toLowerCase()).equals(StringNormalizer.normalize((String)code).toLowerCase()));
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForRegistration() {
        return TuitionPaymentPlanGroup.findDefaultGroupForRegistration().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForStandalone() {
        return TuitionPaymentPlanGroup.findDefaultGroupForStandalone().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForExtracurricular() {
        return TuitionPaymentPlanGroup.findDefaultGroupForExtracurricular().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForImprovement() {
        return TuitionPaymentPlanGroup.findDefaultGroupForImprovement().findFirst();
    }

    public static TuitionPaymentPlanGroup create(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, Product product) {
        return (TuitionPaymentPlanGroup)((Object)advice$create.perform((Callable)new TuitionPaymentPlanGroup$callable$create(string, localizedString, bl, bl2, bl3, product)));
    }

    static /* synthetic */ TuitionPaymentPlanGroup advised$create(String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct) {
        return new TuitionPaymentPlanGroup(code, name, forRegistration, forStandalone, forExtracurricular, currentProduct);
    }

    public Set<Class<? extends TuitionConditionRule>> getAllowedConditionRules() {
        if (this.getAllowedConditionRulesSerialized() == null) {
            return new HashSet<Class<? extends TuitionConditionRule>>();
        }
        String[] allowedConditionRulesSerialized = this.getAllowedConditionRulesSerialized().split(",");
        HashSet<Class<? extends TuitionConditionRule>> result = new HashSet<Class<? extends TuitionConditionRule>>();
        for (String allowedConditionRule : allowedConditionRulesSerialized) {
            try {
                result.add(Class.forName(allowedConditionRule));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void addAllowedConditionRules(Class<? extends TuitionConditionRule> allowedConditionRules) {
        Set<Class<? extends TuitionConditionRule>> classes = this.getAllowedConditionRules();
        classes.add(allowedConditionRules);
        this.setAllowedConditionRulesSerialized(classes.stream().map(clazz -> clazz.getName()).collect(Collectors.joining(",")));
    }

    public void removeAllowedConditionRules(Class<? extends TuitionConditionRule> allowedConditionRules) {
        Set<Class<? extends TuitionConditionRule>> classes = this.getAllowedConditionRules();
        classes.remove(allowedConditionRules);
        this.setAllowedConditionRulesSerialized(classes.stream().map(t -> t.getName()).collect(Collectors.joining(",")));
    }

    public Set<Class<? extends TuitionPaymentPlanCalculator>> getAllowedTuitionPaymentPlanCalculators() {
        if (this.getAllowedTuitionPaymentPlanCalculatorsSerialized() == null) {
            return new HashSet<Class<? extends TuitionPaymentPlanCalculator>>();
        }
        String[] allowedTuitionPaymentPlanCalculatorsSerialized = this.getAllowedTuitionPaymentPlanCalculatorsSerialized().split(",");
        HashSet<Class<? extends TuitionPaymentPlanCalculator>> result = new HashSet<Class<? extends TuitionPaymentPlanCalculator>>();
        for (String allowedCalculatedAmountCalculators : allowedTuitionPaymentPlanCalculatorsSerialized) {
            try {
                result.add(Class.forName(allowedCalculatedAmountCalculators));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void addAllowedTuitionPaymentPlanCalculators(Class<? extends TuitionPaymentPlanCalculator> allowedTuitionPaymentPlanCalculators) {
        Set<Class<? extends TuitionPaymentPlanCalculator>> classes = this.getAllowedTuitionPaymentPlanCalculators();
        classes.add(allowedTuitionPaymentPlanCalculators);
        this.setAllowedTuitionPaymentPlanCalculatorsSerialized(classes.stream().map(clazz -> clazz.getName()).collect(Collectors.joining(",")));
    }

    public void removeAllowedTuitionPaymentPlanCalculators(Class<? extends TuitionPaymentPlanCalculator> allowedTuitionPaymentPlanCalculators) {
        Set<Class<? extends TuitionPaymentPlanCalculator>> classes = this.getAllowedTuitionPaymentPlanCalculators();
        classes.remove(allowedTuitionPaymentPlanCalculators);
        this.setAllowedTuitionPaymentPlanCalculatorsSerialized(classes.stream().map(t -> t.getName()).collect(Collectors.joining(",")));
    }

    public Set<Class<? extends TuitionTariffCustomCalculator>> getAllowedCalculatedAmountCalculators() {
        if (this.getAllowedCalculatedAmountCalculatorsSerialized() == null) {
            return new HashSet<Class<? extends TuitionTariffCustomCalculator>>();
        }
        String[] allowedCalculatedAmountCalculatorsSerialized = this.getAllowedCalculatedAmountCalculatorsSerialized().split(",");
        HashSet<Class<? extends TuitionTariffCustomCalculator>> result = new HashSet<Class<? extends TuitionTariffCustomCalculator>>();
        for (String allowedCalculatedAmountCalculators : allowedCalculatedAmountCalculatorsSerialized) {
            try {
                result.add(Class.forName(allowedCalculatedAmountCalculators));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void addAllowedCalculatedAmountCalculators(Class<? extends TuitionTariffCustomCalculator> allowedCalculatedAmountCalculators) {
        Set<Class<? extends TuitionTariffCustomCalculator>> classes = this.getAllowedCalculatedAmountCalculators();
        classes.add(allowedCalculatedAmountCalculators);
        this.setAllowedCalculatedAmountCalculatorsSerialized(classes.stream().map(clazz -> clazz.getName()).collect(Collectors.joining(",")));
    }

    public void removeAllowedCalculatedAmountCalculators(Class<? extends TuitionTariffCustomCalculator> allowedCalculatedAmountCalculators) {
        Set<Class<? extends TuitionTariffCustomCalculator>> classes = this.getAllowedCalculatedAmountCalculators();
        classes.remove(allowedCalculatedAmountCalculators);
        this.setAllowedCalculatedAmountCalculatorsSerialized(classes.stream().map(t -> t.getName()).collect(Collectors.joining(",")));
    }

    public LocalizedString buildDebitEntryDescription(TuitionInstallmentTariff installmentTariff, Registration registration, ExecutionYear executionYear) {
        TuitionPaymentPlan tuitionPaymentPlan = installmentTariff.getTuitionPaymentPlan();
        boolean applySingleInstallmentName = tuitionPaymentPlan.getTuitionInstallmentTariffsSet().size() == 1 && this.isBypassInstallmentNameIfSingleInstallmentApplied();
        int installmentOrder = installmentTariff.getInstallmentOrder();
        if (this.getUseCustomDebitEntryDescriptionFormat()) {
            return this.formatInstallmentName(installmentTariff.getProduct(), registration, executionYear, applySingleInstallmentName);
        }
        return this.defaultInstallmentName(registration, executionYear, applySingleInstallmentName, installmentOrder);
    }

    public LocalizedString buildDebitEntryDescription(Product product, Registration registration, ExecutionYear executionYear) {
        if (this.getUseCustomDebitEntryDescriptionFormat()) {
            return this.formatInstallmentName(product, registration, executionYear, false);
        }
        return this.defaultInstallmentName(registration, executionYear, false, product.getTuitionInstallmentOrder());
    }

    private LocalizedString formatInstallmentName(Product product, Registration registration, ExecutionYear executionYear, boolean applySingleInstallmentName) {
        LocalizedString formatToUse = applySingleInstallmentName ? this.getOneInstallmentDebitEntryDescriptionFormat() : this.getInstallmentDebitEntryDescriptionFormat();
        DegreeCurricularPlan degreeCurricularPlan = registration.getStudentCurricularPlan(executionYear).getDegreeCurricularPlan();
        LocalizedString productName = product.getName();
        String degreeCode = registration.getDegree().getCode();
        String executionYearQualifiedName = executionYear.getQualifiedName();
        LocalizedString result = TreasuryConstants.getAvailableLocales().stream().map(locale -> {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            String degreePresentationName = degreeCurricularPlan.getDegree().getPresentationName(executionYear, locale);
            String degreeName = degreeCurricularPlan.getDegree().getNameI18N(executionYear).getContent(locale);
            valueMap.put("productName", StringUtils.isNotEmpty((String)productName.getContent(locale)) ? productName.getContent(locale) : productName.getContent());
            valueMap.put("degreeCode", degreeCode);
            valueMap.put("degreePresentationName", degreePresentationName);
            valueMap.put("degreeName", degreeName);
            valueMap.put("executionYearName", executionYearQualifiedName);
            return new LocalizedString(locale, StrSubstitutor.replace((Object)formatToUse.getContent(locale), valueMap));
        }).reduce((a, c) -> a.append(c)).get();
        return result;
    }

    private LocalizedString defaultInstallmentName(Registration registration, ExecutionYear executionYear, boolean applySingleInstallmentName, int installmentOrder) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        Object label = "label.TuitionInstallmentTariff.debitEntry.name.";
        if (this.isForRegistration()) {
            label = applySingleInstallmentName ? (String)label + "registration.one.installment" : (String)label + "registration";
        } else if (this.isForStandalone()) {
            label = (String)label + "standalone";
        } else if (this.isForExtracurricular()) {
            label = (String)label + "extracurricular";
        }
        DegreeCurricularPlan degreeCurricularPlan = registration.getStudentCurricularPlan(executionYear).getDegreeCurricularPlan();
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            String installmentName;
            if (this.isForRegistration()) {
                installmentName = AcademicTreasuryConstants.academicTreasuryBundle(locale, (String)label, String.valueOf(installmentOrder), degreeCurricularPlan.getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName());
                result = result.with(locale, installmentName);
                continue;
            }
            if (!this.isForStandalone() && !this.isForExtracurricular()) continue;
            installmentName = AcademicTreasuryConstants.academicTreasuryBundle(locale, (String)label, degreeCurricularPlan.getDegree().getPresentationName(executionYear, locale), executionYear.getQualifiedName());
            result = result.with(locale, installmentName);
        }
        return result;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = (o1, o2) -> {
            int c = o1.getName().getContent().compareTo(o2.getName().getContent());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

