/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.tuition.recalculation.complete.tests;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentTest;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academictreasury.base.BasicAcademicTreasuryUtils;
import org.fenixedu.academictreasury.base.FenixFrameworkRunner;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxEventTarget;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.tuition.RegistrationTuitionService;
import org.fenixedu.academictreasury.tuition.TuitionPaymentPlanTestsUtilities;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@RunWith(value=FenixFrameworkRunner.class)
public class TestRegistrationTuitionRecalculationTestTwentyFive {
    private static Registration registration;
    private static ExecutionInterval executionInterval;
    private static ExecutionYear executionYear;

    @BeforeClass
    public static void init() {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                EnrolmentTest.initEnrolments();
                TuitionPaymentPlanTestsUtilities.startUp();
                AcademicTreasuryBootstrapper.bootstrap();
                BasicAcademicTreasuryUtils.createReservationTaxes();
                TestRegistrationTuitionRecalculationTestTwentyFive.createTuitionPaymentPlanWithAmountByEcts();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static TuitionPaymentPlan createTuitionPaymentPlanWithAmountByEcts() {
        registration = (Registration)Student.readStudentByNumber((Integer)1).getRegistrationStream().findAny().orElseThrow();
        StudentCurricularPlan scp = registration.getLastStudentCurricularPlan();
        executionInterval = ExecutionInterval.findFirstCurrentChild((AcademicCalendarRootEntry)scp.getDegree().getCalendar());
        executionYear = executionInterval.getExecutionYear();
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()).getCurrentProduct(), (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), TestRegistrationTuitionRecalculationTestTwentyFive.readFinantialEntity(), executionYear);
        bean.setDefaultPaymentPlan(true);
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan();
        bean.addDegreeCurricularPlans(degreeCurricularPlan);
        bean.setDegreeType(degreeCurricularPlan.getDegreeType());
        AcademicTariffBean academicTariffBean = new AcademicTariffBean(1);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(7);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(2);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(30);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(3);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_3_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(60);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(4);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(90);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        return TuitionPaymentPlan.create((TuitionPaymentPlanBean)bean);
    }

    private static void ensureNecessaryAcademicDataIsAvailable() {
        registration.getRegistrationProtocol().setPayGratuity(Boolean.valueOf(true));
        if (Country.readByTwoLetterCode((String)"PT") == null) {
            new Country(TestRegistrationTuitionRecalculationTestTwentyFive.ls("Portugal"), TestRegistrationTuitionRecalculationTestTwentyFive.ls("Portugal"), "PT", "PRT").setDefaultCountry(Boolean.valueOf(true));
        }
        registration.getPerson().editSocialSecurityNumber("999999990", PersonCustomer.createSaftDefaultPhysicalAddress((Person)registration.getPerson()));
    }

    @Test
    public void doRecalculation() {
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitDebitEntriesWithSettledAmount(Boolean.valueOf(true));
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitCreditEntriesWithSettledAmount(Boolean.valueOf(true));
        TestRegistrationTuitionRecalculationTestTwentyFive.createTuitionPaymentPlanWithAmountByEcts();
        TestRegistrationTuitionRecalculationTestTwentyFive.ensureNecessaryAcademicDataIsAvailable();
        ReservationTaxEventTarget.createReservationTaxDebt((ReservationTax)((ReservationTax)ReservationTax.findUniqueActiveByProduct((Product)((Product)Product.findUniqueByCode((String)"RT1").get())).get()), (Person)registration.getPerson(), (DegreeCurricularPlan)registration.getLastStudentCurricularPlan().getDegreeCurricularPlan(), (ExecutionInterval)executionYear, (LocalDate)new LocalDate());
        Product firstInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get();
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("40")).applyEnrolledCoursesCount(new BigDecimal("5")).withInferedTuitionPaymentPlan().restrictForInstallmentProducts(Set.of(firstInstallmentProduct)).withoutInstallmentsRecalculation().executeTuitionPaymentPlanCreation();
        AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)AcademicTreasuryEvent.findUniqueForRegistrationTuition((Registration)registration, (ExecutionYear)executionYear).get();
        Assert.assertEquals((Object)new BigDecimal("50.00"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("350.00"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        DebitEntry firstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).iterator().next();
        DocumentNumberSeries settleDocumentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForSettlementNote(), (FinantialEntity)firstInstallment.getFinantialEntity());
        SettlementNoteBean settlementNoteBean = new SettlementNoteBean(firstInstallment.getDebtAccount(), false, false);
        settlementNoteBean.setDocNumSeries(settleDocumentNumberSeries);
        settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)firstInstallment).setSettledAmount(new BigDecimal("40.00"));
        settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)firstInstallment).setIncluded(true);
        settlementNoteBean.setFinantialEntity(firstInstallment.getFinantialEntity());
        settlementNoteBean.getPaymentEntries().add(new SettlementNoteBean.PaymentEntryBean(new BigDecimal("40.00"), PaymentMethod.findByCode((String)"NU"), null));
        SettlementNote.createSettlementNote((SettlementNoteBean)settlementNoteBean);
        Assert.assertEquals((long)1L, (long)firstInstallment.getSettlementEntriesSet().size());
        Assert.assertEquals((long)2L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        Assert.assertEquals((Object)new BigDecimal("40.00"), (Object)firstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("280.00"), (Object)firstInstallment.getNetExemptedAmount());
        DebitEntry secondFirstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).filter(d -> d != firstInstallment).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("10.00"), (Object)secondFirstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("70.00"), (Object)secondFirstInstallment.getNetExemptedAmount());
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("40")).applyEnrolledCoursesCount(new BigDecimal("5")).withInferedTuitionPaymentPlan().withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).recalculateInstallments(Map.of(firstInstallmentProduct, new LocalDate())).executeTuitionPaymentPlanCreation();
        Product secondInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get();
        Assert.assertEquals((Object)false, (Object)firstInstallment.isAnnulled());
        Assert.assertEquals((Object)false, (Object)firstInstallment.isEventAnnuled());
        Assert.assertEquals((Object)false, (Object)secondFirstInstallment.isAnnulled());
        Assert.assertEquals((Object)false, (Object)secondFirstInstallment.isEventAnnuled());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).count());
        DebitEntry secondInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("400.00"), (Object)secondInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("0"), (Object)secondInstallment.getNetExemptedAmount());
        Assert.assertEquals((Object)new BigDecimal("1250.00"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("350.00"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)5L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent).count());
        Assert.assertEquals((long)2L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        Assert.assertEquals((Object)new BigDecimal("50.00"), (Object)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).map(InvoiceEntry_Base::getAmountWithVat).reduce(BigDecimal.ZERO, BigDecimal::add));
        Assert.assertEquals((Object)new BigDecimal("350.00"), (Object)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).map(DebitEntry::getAvailableNetExemptedAmountForCredit).reduce(BigDecimal.ZERO, BigDecimal::add));
        Product fourthInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get();
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)fourthInstallmentProduct).count());
        DebitEntry fourthInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)fourthInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("400.00"), (Object)fourthInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("0"), (Object)fourthInstallment.getNetExemptedAmount());
    }

    private static FinantialEntity readFinantialEntity() {
        return (FinantialEntity)FinantialEntity.findAll().iterator().next();
    }

    public static LocalizedString ls(String string) {
        return new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, string);
    }
}

