/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.List;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;

public interface IAcademicDebtGenerationRuleStrategy {
    public boolean isAppliedOnTuitionDebitEntries();

    public boolean isAppliedOnAcademicTaxDebitEntries();

    public boolean isAppliedOnOtherDebitEntries();

    public boolean isToCreateDebitEntries();

    default public boolean isToApplyEventDebitEntriesMustEqualRuleProducts() {
        return this.isToCreateDebitEntries();
    }

    public boolean isToAggregateDebitEntries();

    public boolean isToCloseDebitNote();

    public boolean isToCreatePaymentReferenceCodes();

    public boolean isEntriesRequired();

    public boolean isToAlignAcademicTaxesDueDate();

    default public boolean isToApplyOptionForEntriesAggregationInDebitNote() {
        return false;
    }

    default public boolean isAggregateAllOrNothingDefaultValue() {
        return true;
    }

    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule var1);

    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule var1, Registration var2);

    public static Stream<? extends DebitEntry> findActiveDebitEntries(PersonCustomer customer, TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive((TreasuryEvent)treasuryEvent).filter(d -> d.getDebtAccount().getCustomer() == customer);
    }

    public static Stream<? extends DebitEntry> findActiveDebitEntries(PersonCustomer customer, TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findActive((TreasuryEvent)treasuryEvent, (Product)product).filter(d -> d.getDebtAccount().getCustomer() == customer);
    }
}

