/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import java.util.Optional;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionAllocation_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionDebtPostingType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class TuitionAllocation
extends TuitionAllocation_Base {
    public TuitionAllocation() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setResponsible(TreasuryConstants.getAuthenticatedUsername());
    }

    public TuitionAllocation(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Registration registration, ExecutionInterval executionInterval, TuitionDebtPostingType tuitionDebtPostingType, TuitionPaymentPlan tuitionPaymentPlan, Set<TreasuryExemptionType> treasuryExemptionTypesSet) {
        this();
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup);
        this.setRegistration(registration);
        this.setExecutionInterval(executionInterval);
        this.setTuitionDebtPostingType(tuitionDebtPostingType);
        this.setTuitionPaymentPlan(tuitionPaymentPlan);
        this.getTreasuryExemptionTypesSet().addAll(treasuryExemptionTypesSet);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new RuntimeException("error.TuitionAllocation.domainRoot.required");
        }
        if (this.getFinantialEntity() == null) {
            throw new RuntimeException("error.TuitionAllocation.finantialEntity.required");
        }
        if (this.getRegistration() == null) {
            throw new RuntimeException("error.TuitionAllocation.registration.required");
        }
        if (this.getTuitionPaymentPlanGroup() == null) {
            throw new RuntimeException("error.TuitionAllocation.tuitionPaymentPlanGroup.required");
        }
        if (this.getExecutionInterval() == null) {
            throw new RuntimeException("error.TuitionAllocation.executionInterval.required");
        }
        if (this.getTuitionPaymentPlan() == null) {
            throw new RuntimeException("error.TuitionAllocation.tuitionPaymentPlan.required");
        }
        if (this.getTuitionDebtPostingType() == null) {
            throw new RuntimeException("error.TuitionAllocation.tuitionDebtPostingType.required");
        }
        if (this.getRegistration().getTuitionAllocationsSet().stream().filter(e -> e != this).filter(e -> e.getTuitionPaymentPlanGroup() == this.getTuitionPaymentPlanGroup()).filter(e -> e.getTuitionDebtPostingType() == this.getTuitionDebtPostingType()).anyMatch(e -> e.getExecutionInterval() == this.getExecutionInterval())) {
            throw new AcademicTreasuryDomainException("error.TuitionAllocation.duplicated", new String[0]);
        }
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setExecutionInterval(null);
        super.setRegistration(null);
        super.setTuitionDebtPostingType(null);
        super.setTuitionPaymentPlanGroup(null);
        super.setTuitionPaymentPlan(null);
        this.getTreasuryExemptionTypesSet().forEach(t -> this.removeTreasuryExemptionTypes((TreasuryExemptionType)t));
        super.deleteDomainObject();
    }

    public FinantialEntity getFinantialEntity() {
        return this.getTuitionDebtPostingType().getFinantialEntity();
    }

    public void edit(TuitionPaymentPlan tuitionPaymentPlan, Set<TreasuryExemptionType> treasuryExemptionTypesSet) {
        this.setTuitionPaymentPlan(tuitionPaymentPlan);
        this.getTreasuryExemptionTypesSet().clear();
        this.getTreasuryExemptionTypesSet().addAll(treasuryExemptionTypesSet);
        this.checkRules();
    }

    public static TuitionAllocation create(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Registration registration, ExecutionInterval executionInterval, TuitionDebtPostingType tuitionDebtPostingType, TuitionPaymentPlan tuitionPaymentPlan, Set<TreasuryExemptionType> treasuryExemptionTypesSet) {
        return new TuitionAllocation(tuitionPaymentPlanGroup, registration, executionInterval, tuitionDebtPostingType, tuitionPaymentPlan, treasuryExemptionTypesSet);
    }

    public static Optional<TuitionAllocation> findUnique(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Registration registration, ExecutionInterval executionInterval, TuitionDebtPostingType tuitionDebtPostingType) {
        return registration.getTuitionAllocationsSet().stream().filter(t -> t.getTuitionPaymentPlanGroup() == tuitionPaymentPlanGroup).filter(t -> t.getExecutionInterval() == executionInterval).filter(t -> t.getTuitionDebtPostingType() == tuitionDebtPostingType).findFirst();
    }
}

