/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.customer;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.EmailAddress_Base;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$changeFiscalNumber;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$create;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$delete;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer_Base;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalDataUpdateLog;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.debt.balancetransfer.BalanceTransferService;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry_Base;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class PersonCustomer
extends PersonCustomer_Base {
    private static final String STUDENT_CODE = "STUDENT";
    private static final String CANDIDACY_CODE = "CANDIDATE";
    public static final Comparator<PersonCustomer> IMPROVED_SORT_BY_PERSON_MERGE;
    @Deprecated
    public static final Comparator<PersonCustomer> OLD_AND_DEPRECATED_SORT_BY_PERSON_MERGE;
    public static final Advice advice$delete;
    public static final Advice advice$changeFiscalNumber;
    public static final Advice advice$create;

    public PersonCustomer() {
    }

    protected PersonCustomer(Person person, String fiscalAddressCountryCode, String fiscalNumber) {
        this();
        if (!"999999990".equals(this.getFiscalNumber()) && PersonCustomer.find(this.getPerson(), this.getAddressCountryCode(), this.getFiscalNumber()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.customer.duplicated", new String[0]);
        }
        if (person.getPersonCustomer() != null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.already.has.person.customer", new String[0]);
        }
        this.setPerson(person);
        this.setCustomerType(PersonCustomer.getDefaultCustomerType(this));
        super.setAddressCountryCode(fiscalAddressCountryCode);
        super.setFiscalNumber(fiscalNumber);
        if (!FiscalCodeValidation.isValidFiscalNumber((String)this.getAddressCountryCode(), (String)this.getFiscalNumber())) {
            throw new TreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        this.checkRules();
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toSet())) {
            DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)this);
        }
        if (TreasuryDebtProcessMainService.isCustomerFiscalNumberInvalid((Customer)this)) {
            List reasonsList = TreasuryDebtProcessMainService.getCustomerFiscalNumberInvalidReason((Customer)this);
            throw new IllegalArgumentException(String.join((CharSequence)",", reasonsList.stream().map(l -> l.getContent()).collect(Collectors.toList())));
        }
    }

    public void checkRules() {
        Person person;
        Set customers;
        super.checkRules();
        if (this.getPerson() == null && this.getPersonForInactivePersonCustomer() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getAddressCountryCode())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.countryCode", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getFiscalNumber())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalNumber", new String[0]);
        }
        if (this.getPerson() != null && this.getPersonForInactivePersonCustomer() != null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.may.only.be.related.to.person.with.one.relation", new String[0]);
        }
        if (this.isActive() && this.getPerson().getFiscalAddress() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.fiscalAddress.required", new String[0]);
        }
        if (this.isActive() && this.getPerson().getFiscalAddress().getCountryOfResidence() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.countryOfResidence.required", new String[0]);
        }
        if (this.isActive() && !TreasuryConstants.isSameCountryCode((String)this.getPerson().getFiscalAddress().getCountryOfResidence().getCode(), (String)this.getAddressCountryCode())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.countryOfResidence.is.not.equal.of.customer", new String[0]);
        }
        if ("999999990".equals(this.getFiscalNumber()) && !TreasuryConstants.isDefaultCountry((String)this.getAddressCountryCode())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.default.fiscal.number.applied.only.to.default.country", new String[0]);
        }
        if (!(!this.isActive() || TreasuryConstants.isDefaultCountry((String)this.getAddressCountryCode()) && "999999990".equals(this.getFiscalNumber()) || (customers = PersonCustomer.findByFiscalInformation((String)this.getAddressCountryCode(), (String)this.getFiscalNumber()).filter(c -> c.isPersonCustomer()).filter(c -> c.isActive()).collect(Collectors.toSet())).size() <= 1)) {
            PersonCustomer self = this;
            Set otherCustomers = customers.stream().filter(arg_0 -> PersonCustomer.lambda$checkRules$3((Customer)self, arg_0)).map(c -> c.getName()).collect(Collectors.toSet());
            throw new TreasuryDomainException("error.Customer.customer.with.fiscal.information.exists", new String[]{Joiner.on((String)", ").join(otherCustomers)});
        }
        Person person2 = person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        if (!"999999990".equals(this.getFiscalNumber()) && PersonCustomer.find(person, this.getAddressCountryCode(), this.getFiscalNumber()).filter(pc -> !pc.isFromPersonMerge()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.customer.duplicated", new String[0]);
        }
    }

    public String getCode() {
        return super.getCode();
    }

    public String getCodeFromSuper() {
        return super.getCode();
    }

    public Person getAssociatedPerson() {
        return this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
    }

    public static String fiscalNumber(Person person) {
        return person.getSocialSecurityNumber();
    }

    public String getName() {
        return this.getAssociatedPerson().getName();
    }

    public String getFirstNames() {
        return this.getAssociatedPerson().getGivenNames();
    }

    public String getLastNames() {
        return this.getAssociatedPerson().getFamilyNames();
    }

    public String getEmail() {
        return this.getAssociatedPerson().getDefaultEmailAddressValue();
    }

    public String getPersonalEmail() {
        return this.getAssociatedPerson().getPartyContactsSet().stream().filter(PartyContact::isEmailAddress).map(EmailAddress.class::cast).filter(PartyContact::isActiveAndValid).filter(e -> !StringUtils.isBlank((String)e.getValue())).filter(e -> e.getType() == PartyContactType.PERSONAL).sorted(EmailAddress.COMPARATOR_BY_EMAIL).findFirst().map(EmailAddress_Base::getValue).orElse(null);
    }

    public String getPhoneNumber() {
        Person person = this.getAssociatedPerson();
        if (!Strings.isNullOrEmpty((String)person.getDefaultPhoneNumber())) {
            return person.getDefaultPhoneNumber();
        }
        return person.getDefaultMobilePhoneNumber();
    }

    public String getMobileNumber() {
        return this.getAssociatedPerson().getDefaultMobilePhoneNumber();
    }

    public String getIdentificationNumber() {
        return PersonCustomer.identificationNumber(this.getAssociatedPerson());
    }

    public static String identificationNumber(Person person) {
        return person.getDocumentIdNumber();
    }

    @Deprecated
    public PhysicalAddress getPhysicalAddress() {
        return PersonCustomer.physicalAddress(this.getAssociatedPerson());
    }

    @Deprecated
    public static PhysicalAddress physicalAddress(Person person) {
        if (person.getDefaultPhysicalAddress() != null) {
            return person.getDefaultPhysicalAddress();
        }
        if (PersonCustomer.pendingOrValidPhysicalAddresses(person).size() == 1) {
            return PersonCustomer.pendingOrValidPhysicalAddresses(person).get(0);
        }
        return null;
    }

    private static List<PhysicalAddress> pendingOrValidPhysicalAddresses(Person person) {
        Comparator comparator = (o1, o2) -> {
            if (o1.isValid() && !o2.isValid()) {
                return -1;
            }
            if (!o1.isValid() && o2.isValid()) {
                return 1;
            }
            return 10 * PhysicalAddress.COMPARATOR_BY_ADDRESS.compare(o1, o2) + o1.getExternalId().compareTo(o2.getExternalId());
        };
        return person.getAllPartyContacts(PhysicalAddress.class).stream().map(PhysicalAddress.class::cast).filter(pc -> pc.isValid()).sorted(comparator).collect(Collectors.toList());
    }

    public PhysicalAddress getFiscalAddress() {
        return PersonCustomer.fiscalAddress(this.getAssociatedPerson());
    }

    public static PhysicalAddress fiscalAddress(Person person) {
        return person.getFiscalAddress();
    }

    public String getAddress() {
        if (!this.isActive()) {
            return super.getAddress();
        }
        return PersonCustomer.address(this.getFiscalAddress());
    }

    public static String address(PhysicalAddress physicalAddress) {
        if (physicalAddress == null) {
            return null;
        }
        return physicalAddress.getAddress();
    }

    public String getDistrictSubdivision() {
        if (!this.isActive()) {
            return super.getDistrictSubdivision();
        }
        return PersonCustomer.districtSubdivision(this.getFiscalAddress());
    }

    public static String districtSubdivision(PhysicalAddress physicalAddress) {
        if (physicalAddress == null) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getDistrictSubdivisionOfResidence())) {
            return physicalAddress.getDistrictSubdivisionOfResidence();
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getArea())) {
            return physicalAddress.getArea();
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getDistrictOfResidence())) {
            return physicalAddress.getDistrictOfResidence();
        }
        return null;
    }

    public String getRegion() {
        if (!this.isActive()) {
            return super.getRegion();
        }
        return PersonCustomer.region(this.getFiscalAddress());
    }

    public static String region(PhysicalAddress physicalAddress) {
        if (physicalAddress == null) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getDistrictOfResidence())) {
            return physicalAddress.getDistrictOfResidence();
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getDistrictSubdivisionOfResidence())) {
            return physicalAddress.getDistrictSubdivisionOfResidence();
        }
        if (!Strings.isNullOrEmpty((String)physicalAddress.getArea())) {
            return physicalAddress.getArea();
        }
        return null;
    }

    public String getZipCode() {
        if (!this.isActive()) {
            return super.getZipCode();
        }
        return PersonCustomer.zipCode(this.getFiscalAddress());
    }

    public static String zipCode(PhysicalAddress physicalAddress) {
        if (physicalAddress == null) {
            return null;
        }
        return physicalAddress.getAreaCode();
    }

    public static String addressCountryCode(Person person) {
        PhysicalAddress fiscalAddress = person.getFiscalAddress();
        return PersonCustomer.addressCountryCode(fiscalAddress);
    }

    public static String addressCountryCode(PhysicalAddress physicalAddress) {
        if (physicalAddress == null) {
            return null;
        }
        if (physicalAddress.getCountryOfResidence() == null) {
            return null;
        }
        return physicalAddress.getCountryOfResidence().getCode();
    }

    public static String addressUiFiscalPresentationValue(PhysicalAddress pa) {
        ArrayList<String> compounds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)PersonCustomer.address(pa))) {
            compounds.add(PersonCustomer.address(pa));
        }
        if (StringUtils.isNotEmpty((String)PersonCustomer.zipCode(pa))) {
            compounds.add(PersonCustomer.zipCode(pa));
        }
        if (StringUtils.isNotEmpty((String)PersonCustomer.districtSubdivision(pa))) {
            compounds.add(PersonCustomer.districtSubdivision(pa));
        }
        if (pa.getCountryOfResidence() != null) {
            compounds.add(pa.getCountryOfResidence().getLocalizedName().getContent());
        }
        return String.join((CharSequence)" ", compounds);
    }

    public static boolean isValidFiscalNumber(Person person) {
        return person.getFiscalAddress() != null && FiscalCodeValidation.isValidFiscalNumber((String)PersonCustomer.addressCountryCode(person), (String)PersonCustomer.fiscalNumber(person));
    }

    public String getNationalityCountryCode() {
        Person person = this.getAssociatedPerson();
        if (person.getCountry() != null) {
            return person.getCountry().getCode();
        }
        return null;
    }

    public String getBusinessIdentification() {
        Person person = this.getAssociatedPerson();
        if (person.getStudent() != null) {
            return person.getStudent().getNumber().toString();
        }
        return this.getIdentificationNumber();
    }

    public String getPaymentReferenceBaseCode() {
        return this.getCode();
    }

    public boolean isPersonCustomer() {
        return true;
    }

    public boolean isActive() {
        return this.getPerson() != null;
    }

    public boolean isFromPersonMerge() {
        return this.getFromPersonMerge();
    }

    public boolean isDeletable() {
        return this.getDebtAccountsSet().stream().allMatch(da -> da.isDeletable());
    }

    public Customer getActiveCustomer() {
        if (this.isActive()) {
            return this;
        }
        Person person = this.getPersonForInactivePersonCustomer();
        Optional<? extends PersonCustomer> activeCustomer = PersonCustomer.findUnique(person, PersonCustomer.addressCountryCode(person), PersonCustomer.fiscalNumber(person));
        if (!activeCustomer.isPresent()) {
            return null;
        }
        if (!activeCustomer.get().isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.getActiveCustomer.customer.found.but.not.active", new String[]{PersonCustomer.addressCountryCode(person), PersonCustomer.fiscalNumber(person)});
        }
        return (Customer)activeCustomer.get();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PersonCustomer$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PersonCustomer this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PersonCustomer.cannot.delete", new String[0]);
        }
        super.setPersonForInactivePersonCustomer(null);
        super.setPerson(null);
        for (DebtAccount debtAccount : this_.getDebtAccountsSet()) {
            debtAccount.delete();
        }
        super.delete();
    }

    public boolean isBlockingAcademicalActs(LocalDate when) {
        if (DebtAccount.find((Customer)this).map(da -> TreasuryConstants.isGreaterThan((BigDecimal)da.getTotalInDebt(), (BigDecimal)BigDecimal.ZERO)).reduce((a, c) -> a != false || c != false).orElse(Boolean.FALSE).booleanValue()) {
            return DebitEntry.find((Customer)this).map(d -> PersonCustomer.isDebitEntryBlockingAcademicalActs(d, when)).reduce((a, c) -> a != false || c != false).orElse(Boolean.FALSE);
        }
        return DebtAccount.find((Customer)this).anyMatch(da -> !da.getPaymentPlansNotCompliantSet(when).isEmpty());
    }

    public static boolean isDebitEntryBlockingAcademicalActs(DebitEntry debitEntry, LocalDate when) {
        if (debitEntry.isAnnulled()) {
            return false;
        }
        if (!debitEntry.isInDebt()) {
            return false;
        }
        if (!debitEntry.isBlockAcademicActsOnDebt() && !debitEntry.isDueDateExpired(when)) {
            return false;
        }
        if (debitEntry.getOpenPaymentPlan() != null && debitEntry.getOpenPaymentPlan().isCompliant(when)) {
            return false;
        }
        if (!AcademicTreasurySettings.getInstance().isAcademicalActBlocking(debitEntry.getProduct())) {
            return false;
        }
        return !debitEntry.isAcademicalActBlockingSuspension();
    }

    public String getUsername() {
        return this.getAssociatedPerson().getUsername();
    }

    public BigDecimal getGlobalBalance() {
        Person person;
        BigDecimal globalBalance = BigDecimal.ZERO;
        Person person2 = person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        if (person.getPersonCustomer() != null) {
            for (DebtAccount debtAccount : person.getPersonCustomer().getDebtAccountsSet()) {
                globalBalance = globalBalance.add(debtAccount.getTotalInDebt());
            }
        }
        for (PersonCustomer personCustomer : person.getInactivePersonCustomersSet()) {
            for (DebtAccount debtAccount : personCustomer.getDebtAccountsSet()) {
                globalBalance = globalBalance.add(debtAccount.getTotalInDebt());
            }
        }
        return globalBalance;
    }

    public BigDecimal getGlobalDueInDebt() {
        Person person;
        BigDecimal globalDueInDebt = BigDecimal.ZERO;
        Person person2 = person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        if (person.getPersonCustomer() != null) {
            for (DebtAccount debtAccount : person.getPersonCustomer().getDebtAccountsSet()) {
                globalDueInDebt = globalDueInDebt.add(debtAccount.getDueInDebt());
            }
        }
        for (PersonCustomer personCustomer : person.getInactivePersonCustomersSet()) {
            for (DebtAccount debtAccount : personCustomer.getDebtAccountsSet()) {
                globalDueInDebt = globalDueInDebt.add(debtAccount.getDueInDebt());
            }
        }
        return globalDueInDebt;
    }

    public Set<Customer> getAllCustomers() {
        return PersonCustomer.find(this.getAssociatedPerson()).collect(Collectors.toSet());
    }

    public void mergeWithPerson(Person personToDelete) {
        if (this.getPerson() == personToDelete) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.merging.not.happening", new String[0]);
        }
        if (this.getPersonForInactivePersonCustomer() == personToDelete) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.merged.already.with.person", new String[0]);
        }
        if (personToDelete.getPersonCustomer() != null) {
            PersonCustomer personCustomer = personToDelete.getPersonCustomer();
            personCustomer.saveFiscalAddressFieldsFromPersonInCustomer();
            personCustomer.setPersonForInactivePersonCustomer(this.getPerson());
            personCustomer.setPerson(null);
            personCustomer.setFromPersonMerge(true);
            personCustomer.checkRules();
        }
        for (PersonCustomer personCustomer : personToDelete.getInactivePersonCustomersSet()) {
            personCustomer.setPersonForInactivePersonCustomer(this.getPerson());
            personCustomer.setFromPersonMerge(true);
            personCustomer.checkRules();
        }
        Person thisPerson = this.getAssociatedPerson();
        for (AcademicTreasuryEvent e : Sets.newHashSet((Iterable)personToDelete.getAcademicTreasuryEventSet())) {
            e.mergeToTargetPerson(thisPerson);
        }
        this.checkRules();
    }

    public void changeFiscalNumber(AdhocCustomerBean adhocCustomerBean, PhysicalAddress physicalAddress) {
        Object object = advice$changeFiscalNumber.perform((Callable)new PersonCustomer$callable$changeFiscalNumber(this, adhocCustomerBean, physicalAddress));
    }

    static /* synthetic */ void advised$changeFiscalNumber(PersonCustomer this_, AdhocCustomerBean bean, PhysicalAddress fiscalAddress) {
        if (!Strings.isNullOrEmpty((String)this_.getErpCustomerId())) {
            throw new TreasuryDomainException("warning.Customer.changeFiscalNumber.maybe.integrated.in.erp", new String[0]);
        }
        String oldAddressFiscalCountry = this_.getAddressCountryCode();
        String oldFiscalNumber = this_.getFiscalNumber();
        boolean changeFiscalNumberConfirmed = bean.isChangeFiscalNumberConfirmed();
        boolean withFinantialDocumentsIntegratedInERP = this_.isWithFinantialDocumentsIntegratedInERP();
        boolean customerInformationMaybeIntegratedWithSuccess = false;
        boolean customerWithFinantialDocumentsIntegratedInPreviousERP = this_.isCustomerWithFinantialDocumentsIntegratedInPreviousERP();
        if (!bean.isChangeFiscalNumberConfirmed()) {
            throw new TreasuryDomainException("message.Customer.changeFiscalNumber.confirmation", new String[0]);
        }
        String addressCountryCode = fiscalAddress.getCountryOfResidence().getCode();
        String fiscalNumber = bean.getFiscalNumber();
        if (Strings.isNullOrEmpty((String)addressCountryCode)) {
            throw new TreasuryDomainException("error.Customer.countryCode.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscalNumber.required", new String[0]);
        }
        if (PersonCustomer.lowerCase((String)addressCountryCode).equals(PersonCustomer.lowerCase((String)this_.getAddressCountryCode())) && fiscalNumber.equals(this_.getFiscalNumber())) {
            throw new TreasuryDomainException("error.Customer.already.with.fiscal.information", new String[0]);
        }
        if (this_.isFiscalAddressFromDefaultCountry() && this_.isFiscalCodeValid()) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.already.valid", new String[0]);
        }
        if (withFinantialDocumentsIntegratedInERP) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.documents.integrated.erp", new String[0]);
        }
        if (!FiscalCodeValidation.isValidFiscalNumber((String)addressCountryCode, (String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        Optional<? extends PersonCustomer> customerOptional = PersonCustomer.findUnique(this_.getAssociatedPerson(), addressCountryCode, fiscalNumber);
        if (this_.isActive()) {
            if (customerOptional.isPresent()) {
                throw new TreasuryDomainException("error.Customer.changeFiscalNumber.customer.exists.for.fiscal.number", new String[0]);
            }
            this_.setAddressCountryCode(addressCountryCode);
            this_.setFiscalNumber(fiscalNumber);
            if (this_.getPerson().getFiscalAddress() != null) {
                this_.getPerson().getFiscalAddress().setFiscalAddress(false);
            }
            this_.getPerson().editSocialSecurityNumber(fiscalNumber, fiscalAddress);
        } else {
            if (customerOptional.isPresent()) {
                this_.setFromPersonMerge(true);
            }
            this_.setAddressCountryCode(addressCountryCode);
            this_.setFiscalNumber(fiscalNumber);
            this_.saveFiscalAddressFieldsInCustomer(fiscalAddress);
        }
        this_.checkRules();
        FiscalDataUpdateLog.create((Customer)this_, (String)oldAddressFiscalCountry, (String)oldFiscalNumber, (boolean)changeFiscalNumberConfirmed, (boolean)withFinantialDocumentsIntegratedInERP, (boolean)false, (boolean)customerWithFinantialDocumentsIntegratedInPreviousERP);
    }

    public Set<? extends TreasuryEvent> getTreasuryEventsSet() {
        Person person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        HashSet result = Sets.newHashSet();
        for (IAcademicTreasuryEvent event : AcademicTreasuryEvent.getAllAcademicTreasuryEventsOfPerson(person)) {
            result.add((TreasuryEvent)event);
        }
        result.addAll(this.getDebtAccountsSet().stream().flatMap(d -> d.getTreasuryEventsSet().stream()).collect(Collectors.toSet()));
        return result;
    }

    public boolean isUiOtherRelatedCustomerActive() {
        return !this.isActive() && this.getActiveCustomer() != null;
    }

    public String uiRedirectToActiveCustomer(String url) {
        if (this.isActive() || !this.isUiOtherRelatedCustomerActive()) {
            return url + "/" + this.getExternalId();
        }
        return url + "/" + this.getActiveCustomer().getExternalId();
    }

    public static String uiPersonFiscalNumber(Person person) {
        String fiscalCountry = !Strings.isNullOrEmpty((String)PersonCustomer.addressCountryCode(person)) ? PersonCustomer.addressCountryCode(person) : "";
        String fiscalNumber = !Strings.isNullOrEmpty((String)PersonCustomer.fiscalNumber(person)) ? PersonCustomer.fiscalNumber(person) : "";
        return fiscalCountry + " " + fiscalNumber;
    }

    public LocalizedString getIdentificationTypeDesignation() {
        Person person = this.getAssociatedPerson();
        if (person.getIdDocumentType() != null) {
            LocalizedString result = new LocalizedString();
            for (Locale locale : TreasuryConstants.getAvailableLocales()) {
                result = result.with(locale, person.getIdDocumentType().getLocalizedName(locale));
            }
            return result;
        }
        return null;
    }

    public String getIdentificationTypeCode() {
        Person person = this.getAssociatedPerson();
        if (person.getIdDocumentType() != null) {
            return person.getIdDocumentType().getName();
        }
        return null;
    }

    public String getIban() {
        return this.getAssociatedPerson().getIban();
    }

    public void saveFiscalAddressFieldsFromPersonInCustomer() {
        PhysicalAddress fiscalAddress = PersonCustomer.fiscalAddress(this.getAssociatedPerson());
        if (fiscalAddress == null) {
            return;
        }
        this.saveFiscalAddressFieldsInCustomer(fiscalAddress);
    }

    public void saveFiscalAddressFieldsInCustomer(PhysicalAddress fiscalAddress) {
        if (fiscalAddress == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.updateFiscalAddress.fiscalAddress.required", new String[0]);
        }
        if (fiscalAddress.getCountryOfResidence() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.updateFiscalAddress.countryOfResidence.required", new String[0]);
        }
        if (!TreasuryConstants.isSameCountryCode((String)this.getAddressCountryCode(), (String)fiscalAddress.getCountryOfResidence().getCode())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.countryOfResidence.is.not.equal.of.customer", new String[0]);
        }
        super.setAddress(PersonCustomer.address(fiscalAddress));
        super.setDistrictSubdivision(PersonCustomer.districtSubdivision(fiscalAddress));
        super.setRegion(PersonCustomer.region(fiscalAddress));
        super.setZipCode(PersonCustomer.zipCode(fiscalAddress));
    }

    protected void inactivateCustomer() {
        if (!this.isActive()) {
            throw new AcademicTreasuryDomainException("error.Person.inactivateCustomer.customer.not.active", new String[0]);
        }
        Person person = this.getAssociatedPerson();
        this.setPerson(null);
        this.setPersonForInactivePersonCustomer(person);
        this.checkRules();
    }

    protected void activateCustomer() {
        if (this.isActive()) {
            throw new AcademicTreasuryDomainException("error.Person.activateCustomer.customer.active", new String[0]);
        }
        Person person = this.getAssociatedPerson();
        this.setPerson(person);
        this.setPersonForInactivePersonCustomer(null);
        this.checkRules();
    }

    public static Stream<? extends PersonCustomer> findAll() {
        return Customer.findAll().filter(c -> c instanceof PersonCustomer).map(PersonCustomer.class::cast);
    }

    public static Stream<? extends PersonCustomer> find(Person person) {
        HashSet result = Sets.newHashSet();
        if (person != null) {
            PersonCustomer personCustomer = person.getPersonCustomer();
            if (personCustomer != null) {
                result.add(personCustomer);
            }
            result.addAll(person.getInactivePersonCustomersSet());
        }
        return result.stream();
    }

    public static Stream<? extends PersonCustomer> find(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.find(person).filter(pc -> !Strings.isNullOrEmpty((String)pc.getAddressCountryCode()) && TreasuryConstants.isSameCountryCode((String)pc.getAddressCountryCode(), (String)fiscalCountryCode) && !Strings.isNullOrEmpty((String)pc.getFiscalNumber()) && pc.getFiscalNumber().equals(fiscalNumber));
    }

    public static Optional<? extends PersonCustomer> findUnique(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.find(person, fiscalCountryCode, fiscalNumber).sorted(IMPROVED_SORT_BY_PERSON_MERGE).findFirst();
    }

    public static PersonCustomer createWithCurrentFiscalInformation(Person person) {
        if (person.getFiscalAddress() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalAddress.required", new String[0]);
        }
        if (person.getFiscalAddress().getCountryOfResidence() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalAddress.countryOfResidence.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)person.getSocialSecurityNumber())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalNumber.required", new String[0]);
        }
        Country countryOfResidence = person.getFiscalAddress().getCountryOfResidence();
        return PersonCustomer.create(person, countryOfResidence.getCode(), person.getSocialSecurityNumber());
    }

    public static PersonCustomer activePersonCustomer(Person person) {
        return person.getPersonCustomer();
    }

    public static Set<PersonCustomer> inactivePersonCustomers(Person person) {
        return person.getInactivePersonCustomersSet();
    }

    public static PersonCustomer create(Person person, String string, String string2) {
        return (PersonCustomer)((Object)advice$create.perform((Callable)new PersonCustomer$callable$create(person, string, string2)));
    }

    static /* synthetic */ PersonCustomer advised$create(Person person, String fiscalAddressCountryCode, String fiscalNumber) {
        return new PersonCustomer(person, fiscalAddressCountryCode, fiscalNumber);
    }

    public static boolean switchCustomer(Person person, String fiscalAddressCountryCode, String fiscalNumber) {
        PersonCustomer currentPersonCustomer = person.getPersonCustomer();
        Optional<? extends PersonCustomer> newCustomer = PersonCustomer.findUnique(person, fiscalAddressCountryCode, fiscalNumber);
        if (newCustomer.isPresent() && newCustomer.get().isActive()) {
            return false;
        }
        if (currentPersonCustomer != null) {
            currentPersonCustomer.inactivateCustomer();
        }
        if (!newCustomer.isPresent()) {
            PersonCustomer.create(person, fiscalAddressCountryCode, fiscalNumber);
            newCustomer = PersonCustomer.findUnique(person, fiscalAddressCountryCode, fiscalNumber);
        } else {
            newCustomer.get().activateCustomer();
        }
        if (currentPersonCustomer != null && newCustomer.isPresent()) {
            for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toSet())) {
                BalanceTransferService balanceTransferService;
                if (!StringUtils.isNotEmpty((String)finantialInstitution.getBalanceTransferServiceImplementationClass())) continue;
                DebtAccount currentPersonCustomerDebtAccount = currentPersonCustomer.getDebtAccountFor(finantialInstitution);
                DebtAccount newPersonCustomerDebtAccount = newCustomer.get().getDebtAccountFor(finantialInstitution);
                if (currentPersonCustomerDebtAccount == null || newPersonCustomerDebtAccount == null || !(balanceTransferService = BalanceTransferService.getService((DebtAccount)currentPersonCustomerDebtAccount, (DebtAccount)newPersonCustomerDebtAccount)).isAutoTransferInSwitchDebtAccountsEnabled()) continue;
                balanceTransferService.transferBalance();
            }
        }
        return true;
    }

    public static CustomerType getDefaultCustomerType(PersonCustomer person) {
        if (person.getPerson().getStudent() == null && !CustomerType.findByCode((String)CANDIDACY_CODE).findFirst().isEmpty()) {
            return (CustomerType)CustomerType.findByCode((String)CANDIDACY_CODE).findFirst().get();
        }
        return (CustomerType)CustomerType.findByCode((String)STUDENT_CODE).findFirst().get();
    }

    public static Set<InvoiceEntry> getAllPendingInvoiceEntriesForPerson(Person person) {
        ArrayList<PersonCustomer> result = new ArrayList<PersonCustomer>();
        Optional.ofNullable(PersonCustomer.activePersonCustomer(person)).ifPresent(p -> result.add((PersonCustomer)((Object)p)));
        result.addAll(PersonCustomer.inactivePersonCustomers(person));
        Set invoiceEntries = result.stream().flatMap(f -> f.getDebtAccountsSet().stream()).flatMap(f2 -> f2.getPendingInvoiceEntriesSet().stream()).map(InvoiceEntry.class::cast).collect(Collectors.toSet());
        Comparator<InvoiceEntry> INVOICE_ENTRY_COMPARATOR = Comparator.comparing(InvoiceEntry::getDueDate).thenComparing(FinantialDocumentEntry_Base::getDescription).thenComparing(AbstractDomainObject::getExternalId);
        TreeSet<InvoiceEntry> resultSorted = new TreeSet<InvoiceEntry>(INVOICE_ENTRY_COMPARATOR);
        resultSorted.addAll(invoiceEntries);
        return resultSorted;
    }

    public static PhysicalAddress createSaftDefaultPhysicalAddress(Person person) {
        String unknownAddress = AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTreasuryBridgeImpl.unknown.address", new String[0]);
        PhysicalAddress result = AcademicTreasuryConstants.createPhysicalAddress(person, Country.readDefault(), unknownAddress, unknownAddress, "0000-000", unknownAddress);
        result.setValid();
        return result;
    }

    public static boolean createPersonCustomerIfMissing(Person person) {
        String fiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            return false;
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return true;
        }
        PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        return true;
    }

    private static /* synthetic */ boolean lambda$checkRules$3(Customer self, Customer c) {
        return c != self;
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changeFiscalNumber = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        IMPROVED_SORT_BY_PERSON_MERGE = Comparator.comparing(PersonCustomer::isActive).reversed().thenComparing(PersonCustomer::isFromPersonMerge).thenComparing(AbstractDomainObject::getExternalId);
        OLD_AND_DEPRECATED_SORT_BY_PERSON_MERGE = (o1, o2) -> {
            if (!o1.isFromPersonMerge() && o2.isFromPersonMerge()) {
                return -1;
            }
            if (o1.isFromPersonMerge() && !o2.isFromPersonMerge()) {
                return 1;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

