/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.util;

import com.google.common.collect.Lists;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import com.qubit.terra.framework.tools.excel.SheetProcessor;
import com.qubit.terra.framework.tools.excel.XlsType;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.fenixedu.academictreasury.util.ExcelSheet;

public class ExcelUtils {
    public static List<List<String>> readExcel(InputStream stream, int maxCols) throws IOException {
        TreasuryDefaultExcelSheetProcessor sheetProcessor = new TreasuryDefaultExcelSheetProcessor(maxCols, false);
        sheetProcessor.setIncludeHeader(true);
        ExcelUtil.importExcel((XlsType)XlsType.XLSX, (InputStream)stream, (SheetProcessor)sheetProcessor);
        return sheetProcessor.getSpreadsheetContent();
    }

    public static List<ExcelSheet> readExcelSheets(InputStream stream, int maxCols) throws IOException {
        TreasuryDefaultExcelSheetProcessor sheetProcessor = new TreasuryDefaultExcelSheetProcessor(maxCols, true);
        sheetProcessor.setIncludeHeader(true);
        ExcelUtil.importExcel((XlsType)XlsType.XLSX, (InputStream)stream, (SheetProcessor)sheetProcessor);
        return sheetProcessor.getResult();
    }

    private static class TreasuryDefaultExcelSheetProcessor
    extends SheetProcessor {
        private final boolean readAllSheets;
        List<List<String>> spreadsheetContent;
        final List<ExcelSheet> result = Lists.newArrayList();

        public TreasuryDefaultExcelSheetProcessor(int maxCols, boolean readAllSheets) {
            this.readAllSheets = readAllSheets;
            this.setRowProcessor(row -> {
                ArrayList<String> rowContent = new ArrayList<String>();
                this.spreadsheetContent.add(rowContent);
                if (row == null) {
                    for (int j = 0; j < maxCols; ++j) {
                        rowContent.add("");
                    }
                    return;
                }
                for (int j = 0; j < maxCols; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) {
                        rowContent.add("");
                        continue;
                    }
                    if (CellType.NUMERIC == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
                        rowContent.add(new SimpleDateFormat("dd/MM/yyyy HH:mm").format(cell.getDateCellValue()));
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    String value = cell.getStringCellValue();
                    rowContent.add(value);
                }
            });
        }

        protected void beforeSheetProcess(Sheet sheet) {
            super.beforeSheetProcess(sheet);
            this.spreadsheetContent = new ArrayList<List<String>>();
        }

        public List<List<String>> getSpreadsheetContent() {
            return this.spreadsheetContent;
        }

        protected void afterSheetProcess(Sheet sheet) {
            super.afterSheetProcess(sheet);
            this.result.add(new ExcelSheet(sheet.getSheetName(), this.getSpreadsheetContent()));
        }

        public List<ExcelSheet> getResult() {
            return this.result;
        }

        protected Function<Workbook, List<Sheet>> getSheetsToProcessSupplier() {
            return this.readAllSheets ? workbook -> {
                int numberOfSheets = workbook.getNumberOfSheets();
                ArrayList<Sheet> sheets = new ArrayList<Sheet>(numberOfSheets);
                for (int i = 0; i < numberOfSheets; ++i) {
                    sheets.add(workbook.getSheetAt(i));
                }
                return sheets;
            } : super.getSheetsToProcessSupplier();
        }
    }
}

